/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.info;

import java.awt.Rectangle;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;

final class PyramidLevelInfo {
    private int pyramidLevel;
    private int xTiles;
    private int yTiles;
    private final GeneralEnvelope spatialExtent;
    private GridEnvelope2D gridEnvelope;

    PyramidLevelInfo(int level, int numTilesWide, int numTilesHigh, GridEnvelope gridEnvelope, GeneralEnvelope spatialExtent) {
        this.pyramidLevel = level;
        this.spatialExtent = spatialExtent;
        this.gridEnvelope = new GridEnvelope2D(gridEnvelope.getLow(0), gridEnvelope.getLow(1), gridEnvelope.getSpan(0), gridEnvelope.getSpan(1));
        this.xTiles = numTilesWide;
        this.yTiles = numTilesHigh;
    }

    public int getLevel() {
        return this.pyramidLevel;
    }

    public double getXRes() {
        return this.spatialExtent.getSpan(0) / (double)this.gridEnvelope.getSpan(0);
    }

    public double getYRes() {
        return this.spatialExtent.getSpan(1) / (double)this.gridEnvelope.getSpan(1);
    }

    public int getNumTilesWide() {
        return this.xTiles;
    }

    public int getNumTilesHigh() {
        return this.yTiles;
    }

    public GeneralEnvelope getSpatialExtent() {
        return new GeneralEnvelope((Envelope)this.spatialExtent);
    }

    public GridEnvelope getGridEnvelope() {
        return new GridEnvelope2D((Rectangle)this.gridEnvelope);
    }

    public String toString() {
        return "[level: " + this.pyramidLevel + " size: " + this.gridEnvelope.getSpan(0) + "x" + this.gridEnvelope.getSpan(1) + " Grid: " + this.gridEnvelope + "  xRes: " + this.getXRes() + "  yRes: " + this.getYRes() + "  xOffset: " + this.gridEnvelope.getLow(0) + "  yOffset: " + this.gridEnvelope.getLow(1) + "  extent: " + this.spatialExtent.getMinimum(0) + "," + this.spatialExtent.getMinimum(1) + "," + this.spatialExtent.getMaximum(0) + "," + this.spatialExtent.getMaximum(1) + "  tilesWide: " + this.xTiles + "  tilesHigh: " + this.yTiles + "]";
    }
}

