/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.info;

import com.esri.sde.sdk.client.SeRaster;
import org.geotools.util.NumberRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RasterCellType {
    TYPE_16BIT_S(16, 2, true, NumberRange.create((short)Short.MIN_VALUE, (short)Short.MAX_VALUE)),
    TYPE_16BIT_U(16, 1, false, NumberRange.create((int)0, (int)65535)),
    TYPE_1BIT(1, 0, false, NumberRange.create((byte)0, (byte)1)),
    TYPE_32BIT_REAL(32, 4, true, NumberRange.create((float)Float.MIN_VALUE, (float)Float.MAX_VALUE)),
    TYPE_32BIT_S(32, 3, true, NumberRange.create((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE)),
    TYPE_32BIT_U(64, 5, false, NumberRange.create((double)0.0, (double)(Math.pow(2.0, 32.0) - 1.0))),
    TYPE_4BIT(4, 0, false, NumberRange.create((int)0, (int)((byte)Math.pow(2.0, 4.0) - 1))),
    TYPE_64BIT_REAL(64, 5, true, NumberRange.create((double)Double.MIN_VALUE, (double)Double.MAX_VALUE)),
    TYPE_8BIT_S(8, 0, true, NumberRange.create((byte)-128, (byte)127)),
    TYPE_8BIT_U(8, 0, false, NumberRange.create((int)0, (int)255));

    private int typeId;
    private final int bitsPerSample;
    private final int dataBufferType;
    private final boolean signed;
    private final NumberRange<?> sampleValueRange;

    static {
        TYPE_16BIT_S.setSdeTypeId(SeRaster.SE_PIXEL_TYPE_16BIT_S);
        TYPE_16BIT_U.setSdeTypeId(SeRaster.SE_PIXEL_TYPE_16BIT_U);
        TYPE_1BIT.setSdeTypeId(SeRaster.SE_PIXEL_TYPE_1BIT);
        TYPE_32BIT_REAL.setSdeTypeId(SeRaster.SE_PIXEL_TYPE_32BIT_REAL);
        TYPE_32BIT_S.setSdeTypeId(SeRaster.SE_PIXEL_TYPE_32BIT_S);
        TYPE_32BIT_U.setSdeTypeId(SeRaster.SE_PIXEL_TYPE_32BIT_U);
        TYPE_4BIT.setSdeTypeId(SeRaster.SE_PIXEL_TYPE_4BIT);
        TYPE_64BIT_REAL.setSdeTypeId(SeRaster.SE_PIXEL_TYPE_64BIT_REAL);
        TYPE_8BIT_S.setSdeTypeId(SeRaster.SE_PIXEL_TYPE_8BIT_S);
        TYPE_8BIT_U.setSdeTypeId(SeRaster.SE_PIXEL_TYPE_8BIT_U);
    }

    private RasterCellType(int bitsPerSample, int dataBufferType, boolean signed, NumberRange<?> sampleValueRange) {
        this.bitsPerSample = bitsPerSample;
        this.dataBufferType = dataBufferType;
        this.signed = signed;
        this.sampleValueRange = sampleValueRange;
    }

    private void setSdeTypeId(int typeId) {
        this.typeId = typeId;
    }

    public int getSeRasterPixelType() {
        return this.typeId;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public int getDataBufferType() {
        return this.dataBufferType;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public NumberRange<?> getSampleValueRange() {
        return this.sampleValueRange;
    }

    public static RasterCellType valueOf(String string) {
        return Enum.valueOf(RasterCellType.class, string);
    }
}

