/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.info;

import com.esri.sde.sdk.client.SDEPoint;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeExtent;
import com.esri.sde.sdk.client.SeRasterAttr;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.geotools.arcsde.raster.info.PyramidLevelInfo;
import org.geotools.arcsde.raster.info.RasterBandInfo;
import org.geotools.arcsde.raster.info.RasterCellType;
import org.geotools.arcsde.raster.info.RasterUtils;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RasterInfo {
    private static final Comparator<PyramidLevelInfo> levelComparator = new Comparator<PyramidLevelInfo>(){

        @Override
        public int compare(PyramidLevelInfo p0, PyramidLevelInfo p1) {
            return p0.getLevel() - p1.getLevel();
        }
    };
    ArrayList<PyramidLevelInfo> pyramidList;
    private int tileWidth;
    private int tileHeight;
    private GeneralEnvelope originalEnvelope;
    private ArrayList<RasterBandInfo> bands;
    private CoordinateReferenceSystem crs;
    private Long rasterId;
    private final boolean skipLevelone;

    RasterInfo(SeRasterAttr rasterAttributes, CoordinateReferenceSystem crs) throws DataSourceException {
        this.crs = crs;
        try {
            this.rasterId = rasterAttributes.getRasterId().longValue();
            int numLevels = rasterAttributes.getMaxLevel() + 1;
            this.pyramidList = new ArrayList(numLevels);
            this.tileWidth = rasterAttributes.getTileWidth();
            this.tileHeight = rasterAttributes.getTileHeight();
            this.skipLevelone = rasterAttributes.skipLevelOne();
            int internalPyramidLevel = 0;
            int arcsdePyramidLevel = 0;
            while (arcsdePyramidLevel < numLevels) {
                if (arcsdePyramidLevel == 1) {
                    // empty if block
                }
                int numTilesWide = rasterAttributes.getTilesPerRowByLevel(arcsdePyramidLevel);
                int numTilesHigh = rasterAttributes.getTilesPerColByLevel(arcsdePyramidLevel);
                GridEnvelope actualImageGridEnvelope = this.computeImageGridRange(arcsdePyramidLevel, rasterAttributes);
                GeneralEnvelope actualImageSpatialExtent = this.computeImageSpatialExtent(arcsdePyramidLevel, rasterAttributes, crs, actualImageGridEnvelope);
                this.addPyramidLevel(arcsdePyramidLevel, numTilesWide, numTilesHigh, actualImageGridEnvelope, actualImageSpatialExtent);
                ++internalPyramidLevel;
                ++arcsdePyramidLevel;
            }
        }
        catch (SeException se) {
            throw new DataSourceException((Throwable)se);
        }
    }

    private GeneralEnvelope computeImageSpatialExtent(int level, SeRasterAttr rasterAttributes, CoordinateReferenceSystem crs, GridEnvelope gridRange) throws SeException {
        int imageWidth = -1 + rasterAttributes.getImageWidthByLevel(level);
        int imageHeight = -1 + rasterAttributes.getImageHeightByLevel(level);
        SeExtent levelExtent = rasterAttributes.getExtentByLevel(level);
        double minx = levelExtent.getMinX();
        double miny = levelExtent.getMinY();
        double maxx = levelExtent.getMaxX();
        double maxy = levelExtent.getMaxY();
        double w = maxx - minx;
        double h = maxy - miny;
        double resx = w / (double)imageWidth;
        double resy = h / (double)imageHeight;
        GeneralEnvelope spatialExtent = new GeneralEnvelope(crs);
        spatialExtent.setEnvelope(new double[]{minx -= resx / 2.0, miny -= resy / 2.0, maxx += resx / 2.0, maxy += resy / 2.0});
        return spatialExtent;
    }

    private GridEnvelope computeImageGridRange(int level, SeRasterAttr rasterAttributes) throws SeException {
        SDEPoint imageOffset = rasterAttributes.getImageOffsetByLevel(level);
        int xOffset = (int)(imageOffset == null ? 0.0 : imageOffset.getX());
        int yOffset = (int)(imageOffset == null ? 0.0 : imageOffset.getY());
        int imageWidth = rasterAttributes.getImageWidthByLevel(level);
        int imageHeight = rasterAttributes.getImageHeightByLevel(level);
        return new GridEnvelope2D(xOffset, yOffset, imageWidth, imageHeight);
    }

    public Long getRasterId() {
        return this.rasterId;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    RasterInfo(Long rasterId, int tileWidth, int tileHeight) {
        this.rasterId = rasterId;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.pyramidList = new ArrayList(4);
        this.skipLevelone = false;
    }

    public Dimension getTileDimension() {
        return new Dimension(this.tileWidth, this.tileHeight);
    }

    public PyramidLevelInfo getPyramidLevel(int level) {
        return this.pyramidList.get(level);
    }

    public int getNumLevels() {
        return this.pyramidList.size();
    }

    double[] getResolution(int pyramidLevel) {
        double highestRes = this.getPyramidLevel(0).getXRes();
        PyramidLevelInfo level = this.getPyramidLevel(pyramidLevel);
        double[] resolution = new double[]{level.getXRes(), level.getYRes(), level.getXRes() / highestRes};
        return resolution;
    }

    public int getOptimalPyramidLevel(OverviewPolicy policy, double[] requestedRes) {
        double requestedScaleFactor;
        double reqy;
        double requestedScaleFactorY;
        int pyramidLevelChoice = 0;
        List<double[]> resolutions = this.getValidResolutions();
        int numLevels = resolutions.size();
        double reqx = requestedRes[0];
        double[] highestRes = this.getResolution(0);
        double requestedScaleFactorX = reqx / highestRes[0];
        boolean leastReduceAxis = !(requestedScaleFactorX <= (requestedScaleFactorY = (reqy = requestedRes[1]) / highestRes[1]));
        double d = requestedScaleFactor = !leastReduceAxis ? requestedScaleFactorX : requestedScaleFactorY;
        if (numLevels == 0 || requestedScaleFactor <= 1.0) {
            pyramidLevelChoice = 0;
        } else {
            double[] min = resolutions.get(numLevels - 1);
            if (requestedScaleFactor >= min[2]) {
                pyramidLevelChoice = numLevels - 1;
            } else {
                double[] prev = highestRes;
                int levelN = 1;
                while (levelN < numLevels) {
                    double[] curr = resolutions.get(levelN);
                    if (curr[2] == requestedScaleFactor) {
                        pyramidLevelChoice = levelN;
                    } else {
                        if (curr[2] > requestedScaleFactor || levelN == numLevels - 1) {
                            if (policy == OverviewPolicy.QUALITY) {
                                pyramidLevelChoice = levelN - 1;
                                break;
                            }
                            if (policy == OverviewPolicy.SPEED) {
                                return levelN;
                            }
                            if (requestedScaleFactor - prev[2] < curr[2] - requestedScaleFactor) {
                                pyramidLevelChoice = levelN - 1;
                                break;
                            }
                            pyramidLevelChoice = levelN;
                            break;
                        }
                        prev = curr;
                    }
                    ++levelN;
                }
            }
        }
        if (pyramidLevelChoice > 0 && this.skipLevelone) {
            ++pyramidLevelChoice;
        }
        return pyramidLevelChoice;
    }

    private List<double[]> getValidResolutions() {
        ArrayList<double[]> validResolutions = new ArrayList<double[]>();
        int numLevels = this.getNumLevels();
        int l = 0;
        while (l < numLevels) {
            if (l != 1 || !this.skipLevelone) {
                validResolutions.add(this.getResolution(l));
            }
            ++l;
        }
        return validResolutions;
    }

    void addPyramidLevel(int level, ReferencedEnvelope imageExtent, Point imgOffset, Point2D extOffset, int numTilesWide, int numTilesHigh, Dimension imageSize) {
        GridEnvelope2D gridEnvelope = new GridEnvelope2D((int)imgOffset.getX(), (int)imgOffset.getY(), imageSize.width, imageSize.height);
        GeneralEnvelope spatialExtent = new GeneralEnvelope((Envelope)imageExtent);
        PyramidLevelInfo pyramidLevel = new PyramidLevelInfo(level, numTilesWide, numTilesHigh, (GridEnvelope)gridEnvelope, spatialExtent);
        this.pyramidList.add(pyramidLevel);
        Collections.sort(this.pyramidList, levelComparator);
    }

    public void addPyramidLevel(int level, int numTilesWide, int numTilesHigh, GridEnvelope gridEnvelope, GeneralEnvelope spatialExtent) {
        PyramidLevelInfo pyramidLevel = new PyramidLevelInfo(level, numTilesWide, numTilesHigh, gridEnvelope, spatialExtent);
        this.pyramidList.add(pyramidLevel);
        Collections.sort(this.pyramidList, levelComparator);
    }

    void setOriginalEnvelope(GeneralEnvelope originalEnvelope) {
        this.originalEnvelope = originalEnvelope;
    }

    public GeneralEnvelope getOriginalEnvelope() {
        return this.originalEnvelope;
    }

    public void setBands(List<RasterBandInfo> bands) {
        this.bands = new ArrayList<RasterBandInfo>(bands);
    }

    public List<RasterBandInfo> getBands() {
        return new ArrayList<RasterBandInfo>(this.bands);
    }

    public int getNumBands() {
        return this.bands.size();
    }

    public RasterBandInfo getBand(int index) {
        return this.bands.get(index);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public RasterCellType getTargetCellType() {
        List<Number> noDataValues = this.getNoDataValues();
        RasterCellType nativeCellType = this.getNativeCellType();
        RasterCellType targetCellType = RasterUtils.determineTargetCellType(nativeCellType, noDataValues);
        return targetCellType;
    }

    public boolean isColorMapped() {
        return this.getBand(0).isColorMapped();
    }

    public RasterCellType getNativeCellType() {
        return this.getBand(0).getCellType();
    }

    public List<Number> getNoDataValues() {
        ArrayList<Number> noDataValues = new ArrayList<Number>();
        for (RasterBandInfo band : this.getBands()) {
            Number noDataValue = band.getNoDataValue();
            noDataValues.add(noDataValue);
        }
        return noDataValues;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[Id: ").append(this.getRasterId());
        String srs = null;
        try {
            srs = CRS.lookupIdentifier((IdentifiedObject)this.getCoordinateReferenceSystem(), (boolean)false);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        sb.append(", bands: ").append(this.getNumBands());
        sb.append(", levels: ").append(this.getNumLevels());
        sb.append(", tile size: ").append(this.getTileWidth()).append("x").append(this.getTileHeight());
        sb.append(", crs: ").append(srs == null ? this.getCoordinateReferenceSystem().toWKT() : srs);
        GeneralEnvelope env = this.getOriginalEnvelope();
        sb.append(", Envelope: ").append(env.getMinimum(0)).append(",").append(env.getMinimum(1)).append(" ").append(env.getMaximum(0)).append(",").append(env.getMaximum(1));
        sb.append("]\n Bands[");
        for (RasterBandInfo band : this.getBands()) {
            sb.append("\n\t");
            sb.append(band.toString());
        }
        sb.append("\n ]");
        sb.append("\n Pyramid[");
        int l = 0;
        while (l < this.getNumLevels()) {
            sb.append("\n\t");
            if (l == 1 && this.skipLevelone) {
                sb.append("(skipped) ");
            }
            sb.append(this.getPyramidLevel(l).toString());
            ++l;
        }
        sb.append("\n ]");
        return sb.toString();
    }

    public boolean isSkipLevelOne() {
        return this.skipLevelone;
    }
}

