/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.info;

import java.awt.image.RenderedImage;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.coverage.grid.GridEnvelope;

public final class RasterQueryInfo {
    private GeneralEnvelope requestedEnvelope;
    private GridEnvelope requestedDim;
    private int pyramidLevel;
    private GridEnvelope matchingTiles;
    private GeneralEnvelope resultEnvelope;
    private GridEnvelope resultDimension;
    private Long rasterId;
    private GridEnvelope mosaicLocation;
    private RenderedImage resultImage;
    private GridEnvelope tiledImageGridRange;
    private double[] resolution;
    private int rasterIndex;
    private GridEnvelope levelTileRange;
    private GridEnvelope resultGridRange;

    public RasterQueryInfo() {
        this.setResultDimensionInsideTiledImage((GridEnvelope)new GridEnvelope2D(0, 0, 0, 0));
        this.setMatchingTiles((GridEnvelope)new GridEnvelope2D(0, 0, 0, 0));
        this.setResultEnvelope(null);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("[Raster query info:");
        s.append("\n\tRaster ID            : ").append(this.getRasterId());
        s.append("\n\tPyramid level        : ").append(this.getPyramidLevel());
        s.append("\n\tResolution           : ").append(String.valueOf(this.getResolution()[0]) + "," + this.getResolution()[1]);
        s.append("\n\tRequested envelope   : ").append(this.getRequestedEnvelope());
        s.append("\n\tRequested dimension  : ").append(this.getRequestedDim());
        GridEnvelope mt = this.getMatchingTiles();
        s.append("\n\tMatching tiles       : ").append(mt).append(" out of ").append("level");
        s.append("\n\tTiled image size     : ").append(this.getTiledImageGridRange());
        s.append("\n\tResult dimension     : ").append(this.getResultDimensionInsideTiledImage());
        s.append("\n\tMosaiced dimension   : ").append(this.getMosaicLocation());
        s.append("\n\tResult envelope      : ").append(this.getResultEnvelope());
        s.append("\n]");
        return s.toString();
    }

    public Long getRasterId() {
        return this.rasterId;
    }

    public GeneralEnvelope getRequestedEnvelope() {
        return this.requestedEnvelope;
    }

    public GridEnvelope getRequestedDim() {
        return this.requestedDim;
    }

    public int getPyramidLevel() {
        return this.pyramidLevel;
    }

    public GridEnvelope getMatchingTiles() {
        return this.matchingTiles;
    }

    public GeneralEnvelope getResultEnvelope() {
        return this.resultEnvelope;
    }

    @Deprecated
    public GridEnvelope getResultDimensionInsideTiledImage() {
        return this.resultDimension;
    }

    void setRasterId(Long rasterId) {
        this.rasterId = rasterId;
    }

    void setPyramidLevel(int pyramidLevel) {
        this.pyramidLevel = pyramidLevel;
    }

    void setRequestedEnvelope(GeneralEnvelope requestedEnvelope) {
        this.requestedEnvelope = requestedEnvelope;
    }

    void setRequestedDim(GridEnvelope requestedDim) {
        this.requestedDim = requestedDim;
    }

    void setResultEnvelope(GeneralEnvelope resultEnvelope) {
        this.resultEnvelope = resultEnvelope;
    }

    void setMatchingTiles(GridEnvelope matchingTiles) {
        this.matchingTiles = matchingTiles;
    }

    void setResultDimensionInsideTiledImage(GridEnvelope resultDimensionInsideTiledImage) {
        this.resultDimension = resultDimensionInsideTiledImage;
    }

    void setMosaicLocation(GridEnvelope targetRasterGridRange) {
        this.mosaicLocation = targetRasterGridRange;
    }

    public GridEnvelope getMosaicLocation() {
        return this.mosaicLocation;
    }

    public void setResultImage(RenderedImage rasterImage) {
        this.resultImage = rasterImage;
    }

    public RenderedImage getResultImage() {
        return this.resultImage;
    }

    void setTiledImageGridRange(GridEnvelope tiledImageGridRange) {
        this.tiledImageGridRange = tiledImageGridRange;
    }

    public GridEnvelope getTiledImageGridRange() {
        return this.tiledImageGridRange;
    }

    void setResolution(double[] resolution) {
        this.resolution = resolution;
    }

    public double[] getResolution() {
        double[] dArray;
        if (this.resolution == null) {
            double[] dArray2 = new double[2];
            dArray2[0] = -1.0;
            dArray = dArray2;
            dArray2[1] = -1.0;
        } else {
            dArray = this.resolution;
        }
        return dArray;
    }

    void setRasterIndex(int rasterN) {
        this.rasterIndex = rasterN;
    }

    public int getRasterIndex() {
        return this.rasterIndex;
    }

    @Deprecated
    void setLevelTileRange(GridEnvelope levelTileRange2) {
        this.levelTileRange = levelTileRange2;
    }

    @Deprecated
    public GridEnvelope getLevelTileRange() {
        return this.levelTileRange;
    }

    void setResultGridRange(GridEnvelope resultGridRange) {
        this.resultGridRange = resultGridRange;
    }

    public GridEnvelope getResultGridRange() {
        return this.resultGridRange;
    }
}

