/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.io;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeRaster;
import com.esri.sde.sdk.client.SeRasterConstraint;
import com.esri.sde.sdk.client.SeRasterTile;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.esri.sde.sdk.client.SeStreamOp;
import java.awt.Dimension;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.raster.info.RasterCellType;
import org.geotools.arcsde.raster.info.RasterDatasetInfo;
import org.geotools.arcsde.raster.io.TileDataFetcher;
import org.geotools.arcsde.raster.io.TileFetchCommand;
import org.geotools.arcsde.raster.io.TileInfo;
import org.geotools.arcsde.raster.io.TileReader;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.ISessionPool;
import org.geotools.arcsde.session.UnavailableConnectionException;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;

final class NativeTileReader
implements TileReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");
    private final RasterDatasetInfo rasterInfo;
    private final long rasterId;
    private final int pyramidLevel;
    private final GridEnvelope requestedTiles;
    private final ISessionPool sessionPool;
    private ISession session;
    private boolean started;
    private final int pixelsPerTile;
    private final int tileDataLength;
    private int bitsPerSample;
    private final RasterCellType nativeCellType;
    private QueryObjects queryObjects;
    private final TileDataFetcher dataFetcher;
    TileInfo[] tileInfo;
    private int lastTileX = -1;
    private int lastTileY = -1;
    private static final int RANDOM_THRESHOLD = Integer.MAX_VALUE;
    private int nonConsecutiveCallCount;
    private TileFetchCommand sequentialFetchCommand;

    NativeTileReader(ISessionPool sessionPool, RasterDatasetInfo rasterInfo, long rasterId, int pyramidLevel, GridEnvelope tileRange) {
        this.sessionPool = sessionPool;
        this.rasterInfo = rasterInfo;
        this.rasterId = rasterId;
        this.pyramidLevel = pyramidLevel;
        this.requestedTiles = tileRange;
        Dimension tileSize = rasterInfo.getTileDimension(rasterId);
        this.pixelsPerTile = tileSize.width * tileSize.height;
        this.nativeCellType = rasterInfo.getNativeCellType();
        this.bitsPerSample = this.nativeCellType.getBitsPerSample();
        this.tileDataLength = (int)Math.ceil((double)this.pixelsPerTile * (double)this.bitsPerSample / 8.0);
        RasterCellType targetCellType = rasterInfo.getTargetCellType(rasterId);
        this.dataFetcher = TileDataFetcher.getTileDataFetcher(this.nativeCellType, targetCellType);
        int rasterIndex = rasterInfo.getRasterIndex(rasterId);
        int maxTileX = rasterInfo.getNumTilesWide(rasterIndex, pyramidLevel) - 1;
        int maxTileY = rasterInfo.getNumTilesHigh(rasterIndex, pyramidLevel) - 1;
        if (tileRange.getLow(0) < 0 || tileRange.getLow(1) < 0 || tileRange.getHigh(0) > maxTileX || tileRange.getHigh(1) > maxTileY) {
            throw new IllegalArgumentException("Invalid tile range for raster #" + rasterId + "/" + pyramidLevel + ": " + tileRange + ". Valid range is 0.." + maxTileX + " 0.." + maxTileY);
        }
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public int getPixelsPerTile() {
        return this.pixelsPerTile;
    }

    public int getNumberOfBands() {
        return this.rasterInfo.getNumBands();
    }

    public int getTileWidth() {
        return this.rasterInfo.getTileWidth(this.rasterId);
    }

    public int getTileHeight() {
        return this.rasterInfo.getTileHeight(this.rasterId);
    }

    public int getTilesWide() {
        return this.requestedTiles.getSpan(0);
    }

    public int getTilesHigh() {
        return this.requestedTiles.getSpan(1);
    }

    public int getBytesPerTile() {
        return this.tileDataLength;
    }

    private void execute() throws IOException {
        GridEnvelope requestedTiles = this.requestedTiles;
        this.queryObjects = this.execute(requestedTiles);
        this.started = true;
        this.lastTileY = -1;
        this.lastTileX = -1;
    }

    private QueryObjects execute(GridEnvelope requestedTiles) throws IOException {
        SeRasterConstraint rConstraint;
        int rasterIndex = this.rasterInfo.getRasterIndex(this.rasterId);
        try {
            int numberOfBands = this.rasterInfo.getNumBands();
            int[] bandsToQuery = new int[numberOfBands];
            int bandN = 1;
            while (bandN <= numberOfBands) {
                bandsToQuery[bandN - 1] = bandN;
                ++bandN;
            }
            int minTileX = requestedTiles.getLow(0);
            int minTileY = requestedTiles.getLow(1);
            int maxTileX = requestedTiles.getHigh(0);
            int maxTileY = requestedTiles.getHigh(1);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Requesting tiles [x=" + minTileX + "-" + maxTileX + ", y=" + minTileY + "-" + maxTileY + "] from tile range [x=0-" + (this.rasterInfo.getNumTilesWide(rasterIndex, this.pyramidLevel) - 1) + ", y=0-" + (this.rasterInfo.getNumTilesHigh(rasterIndex, this.pyramidLevel) - 1) + "]");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Tiled image size: " + requestedTiles);
            }
            int interleaveType = SeRaster.SE_RASTER_INTERLEAVE_BIP;
            rConstraint = new SeRasterConstraint();
            rConstraint.setBands(bandsToQuery);
            rConstraint.setLevel(this.pyramidLevel);
            rConstraint.setEnvelope(minTileX, minTileY, maxTileX, maxTileY);
            rConstraint.setInterleave(interleaveType);
        }
        catch (SeException se) {
            throw new ArcSdeException(se);
        }
        try {
            if (this.session == null) {
                boolean transactional = false;
                this.session = this.sessionPool.getSession(false);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Using " + this.session + " to read raster #" + this.rasterId + " on Thread " + Thread.currentThread().getName() + ". Tile set: " + requestedTiles);
                }
            }
        }
        catch (UnavailableConnectionException e) {
            throw new RuntimeException(e);
        }
        String rasterTable = this.rasterInfo.getRasterTable();
        String rasterColumn = this.rasterInfo.getRasterColumns()[0];
        QueryRasterCommand queryCommand = new QueryRasterCommand(rConstraint, rasterTable, rasterColumn, this.rasterId);
        this.session.issue((Command)queryCommand);
        SeRow row = queryCommand.getSeRow();
        SeQuery preparedQuery = queryCommand.getPreparedQuery();
        return new QueryObjects(preparedQuery, row);
    }

    public void getTile(int tileX, int tileY, byte[][] data) throws IOException {
        assert (data == null || data.length == this.getNumberOfBands());
        int numberOfBands = this.getNumberOfBands();
        TileInfo[] tileInfo = this.getTileInfo();
        int b = 0;
        while (b < numberOfBands) {
            TileInfo t = tileInfo[b];
            t.setTileData(data[b]);
            tileInfo[b] = t;
            ++b;
        }
        this.getTile(tileX, tileY, tileInfo);
    }

    public void getTile(int tileX, int tileY, short[][] data) throws IOException {
        assert (data == null || data.length == this.getNumberOfBands());
        int numberOfBands = this.getNumberOfBands();
        TileInfo[] tileInfo = this.getTileInfo();
        int b = 0;
        while (b < numberOfBands) {
            TileInfo t = tileInfo[b];
            t.setTileData(data[b]);
            tileInfo[b] = t;
            ++b;
        }
        this.getTile(tileX, tileY, tileInfo);
    }

    private TileInfo[] getTileInfo() {
        if (this.tileInfo == null) {
            int numberOfBands = this.getNumberOfBands();
            this.tileInfo = new TileInfo[numberOfBands];
            int b = 0;
            while (b < numberOfBands) {
                TileInfo t;
                this.tileInfo[b] = t = new TileInfo(this.getPixelsPerTile());
                ++b;
            }
        }
        return this.tileInfo;
    }

    public void getTile(int tileX, int tileY, int[][] data) throws IOException {
        assert (data == null || data.length == this.getNumberOfBands());
        int numberOfBands = this.getNumberOfBands();
        TileInfo[] tileInfo = this.getTileInfo();
        int b = 0;
        while (b < numberOfBands) {
            TileInfo t = tileInfo[b];
            t.setTileData(data[b]);
            tileInfo[b] = t;
            ++b;
        }
        this.getTile(tileX, tileY, tileInfo);
    }

    public void getTile(int tileX, int tileY, float[][] data) throws IOException {
        assert (data == null || data.length == this.getNumberOfBands());
        int numberOfBands = this.getNumberOfBands();
        TileInfo[] tileInfo = this.getTileInfo();
        int b = 0;
        while (b < numberOfBands) {
            TileInfo t = tileInfo[b];
            t.setTileData(data[b]);
            tileInfo[b] = t;
            ++b;
        }
        this.getTile(tileX, tileY, tileInfo);
    }

    public void getTile(int tileX, int tileY, double[][] data) throws IOException {
        assert (data == null || data.length == this.getNumberOfBands());
        int numberOfBands = this.getNumberOfBands();
        TileInfo[] tileInfo = this.getTileInfo();
        int b = 0;
        while (b < numberOfBands) {
            TileInfo t = tileInfo[b];
            t.setTileData(data[b]);
            tileInfo[b] = t;
            ++b;
        }
        this.getTile(tileX, tileY, tileInfo);
    }

    private void getTile(int tileX, int tileY, TileInfo[] target) throws IOException {
        try {
            this.fetchTile(tileX, tileY, target);
        }
        catch (IOException e) {
            this.dispose();
            throw e;
        }
        catch (RuntimeException e) {
            this.dispose();
            throw (RuntimeException)new RuntimeException("Error geting tile " + tileX + "," + tileY + " on raster " + this.rasterInfo.getRasterTable() + "#" + this.rasterId).initCause(e);
        }
    }

    private void fetchTile(int tileX, int tileY, TileInfo[] target) throws IOException {
        SeRasterTile[] seTile = null;
        if (this.isConsecutive(tileX, tileY)) {
            while (this.lastTileX != tileX || this.lastTileY != tileY) {
                seTile = this.nextTile();
            }
        } else {
            if (this.nonConsecutiveCallCount == Integer.MAX_VALUE) {
                this.nonConsecutiveCallCount = 0;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.info("Number of random (non consecutive) tile request exceeded predefined threshold. Rewind by executing original request again");
                }
                this.dispose();
                this.fetchTile(tileX, tileY, target);
                return;
            }
            ++this.nonConsecutiveCallCount;
            seTile = this.fetchSingleTile(tileX, tileY);
        }
        if (this.lastTileX == this.getMaxTileX() && this.lastTileY == this.getMaxTileY()) {
            this.dispose();
        }
        this.extractTile(seTile, target);
    }

    public int getMaxTileX() {
        return this.requestedTiles.getHigh(0);
    }

    public int getMaxTileY() {
        return this.requestedTiles.getHigh(1);
    }

    private SeRasterTile[] fetchSingleTile(int tileX, int tileY) throws IOException {
        SeRasterTile[] tileData;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("fetchSingleTile raster #" + this.rasterId + ", plevel " + this.pyramidLevel + ", tile " + tileX + ", " + tileY);
        }
        boolean width = true;
        boolean height = true;
        GridEnvelope2D requestTiles = new GridEnvelope2D(tileX, tileY, 1, 1);
        QueryObjects singleTileQueryObjects = this.execute((GridEnvelope)requestTiles);
        SeQuery query = singleTileQueryObjects.preparedQuery;
        SeRow row = singleTileQueryObjects.row;
        TileFetchCommand command = new TileFetchCommand(row, this.nativeCellType);
        try {
            tileData = this.readTile(command);
        }
        finally {
            this.session.close((SeStreamOp)query);
        }
        return tileData;
    }

    private boolean isConsecutive(int tileX, int tileY) {
        if (tileX > this.lastTileX && tileY >= this.lastTileY) {
            return true;
        }
        return tileX <= this.lastTileX && tileY > this.lastTileY;
    }

    private SeRasterTile[] nextTile() throws IOException {
        if (!this.started) {
            this.execute();
            SeRow row = this.queryObjects.row;
            RasterCellType nativeType = this.nativeCellType;
            this.sequentialFetchCommand = new TileFetchCommand(row, nativeType);
        }
        SeRasterTile[] tileData = this.readTile(this.sequentialFetchCommand);
        if (this.lastTileX == -1 && this.lastTileY == -1) {
            this.lastTileX = this.getMinTileX();
            this.lastTileY = this.getMinTileY();
        } else {
            ++this.lastTileX;
            if (this.lastTileX > this.getMaxTileX()) {
                this.lastTileX = this.getMinTileX();
                ++this.lastTileY;
            }
        }
        return tileData;
    }

    private SeRasterTile[] readTile(TileFetchCommand fetchCommand) throws IOException {
        int numBands = this.getNumberOfBands();
        SeRasterTile[] tile = new SeRasterTile[numBands];
        int i = 0;
        while (i < numBands) {
            SeRasterTile bandTile = (SeRasterTile)this.session.issue((Command)fetchCommand);
            if (bandTile == null) {
                throw new IllegalStateException("There are no more tiles to fetch");
            }
            tile[i] = bandTile;
            ++i;
        }
        return tile;
    }

    public void dispose() {
        if (this.session != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("TileReader disposing " + this.session + " on Thread " + Thread.currentThread().getName());
            }
            if (this.queryObjects != null) {
                try {
                    SeQuery preparedQuery = this.queryObjects.preparedQuery;
                    this.session.close((SeStreamOp)preparedQuery);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Closing tile reader's prepared Query", e);
                }
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Disposing " + this.session + " on thread " + Thread.currentThread().getName());
            }
            this.session.dispose();
            this.session = null;
            this.queryObjects = null;
            this.started = false;
            this.lastTileY = -1;
            this.lastTileX = -1;
        }
    }

    protected void finalize() {
        this.dispose();
    }

    public int getMinTileX() {
        return this.requestedTiles.getLow(0);
    }

    public int getMinTileY() {
        return this.requestedTiles.getLow(1);
    }

    public String getServerName() {
        return this.sessionPool.getConfig().getServerName();
    }

    public String getRasterTableName() {
        return this.rasterInfo.getRasterTable();
    }

    public int getPyramidLevel() {
        return this.pyramidLevel;
    }

    public long getRasterId() {
        return this.rasterId;
    }

    private void extractTile(SeRasterTile[] seTile, TileInfo[] target) {
        int numberOfBands = this.getNumberOfBands();
        assert (numberOfBands == seTile.length);
        assert (numberOfBands == target.length);
        int bandN = 0;
        while (bandN < numberOfBands) {
            SeRasterTile tile = seTile[bandN];
            byte[] bitMaskData = tile.getBitMaskData();
            int numPixelsRead = tile.getNumPixels();
            long bandId = tile.getBandId().longValue();
            int colIndex = tile.getColumnIndex();
            int rowIndex = tile.getRowIndex();
            Number noData = this.rasterInfo.getNoDataValue(this.rasterId, bandN);
            TileInfo bandData = target[bandN];
            bandData.setBandId(bandId);
            bandData.setColumnIndex(colIndex);
            bandData.setRowIndex(rowIndex);
            bandData.setNumPixelsRead(numPixelsRead);
            bandData.setBitmaskData(bitMaskData);
            bandData.setNoDataValue(noData);
            this.dataFetcher.setTileData(tile, bandData);
            ++bandN;
        }
    }

    private static class QueryObjects {
        SeQuery preparedQuery;
        SeRow row;

        public QueryObjects(SeQuery preparedQuery, SeRow row) {
            this.preparedQuery = preparedQuery;
            this.row = row;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueryRasterCommand
    extends Command<Void> {
        private SeQuery preparedQuery;
        private SeRow row;
        private final SeRasterConstraint rasterConstraint;
        private final String rasterColumn;
        private final String rasterTable;
        private final long rasterId;

        public QueryRasterCommand(SeRasterConstraint rConstraint, String rasterTable, String rasterColumn, long rasterId) {
            this.rasterConstraint = rConstraint;
            this.rasterTable = rasterTable;
            this.rasterColumn = rasterColumn;
            this.rasterId = rasterId;
        }

        public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
            SeSqlConstruct sqlConstruct = new SeSqlConstruct(this.rasterTable);
            String rasterIdFilter = String.valueOf(this.rasterColumn) + " = " + this.rasterId;
            sqlConstruct.setWhere(rasterIdFilter);
            String[] rasterColumns = new String[]{this.rasterColumn};
            this.preparedQuery = new SeQuery(connection, rasterColumns, sqlConstruct);
            this.preparedQuery.prepareQuery();
            this.preparedQuery.execute();
            this.row = this.preparedQuery.fetch();
            if (this.row == null) {
                return null;
            }
            this.preparedQuery.queryRasterTile(this.rasterConstraint);
            return null;
        }

        public SeQuery getPreparedQuery() {
            return this.preparedQuery;
        }

        public SeRow getSeRow() {
            return this.row;
        }
    }
}

