/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.util;

import com.esri.sde.sdk.client.SeCoordinateReference;
import com.esri.sde.sdk.pe.PeCoordinateSystem;
import com.esri.sde.sdk.pe.PeFactory;
import com.esri.sde.sdk.pe.PeGeographicCS;
import com.esri.sde.sdk.pe.PeProjectedCS;
import com.esri.sde.sdk.pe.PeProjectionException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ArcSDEUtils {
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");
    private static final WeakHashMap<String, CoordinateReferenceSystem> PE_CS_TO_EPSG = new WeakHashMap();

    private ArcSDEUtils() {
    }

    public static CoordinateReferenceSystem findCompatibleCRS(SeCoordinateReference seCoordRef) throws DataSourceException {
        if (seCoordRef == null) {
            LOGGER.fine("SeCoordinateReference is null, using DefaultEngineeringCRS.CARTESIAN_2D");
            return DefaultEngineeringCRS.CARTESIAN_2D;
        }
        PeCoordinateSystem coordSys = seCoordRef.getCoordSys();
        if (coordSys == null) {
            LOGGER.fine("SeCoordinateReference.getCoordSys() is null, using DefaultEngineeringCRS.CARTESIAN_2D");
            return DefaultEngineeringCRS.CARTESIAN_2D;
        }
        String peCoordSysName = coordSys.getName();
        CoordinateReferenceSystem crs = PE_CS_TO_EPSG.get(peCoordSysName);
        if (crs == null) {
            Integer epsgCode = ArcSDEUtils.findEpsgCode(coordSys);
            try {
                if (epsgCode == null) {
                    LOGGER.warning("Couldn't determine EPSG code for this raster.  Using SDE's WKT-like coordSysDescription() instead.");
                    crs = CRS.parseWKT((String)seCoordRef.getCoordSysDescription());
                } else {
                    crs = CRS.decode((String)("EPSG:" + epsgCode));
                }
                PE_CS_TO_EPSG.put(peCoordSysName, crs);
            }
            catch (FactoryException e) {
                LOGGER.log(Level.SEVERE, "", e);
                throw new DataSourceException((Throwable)e);
            }
        }
        return crs;
    }

    private static Integer findEpsgCode(PeCoordinateSystem coordSys) throws DataSourceException {
        String peCoordSysName = coordSys.getName();
        Integer epsgCode = null;
        try {
            int[] seEpsgCodes;
            if (coordSys instanceof PeGeographicCS) {
                seEpsgCodes = PeFactory.geogcsCodelist();
            } else if (coordSys instanceof PeProjectedCS) {
                seEpsgCodes = PeFactory.projcsCodelist();
            } else {
                throw new RuntimeException("Shouldnt happen!: Unnkown SeCoordSys type: " + coordSys.getClass().getName());
            }
            int i = 0;
            while (i < seEpsgCodes.length) {
                block9: {
                    try {
                        int seEpsgCode = seEpsgCodes[i];
                        PeCoordinateSystem candidate = (PeCoordinateSystem)PeFactory.factory((int)seEpsgCode);
                        if (candidate == null || !candidate.getName().trim().equals(peCoordSysName)) break block9;
                        epsgCode = seEpsgCode;
                        break;
                    }
                    catch (PeProjectionException peProjectionException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (PeProjectionException e) {
            LOGGER.log(Level.SEVERE, "", e);
            throw new DataSourceException((Throwable)e);
        }
        return epsgCode;
    }
}

