/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeDefs;
import com.esri.sde.sdk.client.SeError;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeRegistration;
import com.esri.sde.sdk.client.SeTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEAdapter;
import org.geotools.arcsde.data.FeatureTypeInfo;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.ISessionPool;
import org.geotools.arcsde.session.UnavailableConnectionException;
import org.geotools.data.DataSourceException;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FeatureTypeInfoCache {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.data");
    private final Map<String, FeatureTypeInfo> featureTypeInfos;
    private final Map<String, FeatureTypeInfo> inProcessFeatureTypeInfos;
    private final ISessionPool sessionPool;
    private final Set<String> availableLayerNames = new TreeSet<String>();
    private final String namespace;
    private ScheduledExecutorService cacheUpdateScheduler;
    private final ReentrantReadWriteLock cacheLock;
    private final boolean allowNonSpatialTables;
    private final long cacheUpdateFreqSecs;

    public FeatureTypeInfoCache(ISessionPool sessionPool, String namespace, int cacheUpdateFreqSecs, boolean allowNonSpatialTables) throws IOException {
        this.featureTypeInfos = new HashMap<String, FeatureTypeInfo>();
        this.inProcessFeatureTypeInfos = new HashMap<String, FeatureTypeInfo>();
        this.sessionPool = sessionPool;
        this.allowNonSpatialTables = allowNonSpatialTables;
        this.namespace = namespace;
        this.cacheLock = new ReentrantReadWriteLock();
        this.cacheUpdateFreqSecs = cacheUpdateFreqSecs;
        this.reset();
    }

    public void reset() {
        this.dispose();
        CacheUpdater cacheUpdater = new CacheUpdater();
        cacheUpdater.run();
        if (this.cacheUpdateFreqSecs > 0L) {
            this.cacheUpdateScheduler = Executors.newScheduledThreadPool(1);
            LOGGER.info("Scheduling the layer name cache to be updated every " + this.cacheUpdateFreqSecs + " seconds.");
            this.cacheUpdateScheduler.scheduleWithFixedDelay(cacheUpdater, this.cacheUpdateFreqSecs, this.cacheUpdateFreqSecs, TimeUnit.SECONDS);
        } else {
            this.cacheUpdateScheduler = null;
        }
    }

    public boolean isAllowNonSpatialTables() {
        return this.allowNonSpatialTables;
    }

    public void dispose() {
        if (this.cacheUpdateScheduler != null) {
            LOGGER.info("Shutting down cache update scheduler");
            this.cacheUpdateScheduler.shutdownNow();
        }
    }

    public void addInprocessViewInfo(FeatureTypeInfo typeInfo) {
        this.inProcessFeatureTypeInfos.put(typeInfo.getFeatureTypeName(), typeInfo);
    }

    public String getNamesapceURI() {
        return this.namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTypeNames() {
        ArrayList<String> layerNames;
        this.cacheLock.readLock().lock();
        try {
            layerNames = new ArrayList<String>(this.availableLayerNames);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        layerNames.addAll(this.inProcessFeatureTypeInfos.keySet());
        Collections.sort(layerNames);
        return layerNames;
    }

    public List<Name> getNames() {
        List<String> typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.size());
        for (String typeName : typeNames) {
            NameImpl name = this.namespace == null ? new NameImpl(typeName) : new NameImpl(this.namespace, typeName);
            names.add((Name)name);
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureTypeInfo getFeatureTypeInfo(String typeName) throws IOException {
        ISession session;
        FeatureTypeInfo typeInfo = this.getCachedTypeInfo(typeName);
        if (typeInfo != null) {
            return typeInfo;
        }
        try {
            session = this.sessionPool.getSession();
        }
        catch (UnavailableConnectionException e) {
            throw new RuntimeException("Can't get type info for " + typeName + ". Connection pool exhausted", e);
        }
        try {
            typeInfo = this.getFeatureTypeInfo(typeName, session);
        }
        finally {
            session.dispose();
        }
        return typeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureTypeInfo getFeatureTypeInfo(String typeName, ISession session) throws IOException {
        FeatureTypeInfo typeInfo = this.getCachedTypeInfo(typeName);
        if (typeInfo != null) {
            return typeInfo;
        }
        this.cacheLock.writeLock().lock();
        try {
            typeInfo = this.featureTypeInfos.get(typeName);
            if (typeInfo == null) {
                typeInfo = ArcSDEAdapter.fetchSchema(typeName, this.namespace, session);
                this.featureTypeInfos.put(typeName, typeInfo);
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
        return typeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureTypeInfo getCachedTypeInfo(String typeName) throws DataSourceException {
        FeatureTypeInfo typeInfo = this.inProcessFeatureTypeInfos.get(typeName);
        if (typeInfo != null) {
            return typeInfo;
        }
        this.cacheLock.readLock().lock();
        try {
            if (!this.availableLayerNames.contains(typeName)) {
                throw new DataSourceException(typeName + " does not exist");
            }
            typeInfo = this.featureTypeInfos.get(typeName);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        return typeInfo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FetchRegistrationsCommand
    extends Command<List<String>> {
        private final boolean allowNonSpatialTables;

        public FetchRegistrationsCommand(boolean allowNonSpatialTables) {
            this.allowNonSpatialTables = allowNonSpatialTables;
        }

        public List<String> execute(ISession session, SeConnection connection) throws SeException, IOException {
            Vector registeredTables = connection.getTables(SeDefs.SE_SELECT_PRIVILEGE);
            ArrayList<String> typeNames = new ArrayList<String>(registeredTables.size());
            for (SeTable table : registeredTables) {
                boolean isSystemTable;
                SeRegistration reg;
                String tableName = table.getQualifiedName().toUpperCase();
                try {
                    reg = new SeRegistration(connection, tableName);
                }
                catch (SeException e) {
                    if (e.getSeError().getSdeError() == SeError.SE_TABLE_NOREGISTERED) {
                        LOGGER.finest("Ignoring non registered table " + tableName);
                        continue;
                    }
                    throw e;
                }
                boolean bl = isSystemTable = reg.getRowIdAllocation() == SeRegistration.SE_REGISTRATION_ROW_ID_ALLOCATION_SINGLE;
                if (isSystemTable) {
                    LOGGER.finer("Ignoring ArcSDE registered table " + tableName + " as it is a system table");
                    continue;
                }
                if (reg.isHidden()) {
                    LOGGER.finer("Ignoring ArcSDE registered table " + tableName + " as it is hidden");
                    continue;
                }
                boolean hasLayer = reg.hasLayer();
                if (!hasLayer) {
                    if (!this.allowNonSpatialTables) {
                        LOGGER.finer("Ignoring ArcSDE registered table " + tableName + " as it is non spatial");
                        continue;
                    }
                    if (reg.getRowIdColumnType() == SeRegistration.SE_REGISTRATION_ROW_ID_COLUMN_TYPE_NONE) {
                        LOGGER.finer("Ignoring ArcSDE registered table " + tableName + " as it has no row id column");
                        continue;
                    }
                }
                typeNames.add(tableName);
            }
            return typeNames;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CacheUpdater
    implements Runnable {
        private CacheUpdater() {
        }

        @Override
        public void run() {
            List<String> typeNames;
            LOGGER.finer("FeatureTypeCache background process running...");
            try {
                typeNames = this.fetchRegistrations();
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Updating TypeNameCache failed.", e);
                return;
            }
            FeatureTypeInfoCache.this.cacheLock.readLock().lock();
            TreeSet<String> added = new TreeSet<String>(typeNames);
            added.removeAll(FeatureTypeInfoCache.this.availableLayerNames);
            if (added.size() > 0) {
                LOGGER.finest("FeatureTypeCache: added the following layers: " + added);
            }
            TreeSet removed = new TreeSet(FeatureTypeInfoCache.this.availableLayerNames);
            removed.removeAll(typeNames);
            if (removed.size() > 0) {
                LOGGER.finest("FeatureTypeCache: the following layers are no longer available: " + removed);
            }
            FeatureTypeInfoCache.this.cacheLock.readLock().unlock();
            FeatureTypeInfoCache.this.cacheLock.writeLock().lock();
            FeatureTypeInfoCache.this.availableLayerNames.clear();
            FeatureTypeInfoCache.this.availableLayerNames.addAll(typeNames);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("FeatureTypeCache: updated server layer list: " + typeNames);
            }
            for (String typeName : removed) {
                LOGGER.fine("Removing FeatureTypeInfo for layer " + typeName + " since it does no longer exist on the database");
                FeatureTypeInfoCache.this.featureTypeInfos.remove(typeName);
            }
            LOGGER.finer("Finished updated type name cache");
            FeatureTypeInfoCache.this.cacheLock.writeLock().unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> fetchRegistrations() throws Exception {
            List typeNames;
            ISession session = FeatureTypeInfoCache.this.sessionPool.getSession();
            try {
                typeNames = (List)session.issue((Command)new FetchRegistrationsCommand(FeatureTypeInfoCache.this.allowNonSpatialTables));
            }
            finally {
                session.dispose();
            }
            return typeNames;
        }
    }
}

