/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.geotools.arcsde.gce.RasterCellType;
import org.geotools.arcsde.gce.RasterDatasetInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BitmaskToNoDataConverter {
    public static final BitmaskToNoDataConverter NO_ACTION_CONVERTER = new BitmaskToNoDataConverter(0, 0, null){

        public void setNoData(Long bandId, byte[] tileData, byte[] bitMaskData) {
        }

        public void setAll(Long bandId, byte[] tileData) {
        }

        public void setNoData(Long bandId, int sampleN, byte[] tileData) {
        }
    };
    protected final int pixelsPerTile;
    protected final Map<Long, byte[]> byBandIdNoDataValues;
    protected final int bitsPerSample;

    private BitmaskToNoDataConverter(int pixelsPerTile, int bitsPerSample, Map<Long, byte[]> byBandIdNoDataValues) {
        this.pixelsPerTile = pixelsPerTile;
        this.bitsPerSample = bitsPerSample;
        this.byBandIdNoDataValues = byBandIdNoDataValues;
    }

    public static BitmaskToNoDataConverter getInstance(RasterDatasetInfo rasterInfo, int rasterIndex) {
        int numBands = rasterInfo.getNumBands();
        RasterCellType targetType = rasterInfo.getTargetCellType(rasterIndex);
        HashMap<Long, byte[]> byBandIdNoDataValues = new HashMap<Long, byte[]>();
        Dimension tileDimension = rasterInfo.getTileDimension(rasterIndex);
        int samplesPerTile = tileDimension.width * tileDimension.height;
        for (int bandN = 0; bandN < numBands; ++bandN) {
            long bandId = rasterInfo.getBand(rasterIndex, bandN).getBandId();
            Number noDataValue = rasterInfo.getNoDataValue(rasterIndex, bandN);
            byte[] noDataValueBytes = BitmaskToNoDataConverter.toBytes(noDataValue, targetType);
            byBandIdNoDataValues.put(bandId, noDataValueBytes);
        }
        int bitsPerSample = targetType.getBitsPerSample();
        BitmaskToNoDataConverter noDataSetter = targetType == RasterCellType.TYPE_8BIT_U ? new Unsigned8bitConverter(samplesPerTile, bitsPerSample, byBandIdNoDataValues) : new BitmaskToNoDataConverter(samplesPerTile, bitsPerSample, byBandIdNoDataValues);
        return noDataSetter;
    }

    static byte[] toBytes(Number noDataValue, RasterCellType targetType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream writer = new DataOutputStream(out);
        try {
            switch (targetType) {
                case TYPE_16BIT_S: {
                    writer.writeShort(noDataValue.intValue());
                    break;
                }
                case TYPE_16BIT_U: {
                    writer.writeShort(noDataValue.intValue());
                    break;
                }
                case TYPE_32BIT_REAL: {
                    writer.writeFloat(noDataValue.floatValue());
                    break;
                }
                case TYPE_32BIT_S: {
                    writer.writeInt(noDataValue.intValue());
                    break;
                }
                case TYPE_32BIT_U: {
                    writer.writeInt(noDataValue.intValue());
                    break;
                }
                case TYPE_64BIT_REAL: {
                    writer.writeDouble(noDataValue.doubleValue());
                    break;
                }
                case TYPE_8BIT_S: {
                    writer.writeByte(noDataValue.byteValue());
                    break;
                }
                case TYPE_8BIT_U: {
                    writer.writeByte(noDataValue.intValue());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("No no-data converter exists for sample type " + (Object)((Object)targetType));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can't happen!", e);
        }
        byte[] no_data_bytes = out.toByteArray();
        return no_data_bytes;
    }

    public final boolean isNoData(int sampleN, byte[] bitmaskData) {
        boolean isNoData = (bitmaskData[sampleN / 8] >> 7 - sampleN % 8 & 1) == 0;
        return isNoData;
    }

    public void setNoData(Long bandId, byte[] tileData, byte[] bitmaskData) {
        for (int sampleN = 0; sampleN < this.pixelsPerTile; ++sampleN) {
            if (!this.isNoData(sampleN, bitmaskData)) continue;
            this.setNoData(bandId, sampleN, tileData);
        }
    }

    public void setAll(Long bandId, byte[] tileData) {
        for (int sampleN = 0; sampleN < this.pixelsPerTile; ++sampleN) {
            this.setNoData(bandId, sampleN, tileData);
        }
    }

    public void setNoData(Long bandId, int sampleN, byte[] tileData) {
        byte[] noData = this.byBandIdNoDataValues.get(bandId);
        int pixArrayOffset = sampleN * this.bitsPerSample / 8;
        System.arraycopy(noData, 0, tileData, pixArrayOffset, noData.length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Unsigned8bitConverter
    extends BitmaskToNoDataConverter {
        public Unsigned8bitConverter(int samplesPerTile, int bitsPerSample, Map<Long, byte[]> byBandIdNoDataValues) {
            super(samplesPerTile, bitsPerSample, byBandIdNoDataValues);
        }

        @Override
        public void setAll(Long bandId, byte[] tileData) {
            byte noDataValue = ((byte[])this.byBandIdNoDataValues.get(bandId))[0];
            Arrays.fill(tileData, noDataValue);
        }

        @Override
        public void setNoData(Long bandId, int sampleN, byte[] tileData) {
            byte noDataValue;
            tileData[sampleN] = noDataValue = ((byte[])this.byBandIdNoDataValues.get(bandId))[0];
        }
    }
}

