/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeRaster;
import com.esri.sde.sdk.client.SeRasterAttr;
import com.esri.sde.sdk.client.SeRasterConstraint;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.sun.media.imageio.stream.RawImageInputStream;
import com.sun.media.imageioimpl.plugins.raw.RawImageReaderSpi;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.gce.ArcSDETiledImageInputStream;
import org.geotools.arcsde.gce.RasterDatasetInfo;
import org.geotools.arcsde.gce.TileReader;
import org.geotools.arcsde.gce.TileReaderFactory;
import org.geotools.arcsde.gce.TiledRasterReader;
import org.geotools.arcsde.session.ArcSDEPooledConnection;
import org.geotools.data.DataSourceException;
import org.geotools.util.logging.Logging;

class DefaultTiledRasterReader
implements TiledRasterReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");
    private ArcSDEPooledConnection conn;
    private RasterDatasetInfo rasterInfo;
    private final SeQuery preparedQuery;
    private SeRow row;
    private SeRasterAttr rAttr;
    private Long rasterId;

    public DefaultTiledRasterReader(ArcSDEPooledConnection conn, RasterDatasetInfo rasterInfo) throws IOException {
        this.conn = conn;
        this.rasterInfo = rasterInfo;
        this.preparedQuery = this.createSeQuery(conn);
        try {
            this.preparedQuery.execute();
        }
        catch (SeException e) {
            this.dispose();
            throw new ArcSdeException(e);
        }
    }

    public void dispose() {
        if (this.conn != null) {
            try {
                this.preparedQuery.close();
            }
            catch (SeException e) {
                e.printStackTrace();
            }
            this.conn.close();
            this.conn = null;
        }
    }

    public Long nextRaster() throws IOException {
        try {
            this.row = this.preparedQuery.fetch();
            if (this.row == null) {
                this.dispose();
                return null;
            }
            boolean rasterColumnIndex = false;
            this.rAttr = this.row.getRaster(0);
            this.rasterId = this.rAttr.getRasterId().longValue();
        }
        catch (SeException e) {
            throw new ArcSdeException(e);
        }
        return this.rasterId;
    }

    public RenderedImage read(int pyramidLevel, Rectangle tileRange) throws IOException {
        RenderedImage rasterImage;
        try {
            rasterImage = this.getRasterMatchingTileRange(pyramidLevel, tileRange);
        }
        catch (IOException e) {
            this.dispose();
            throw e;
        }
        catch (RuntimeException e) {
            this.dispose();
            throw e;
        }
        return rasterImage;
    }

    private SeQuery createSeQuery(ArcSDEPooledConnection conn) throws IOException {
        SeQuery seQuery;
        String[] rasterColumns = this.rasterInfo.getRasterColumns();
        String tableName = this.rasterInfo.getRasterTable();
        try {
            seQuery = new SeQuery((SeConnection)conn, rasterColumns, new SeSqlConstruct(tableName));
            seQuery.prepareQuery();
        }
        catch (SeException e) {
            throw new ArcSdeException(e);
        }
        return seQuery;
    }

    private RenderedImage getRasterMatchingTileRange(int pyramidLevel, Rectangle matchingTiles) throws IOException {
        RenderedOp fullTilesRaster = this.createTiledRaster(pyramidLevel, matchingTiles);
        try {
            LOGGER.info("Forcing loading data for " + this.rasterInfo.getRasterTable() + "#" + this.rasterId);
            fullTilesRaster.getData();
        }
        catch (RuntimeException e) {
            throw new DataSourceException("Error fetching arcsde raster", (Throwable)e);
        }
        return fullTilesRaster;
    }

    private RenderedOp createTiledRaster(int pyramidLevel, Rectangle matchingTiles) throws IOException {
        int tileHeight;
        int tileWidth;
        int rasterIndex = this.rasterInfo.getRasterIndex(this.rasterId);
        try {
            int numberOfBands = this.rAttr.getNumBands();
            tileWidth = this.rAttr.getTileWidth();
            tileHeight = this.rAttr.getTileHeight();
            int[] bandsToQuery = new int[numberOfBands];
            for (int bandN = 1; bandN <= numberOfBands; ++bandN) {
                bandsToQuery[bandN - 1] = bandN;
            }
            int minTileX = matchingTiles.x;
            int minTileY = matchingTiles.y;
            int maxTileX = minTileX + matchingTiles.width - 1;
            int maxTileY = minTileY + matchingTiles.height - 1;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Requesting tiles [x=" + minTileX + "-" + maxTileX + ", y=" + minTileY + "-" + maxTileY + "] from tile range [x=0-" + (this.rAttr.getTilesPerRowByLevel(pyramidLevel) - 1) + ", y=0-" + (this.rAttr.getTilesPerColByLevel(pyramidLevel) - 1) + "]");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                Rectangle tiledImageSize = new Rectangle(0, 0, tileWidth * matchingTiles.width, tileHeight * matchingTiles.height);
                LOGGER.fine("Tiled image size: " + tiledImageSize);
            }
            int interleaveType = SeRaster.SE_RASTER_INTERLEAVE_BIP;
            SeRasterConstraint rConstraint = new SeRasterConstraint();
            rConstraint.setBands(bandsToQuery);
            rConstraint.setLevel(pyramidLevel);
            rConstraint.setEnvelope(minTileX, minTileY, maxTileX, maxTileY);
            rConstraint.setInterleave(interleaveType);
            this.preparedQuery.queryRasterTile(rConstraint);
        }
        catch (SeException se) {
            throw new ArcSdeException(se);
        }
        Dimension tileSize = new Dimension(tileWidth, tileHeight);
        TileReader tileReader = TileReaderFactory.getInstance(this.row, this.rasterInfo, rasterIndex, matchingTiles, tileSize);
        int tiledImageWidth = tileReader.getTilesWide() * tileReader.getTileWidth();
        int tiledImageHeight = tileReader.getTilesHigh() * tileReader.getTileHeight();
        Dimension tiledImageSize = new Dimension(tiledImageWidth, tiledImageHeight);
        ImageTypeSpecifier fullImageSpec = this.rasterInfo.getRenderedImageSpec(rasterIndex);
        ColorModel colorModel = fullImageSpec.getColorModel();
        SampleModel sampleModel = fullImageSpec.getSampleModel(tiledImageWidth, tiledImageHeight);
        long[] imageOffsets = new long[]{0L};
        Dimension[] imageDimensions = new Dimension[]{tiledImageSize};
        ImageTypeSpecifier its = new ImageTypeSpecifier(colorModel, sampleModel);
        ArcSDETiledImageInputStream tiledImageInputStream = new ArcSDETiledImageInputStream(tileReader);
        RawImageInputStream raw = new RawImageInputStream((ImageInputStream)tiledImageInputStream, its, imageOffsets, imageDimensions);
        int minX = matchingTiles.x * tileWidth;
        int minY = matchingTiles.y * tileHeight;
        int width = tiledImageSize.width;
        int height = tiledImageSize.height;
        int tileGridXOffset = minX;
        int tileGridYOffset = minY;
        ImageLayout imageLayout = new ImageLayout(minX, minY, width, height, tileGridXOffset, tileGridYOffset, tileWidth, tileHeight, sampleModel, colorModel);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
        ParameterBlock pb = new ParameterBlock();
        pb.add(raw);
        pb.add((Object)0);
        pb.add(Boolean.TRUE);
        pb.add(Boolean.TRUE);
        pb.add(Boolean.TRUE);
        pb.add(null);
        pb.add(null);
        ImageReadParam rParam = new ImageReadParam();
        pb.add(rParam);
        RawImageReaderSpi imageIOSPI = new RawImageReaderSpi();
        ImageReader readerInstance = imageIOSPI.createReaderInstance();
        pb.add(readerInstance);
        RenderedOp image = JAI.create((String)"ImageRead", (ParameterBlock)pb, (RenderingHints)hints);
        return image;
    }
}

