/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeRasterTile;
import com.esri.sde.sdk.client.SeRow;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.EOFException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.gce.BitmaskToNoDataConverter;
import org.geotools.arcsde.gce.TileReader;
import org.geotools.util.logging.Logging;

final class NativeTileReader
implements TileReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");
    private final int bitsPerSample;
    private final Rectangle requestedTiles;
    private final Dimension tileSize;
    private final int tileDataLength;
    private final SeRow row;
    private final int pixelsPerTile;
    private final int numberOfBands;
    private SeRasterTile nextTile;
    private boolean started;
    private final int bitmaskDataLength;
    private final BitmaskToNoDataConverter noData;

    NativeTileReader(SeRow row, int bitsPerSample, int numberOfBands, Rectangle requestedTiles, Dimension tileSize, BitmaskToNoDataConverter noData) {
        this.row = row;
        this.bitsPerSample = bitsPerSample;
        this.numberOfBands = numberOfBands;
        this.requestedTiles = requestedTiles;
        this.tileSize = tileSize;
        this.pixelsPerTile = tileSize.width * tileSize.height;
        this.tileDataLength = (int)Math.ceil((double)this.pixelsPerTile * (double)bitsPerSample / 8.0);
        this.bitmaskDataLength = (int)Math.ceil((double)this.pixelsPerTile / 8.0);
        this.noData = noData;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public int getPixelsPerTile() {
        return this.pixelsPerTile;
    }

    public int getNumberOfBands() {
        return this.numberOfBands;
    }

    public int getTileWidth() {
        return this.tileSize.width;
    }

    public int getTileHeight() {
        return this.tileSize.height;
    }

    public int getTilesWide() {
        return this.requestedTiles.width;
    }

    public int getTilesHigh() {
        return this.requestedTiles.height;
    }

    public int getBytesPerTile() {
        return this.tileDataLength;
    }

    public boolean hasNext() throws IOException {
        if (!this.started) {
            try {
                this.nextTile = this.row.getRasterTile();
                this.started = true;
                if (this.nextTile == null) {
                    LOGGER.fine("No tiles to fetch at all, releasing connection");
                }
            }
            catch (SeException e) {
                throw new ArcSdeException(e);
            }
        }
        return this.nextTile != null;
    }

    public TileReader.TileInfo next(byte[] tileData) throws IOException {
        if (tileData == null) {
            throw new IllegalArgumentException("tileData is null");
        }
        if (!this.hasNext()) {
            throw new IllegalStateException("There're no more tiles to fetch");
        }
        SeRasterTile tile = this.nextTile();
        byte[] bitMaskData = tile.getBitMaskData();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(" >> Fetching " + tile + " - bitmask: " + bitMaskData.length + " has more: " + this.hasNext());
        }
        assert (bitMaskData.length == 0 || this.bitmaskDataLength == bitMaskData.length);
        int numPixels = tile.getNumPixels();
        Long bandId = tile.getBandId().longValue();
        if (0 == numPixels) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("tile contains no pixel data, skipping: " + tile);
            }
            this.noData.setAll(bandId, tileData);
        } else if (this.pixelsPerTile == numPixels) {
            byte[] rawTileData = tile.getPixelData();
            System.arraycopy(rawTileData, 0, tileData, 0, this.tileDataLength);
            if (bitMaskData.length > 0) {
                this.noData.setNoData(bandId, tileData, bitMaskData);
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("returning " + numPixels + " pixels data packaged into " + this.tileDataLength + " bytes for tile [" + tile.getColumnIndex() + "," + tile.getRowIndex() + "]");
            }
        } else {
            throw new IllegalStateException("Expected pixels per tile == " + this.pixelsPerTile + " but got " + numPixels + ": " + tile);
        }
        return new TileReader.TileInfo(bandId, bitMaskData, numPixels);
    }

    private SeRasterTile nextTile() throws IOException {
        if (this.nextTile == null) {
            throw new EOFException("No more tiles to read");
        }
        SeRasterTile curr = this.nextTile;
        try {
            this.nextTile = this.row.getRasterTile();
            if (this.nextTile == null) {
                LOGGER.finer("There're no more tiles to fetch");
            }
        }
        catch (SeException e) {
            throw new ArcSdeException(e);
        }
        return curr;
    }
}

