/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import java.io.IOException;
import org.geotools.arcsde.gce.DefaultTiledRasterReader;
import org.geotools.arcsde.gce.RasterDatasetInfo;
import org.geotools.arcsde.gce.TiledRasterReader;
import org.geotools.arcsde.session.ArcSDEConnectionPool;
import org.geotools.arcsde.session.ArcSDEPooledConnection;
import org.geotools.arcsde.session.UnavailableConnectionException;

public class RasterReaderFactory {
    private final ArcSDEConnectionPool connectionPool;

    public RasterReaderFactory(ArcSDEConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public TiledRasterReader create(RasterDatasetInfo rasterInfo) throws IOException {
        ArcSDEPooledConnection conn;
        try {
            conn = this.connectionPool.getConnection();
        }
        catch (UnavailableConnectionException e) {
            throw new RuntimeException(e);
        }
        DefaultTiledRasterReader rasterReader = new DefaultTiledRasterReader(conn, rasterInfo);
        return rasterReader;
    }
}

