/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.session;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.arcsde.session.ArcSDEConnectionPool;
import org.geotools.data.DataSourceException;
import org.geotools.util.logging.Logging;

public class ArcSDEConnectionPoolFactory {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.pool");
    private static final ArcSDEConnectionPoolFactory singleton = new ArcSDEConnectionPoolFactory();
    private final Map currentPools = new HashMap();

    private ArcSDEConnectionPoolFactory() {
    }

    public static synchronized ArcSDEConnectionPoolFactory getInstance() {
        return singleton;
    }

    public synchronized ArcSDEConnectionPool createPool(ArcSDEConnectionConfig config) throws DataSourceException {
        ArcSDEConnectionPool pool = (ArcSDEConnectionPool)this.currentPools.get(config);
        if (pool == null || pool.isClosed()) {
            pool = new ArcSDEConnectionPool(config);
            this.currentPools.put(config, pool);
        }
        return pool;
    }

    public void clear() {
        this.closeAll();
        this.currentPools.clear();
        LOGGER.fine("sde connection pools creared");
    }

    private void closeAll() {
        Iterator it = this.currentPools.values().iterator();
        while (it.hasNext()) {
            ((ArcSDEConnectionPool)it.next()).close();
        }
    }

    protected void finalize() {
        this.closeAll();
    }
}

