/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.expression.AddBuilder;
import org.geotools.filter.expression.DivideBuilder;
import org.geotools.filter.expression.FunctionBuilder;
import org.geotools.filter.expression.LiteralBuilder;
import org.geotools.filter.expression.MultiplyBuilder;
import org.geotools.filter.expression.NilBuilder;
import org.geotools.filter.expression.PropertyNameBuilder;
import org.geotools.filter.expression.SubtractBuilder;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionBuilder
implements Builder<Expression> {
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory2(null);
    protected boolean unset = false;
    protected Builder<? extends Expression> delegate = new NilBuilder();

    public ExpressionBuilder() {
        this.reset();
    }

    public ExpressionBuilder(Expression expr) {
        this.reset(expr);
    }

    public LiteralBuilder literal() {
        this.delegate = new LiteralBuilder();
        this.unset = false;
        return (LiteralBuilder)this.delegate;
    }

    public Builder<?> literal(Object literal) {
        this.delegate = new LiteralBuilder().value(literal);
        this.unset = false;
        return this;
    }

    public AddBuilder add() {
        this.delegate = new AddBuilder();
        this.unset = false;
        return (AddBuilder)this.delegate;
    }

    public MultiplyBuilder multiply() {
        this.delegate = new MultiplyBuilder();
        this.unset = false;
        return (MultiplyBuilder)this.delegate;
    }

    public DivideBuilder divide() {
        this.delegate = new DivideBuilder();
        this.unset = false;
        return (DivideBuilder)this.delegate;
    }

    public SubtractBuilder subtract() {
        this.delegate = new SubtractBuilder();
        this.unset = false;
        return (SubtractBuilder)this.delegate;
    }

    public PropertyNameBuilder property() {
        this.delegate = new PropertyNameBuilder();
        this.unset = false;
        return (PropertyNameBuilder)this.delegate;
    }

    public Builder<?> property(String xpath) {
        this.delegate = new PropertyNameBuilder().property(xpath);
        this.unset = false;
        return this;
    }

    public FunctionBuilder function() {
        this.delegate = new FunctionBuilder();
        this.unset = false;
        return (FunctionBuilder)this.delegate;
    }

    public FunctionBuilder function(String name) {
        this.delegate = new FunctionBuilder().name(name);
        this.unset = false;
        return (FunctionBuilder)this.delegate;
    }

    @Override
    public Expression build() {
        if (this.unset) {
            return null;
        }
        return this.delegate.build();
    }

    public ExpressionBuilder reset() {
        this.delegate = new NilBuilder();
        this.unset = false;
        return this;
    }

    public ExpressionBuilder reset(Expression original) {
        if (original == null) {
            return this.unset();
        }
        this.unset = false;
        this.delegate = original instanceof Literal ? new LiteralBuilder((Literal)original) : (original instanceof PropertyName ? new PropertyNameBuilder((PropertyName)original) : (original instanceof Function ? new FunctionBuilder((Function)original) : (original instanceof Add ? new AddBuilder((Add)original) : (original instanceof Divide ? new DivideBuilder((Divide)original) : (original instanceof Multiply ? new MultiplyBuilder((Multiply)original) : (original instanceof Subtract ? new SubtractBuilder((Subtract)original) : new NilBuilder()))))));
        return this;
    }

    public ExpressionBuilder unset() {
        this.unset = true;
        this.delegate = new NilBuilder();
        return this;
    }

    public boolean isUnset() {
        return this.unset;
    }
}

