/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.expression.ChildExpressionBuilder;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.StyleFactory;
import org.opengis.style.ContrastMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContrastEnhancementBuilder<P>
implements Builder<ContrastEnhancement> {
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private P parent;
    boolean unset = true;
    private ChildExpressionBuilder<ContrastEnhancementBuilder<P>> gamma = new ChildExpressionBuilder<ContrastEnhancementBuilder>(this);
    private ContrastMethod method;

    public ContrastEnhancementBuilder() {
        this(null);
    }

    public ContrastEnhancementBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    @Override
    public ContrastEnhancement build() {
        if (this.unset) {
            return null;
        }
        ContrastEnhancement contrastEnhancement = this.sf.contrastEnhancement(this.gamma.build(), this.method);
        return contrastEnhancement;
    }

    public P end() {
        return this.parent;
    }

    @Override
    public ContrastEnhancementBuilder<P> reset() {
        this.gamma.reset();
        this.unset = false;
        return this;
    }

    @Override
    public ContrastEnhancementBuilder<P> reset(ContrastEnhancement contrastEnhancement) {
        if (contrastEnhancement == null) {
            return this.reset();
        }
        this.gamma.reset(contrastEnhancement.getGammaValue());
        this.method = contrastEnhancement.getMethod();
        this.unset = false;
        return this;
    }

    @Override
    public ContrastEnhancementBuilder<P> unset() {
        this.gamma.unset();
        this.method = ContrastMethod.NONE;
        this.unset = true;
        return this;
    }
}

