/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import java.util.ArrayList;
import java.util.List;
import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.expression.ChildExpressionBuilder;
import org.geotools.styling.Font;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.builder.GraphicBuilder;
import org.opengis.filter.expression.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontBuilder<P>
implements Builder<Font> {
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private P parent;
    private ChildExpressionBuilder<FontBuilder<P>> x = new ChildExpressionBuilder<FontBuilder>(this);
    private ChildExpressionBuilder<FontBuilder<P>> y = new ChildExpressionBuilder<FontBuilder>(this);
    boolean unset = true;
    private List<ChildExpressionBuilder<GraphicBuilder<P>>> family;
    private ChildExpressionBuilder<GraphicBuilder<P>> style;
    private ChildExpressionBuilder<GraphicBuilder<P>> weight;
    private ChildExpressionBuilder<GraphicBuilder<P>> size;

    public FontBuilder() {
        this.parent = null;
        this.reset();
    }

    public FontBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    @Override
    public Font build() {
        if (this.unset) {
            return null;
        }
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (ChildExpressionBuilder<GraphicBuilder<P>> face : this.family) {
            list.add(face.build());
        }
        Font font = this.sf.font(list, this.style.build(), this.weight.build(), this.size.build());
        return font;
    }

    public P end() {
        return this.parent;
    }

    @Override
    public FontBuilder<P> reset() {
        ((ChildExpressionBuilder)this.x.reset()).literal(0);
        ((ChildExpressionBuilder)this.y.reset()).literal(0);
        this.unset = false;
        return this;
    }

    @Override
    public FontBuilder<P> reset(Font font) {
        if (font == null) {
            return this.reset();
        }
        this.unset = false;
        return this;
    }

    @Override
    public FontBuilder<P> unset() {
        this.unset = true;
        return this;
    }
}

