/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.builder.FillBuilder;
import org.geotools.styling.builder.StrokeBuilder;
import org.opengis.style.Fill;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonSymbolizerBuilder<P>
implements Builder<PolygonSymbolizer> {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    P parent;
    StrokeBuilder<PolygonSymbolizerBuilder<P>> stroke = new StrokeBuilder();
    FillBuilder<PolygonSymbolizerBuilder<P>> fill = new FillBuilder();
    String geometry = null;
    boolean unset = false;

    public PolygonSymbolizerBuilder() {
        this(null);
    }

    PolygonSymbolizerBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    public P end() {
        return this.parent;
    }

    PolygonSymbolizerBuilder<P> geometry(String geometry) {
        this.geometry = geometry;
        this.unset = false;
        return this;
    }

    public StrokeBuilder stroke() {
        this.unset = false;
        return this.stroke;
    }

    public FillBuilder fill() {
        this.unset = false;
        return this.fill;
    }

    @Override
    public PolygonSymbolizer build() {
        if (this.unset) {
            return null;
        }
        PolygonSymbolizer ps = this.sf.createPolygonSymbolizer(this.stroke.build(), this.fill.build(), this.geometry);
        this.reset();
        return ps;
    }

    @Override
    public PolygonSymbolizerBuilder<P> reset() {
        this.stroke.reset();
        this.fill.reset();
        this.unset = false;
        return this;
    }

    @Override
    public PolygonSymbolizerBuilder<P> reset(PolygonSymbolizer symbolizer) {
        this.stroke.reset(symbolizer.getStroke());
        this.fill.reset((Fill)symbolizer.getFill());
        this.unset = false;
        return this;
    }

    @Override
    public PolygonSymbolizerBuilder<P> unset() {
        this.stroke.unset();
        this.fill.unset();
        this.unset = true;
        return this;
    }
}

