package org.tecgraf.tdk.cache;

import org.apache.log4j.Logger;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.tecgraf.tdk.cache.query.DefaultQueryAnalyzer;
import org.tecgraf.tdk.cache.query.QueryAnalyzer;

public class DefaultCachingFeatureAccessFactory implements CachingFeatureAccessFactory<SimpleFeatureType, SimpleFeature>
{
	private static Logger _logger = Logger.getLogger(DefaultCachingFeatureAccessFactory.class);
	
	@Override
	public FeatureCacher<SimpleFeatureType, SimpleFeature> createFeatureCacher(SimpleFeatureType schema) {
		_logger.debug("Building cacher for '"+schema.getTypeName()+"'");
		return new BasicFeatureCacher(schema,this);
	}

	@Override
	public CachingFeatureSource<SimpleFeatureType, SimpleFeature> createFeatureSource(FeatureSource<SimpleFeatureType, SimpleFeature> featureSource, FeatureCacher<SimpleFeatureType, SimpleFeature> featureCacher) {
		return new SimpleCachingFeatureSource(featureSource,featureCacher);
	}

	@Override
	public CachingFeatureStore<SimpleFeatureType, SimpleFeature> createFeatureStore(FeatureStore<SimpleFeatureType, SimpleFeature> featureStore, FeatureCacher<SimpleFeatureType, SimpleFeature> featureCacher) {
		return new SimpleCachingFeatureStore(featureStore,featureCacher);
	}

	@Override
	public QueryAnalyzer createQueryAnalyzer(Query query) {
		return new DefaultQueryAnalyzer(query);
	}

    /* (non-Javadoc)
     * @see org.tecgraf.tdk.cache.CachingFeatureAccessFactory#createFeatureReader(org.geotools.data.Query, org.tecgraf.tdk.cache.FeatureCacher)
     */
    @Override
    public CachingFeatureReader<SimpleFeatureType, SimpleFeature> createFeatureReader(Query query,
            FeatureCacher<SimpleFeatureType, SimpleFeature> featureCacher)
    {
        return new SimpleCachingFeatureReader(query,featureCacher);
    }

    /* (non-Javadoc)
     * @see org.tecgraf.tdk.cache.CachingFeatureAccessFactory#createFeatureWriter(org.geotools.data.FeatureWriter, org.tecgraf.tdk.cache.FeatureCacher)
     */
    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(
            FeatureWriter<SimpleFeatureType, SimpleFeature> wrappedFeatureWriter,
            FeatureCacher<SimpleFeatureType, SimpleFeature> featureCacher)
    {
        return new SimpleCachingFeatureWriter(wrappedFeatureWriter,featureCacher);
    }


}
