/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.netcdf;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.image.io.FileImageReader;
import org.geotools.image.io.SampleConverter;
import org.geotools.image.io.StreamImageReader;
import org.geotools.image.io.metadata.GeographicMetadata;
import org.geotools.image.io.netcdf.NetcdfMetadata;
import org.geotools.image.io.netcdf.NetcdfReadParam;
import org.geotools.image.io.netcdf.VariableMetadata;
import org.geotools.math.Statistics;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.util.CancelTask;

public class NetcdfImageReader
extends FileImageReader
implements CancelTask {
    private static final String DODS_PROTOCOL = "dods";
    private static final int X_DIMENSION = 1;
    private static final int Y_DIMENSION = 2;
    private static final int Z_DIMENSION = 3;
    private static final Set<DataType> VALID_TYPES = new HashSet<DataType>(12);
    private NetcdfDataset dataset;
    private String[] variableNames;
    private int variableIndex;
    protected Variable variable;
    private String lastError;
    private boolean metadataLoaded;
    private IIOMetadata streamMetadata;
    private IIOMetadata imageMetadata;

    public NetcdfImageReader(Spi spi) {
        super((ImageReaderSpi)((Object)spi));
    }

    private String getInputDODS() {
        String url;
        int s;
        String protocol = null;
        if (this.input instanceof URL) {
            URL url2 = (URL)this.input;
            protocol = url2.getProtocol();
        } else if (this.input instanceof URI) {
            URI url3 = (URI)this.input;
            protocol = url3.getScheme();
        } else if (this.input instanceof String && (s = (url = (String)this.input).indexOf(58)) > 0) {
            protocol = url.substring(0, s);
        }
        if (protocol == null || !protocol.equalsIgnoreCase(DODS_PROTOCOL)) {
            return null;
        }
        return this.input.toString();
    }

    public String[] getVariables() throws IOException {
        if (this.variableNames == null) {
            this.ensureFileOpen();
        }
        return (String[])this.variableNames.clone();
    }

    public void setVariables(String[] variableNames) {
        this.variableNames = variableNames != null ? (String[])variableNames.clone() : null;
    }

    public int getNumImages(boolean allowSearch) throws IllegalStateException, IOException {
        this.ensureFileOpen();
        return this.variableNames.length;
    }

    public int getNumBands(int imageIndex) throws IOException {
        this.prepareVariable(imageIndex);
        int rank = this.variable.getRank();
        int bandDimension = rank - 3;
        if (bandDimension >= 0 && bandDimension < rank) {
            return this.variable.getDimension(bandDimension).getLength();
        }
        return super.getNumBands(imageIndex);
    }

    public int getDimension(int imageIndex) throws IOException {
        this.prepareVariable(imageIndex);
        return this.variable.getRank();
    }

    private static SampleConverter first(SampleConverter[] converters) {
        SampleConverter converter = converters[0];
        if (converter == null) {
            converter = SampleConverter.IDENTITY;
        }
        return converter;
    }

    public Statistics getStatistics(int imageIndex) throws IOException {
        GeographicMetadata metadata = this.getGeographicMetadata(imageIndex);
        double[] fillValues = metadata != null && metadata.getNumBands() >= 1 ? metadata.getBand(0).getNoDataValues() : null;
        Array array = this.variable.read();
        IndexIterator it = array.getIndexIterator();
        Statistics stats = new Statistics();
        if (fillValues == null || fillValues.length == 0) {
            while (it.hasNext()) {
                stats.add(it.getDoubleNext());
            }
        } else if (fillValues.length == 1) {
            double fillValue = fillValues[0];
            while (it.hasNext()) {
                double value = it.getDoubleNext();
                if (value == fillValue) continue;
                stats.add(value);
            }
        } else {
            block2: while (it.hasNext()) {
                double value = it.getDoubleNext();
                if (fillValues != null) {
                    for (int i = 0; i < fillValues.length; ++i) {
                        if (fillValues[i] == value) continue block2;
                    }
                }
                stats.add(value);
            }
        }
        return stats;
    }

    public int getWidth(int imageIndex) throws IOException {
        this.prepareVariable(imageIndex);
        return this.variable.getDimension(this.variable.getRank() - 1).getLength();
    }

    public int getHeight(int imageIndex) throws IOException {
        this.prepareVariable(imageIndex);
        return this.variable.getDimension(this.variable.getRank() - 2).getLength();
    }

    private void ensureMetadataLoaded() throws IOException {
        if (!this.metadataLoaded) {
            CoordSysBuilder.addCoordinateSystems((NetcdfDataset)this.dataset, (CancelTask)this);
            this.metadataLoaded = true;
        }
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        if (this.streamMetadata == null && !this.ignoreMetadata) {
            this.ensureFileOpen();
            this.ensureMetadataLoaded();
            this.streamMetadata = this.createMetadata(this.dataset);
        }
        return this.streamMetadata;
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        if (this.imageMetadata == null && !this.ignoreMetadata) {
            this.prepareVariable(imageIndex);
            if (this.variable instanceof VariableDS) {
                this.ensureMetadataLoaded();
                this.imageMetadata = this.createMetadata((VariableDS)this.variable);
            }
        }
        return this.imageMetadata;
    }

    protected IIOMetadata createMetadata(NetcdfDataset file) throws IOException {
        return new NetcdfMetadata((ImageReader)((Object)this), file);
    }

    protected IIOMetadata createMetadata(VariableDS variable) throws IOException {
        return new NetcdfMetadata((ImageReader)((Object)this), variable);
    }

    protected int getRawDataType(int imageIndex) throws IOException {
        this.prepareVariable(imageIndex);
        return VariableMetadata.getRawDataType((VariableIF)this.variable);
    }

    private int getSliceIndice(ImageReadParam param, int dimension) throws IOException {
        AxisType type;
        NetcdfReadParam p;
        if (param instanceof NetcdfReadParam && (p = (NetcdfReadParam)((Object)param)).hasNonDefaultIndices() && (type = this.getAxisType(dimension)) != null) {
            return p.getSliceIndice(type);
        }
        return 0;
    }

    private AxisType getAxisType(int dimension) throws IOException {
        if (this.variable instanceof VariableDS) {
            this.ensureMetadataLoaded();
            List sys = ((VariableDS)this.variable).getCoordinateSystems();
            if (sys != null) {
                int count = sys.size();
                for (int i = 0; i < count; ++i) {
                    CoordinateAxis axis;
                    CoordinateSystem cs = (CoordinateSystem)sys.get(i);
                    List axes = cs.getCoordinateAxes();
                    if (axes == null || axes.size() <= dimension || (axis = (CoordinateAxis)axes.get(dimension)) == null) continue;
                    return axis.getAxisType();
                }
            }
        }
        return null;
    }

    private static boolean isAxis(VariableIF candidate, List variables) {
        String name = candidate.getName();
        int size = variables.size();
        for (int i = 0; i < size; ++i) {
            Dimension dim;
            VariableIF var = (VariableIF)variables.get(i);
            if (var == candidate) continue;
            int d = 0;
            while ((dim = var.getDimension(d)) != null) {
                if (dim.getName().equals(name)) {
                    return true;
                }
                ++d;
            }
        }
        return false;
    }

    private void ensureFileOpen() throws IOException {
        if (this.dataset == null) {
            this.lastError = null;
            this.clearAbortRequest();
            String dodsURL = this.getInputDODS();
            if (dodsURL != null) {
                int s;
                if (this.variableNames == null && (s = dodsURL.indexOf(63)) >= 0) {
                    this.variableNames = new String[]{dodsURL.substring(s + 1)};
                }
                this.dataset = new NetcdfDataset((NetcdfFile)new DODSNetcdfFile(dodsURL, (CancelTask)this), false);
            } else {
                File inputFile = this.getInputFile();
                this.dataset = NetcdfDataset.openDataset((String)inputFile.getPath(), (boolean)false, (CancelTask)this);
                if (this.dataset == null) {
                    throw new FileNotFoundException(Errors.format((int)36, (Object)inputFile));
                }
            }
            if (this.variableNames == null) {
                List variables = this.dataset.getVariables();
                Object[] filtered = new String[variables.size()];
                int count = 0;
                for (int i = 0; i < filtered.length; ++i) {
                    VariableIF candidate = (VariableIF)variables.get(i);
                    if (candidate.getRank() < 2 || !VALID_TYPES.contains(candidate.getDataType()) || NetcdfImageReader.isAxis(candidate, variables)) continue;
                    filtered[count++] = candidate.getName();
                }
                this.variableNames = (String[])XArray.resize((Object[])filtered, (int)count);
            }
        }
    }

    protected boolean prepareVariable(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        if (this.variable == null || this.variableIndex != imageIndex) {
            this.ensureFileOpen();
            String name = this.variableNames[imageIndex];
            Variable candidate = this.findVariable(name);
            int rank = candidate.getRank();
            if (rank < Math.max(1, 2)) {
                throw new IIOException(Errors.format((int)93, (Object)rank));
            }
            this.variable = candidate;
            this.variableIndex = imageIndex;
            this.imageMetadata = null;
            return true;
        }
        return false;
    }

    protected Variable findVariable(String name) throws IOException {
        this.ensureFileOpen();
        Variable candidate = this.dataset.findVariable(name);
        if (candidate != null) {
            return candidate;
        }
        List variables = this.dataset.getVariables();
        if (variables != null) {
            for (Variable variable : variables) {
                if (variable == null || !name.equalsIgnoreCase(variable.getName())) continue;
                return variable;
            }
        }
        throw new IIOException(Errors.format((int)201, (Object)name, (Object)this.dataset.getLocation()));
    }

    public ImageReadParam getDefaultReadParam() {
        return new NetcdfReadParam((ImageReader)((Object)this));
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        int[] dstBands;
        int[] srcBands;
        int strideY;
        int strideX;
        this.clearAbortRequest();
        this.prepareVariable(imageIndex);
        if (param != null) {
            strideX = param.getSourceXSubsampling();
            strideY = param.getSourceYSubsampling();
            srcBands = param.getSourceBands();
            dstBands = param.getDestinationBands();
        } else {
            strideX = 1;
            strideY = 1;
            srcBands = null;
            dstBands = null;
        }
        int rank = this.variable.getRank();
        int bandDimension = rank - 3;
        int width = this.variable.getDimension(rank - 1).getLength();
        int height = this.variable.getDimension(rank - 2).getLength();
        SampleConverter[] converters = new SampleConverter[1];
        BufferedImage image = this.getDestination(imageIndex, param, width, height, converters);
        WritableRaster raster = image.getRaster();
        SampleConverter converter = NetcdfImageReader.first(converters);
        boolean hasBands = bandDimension >= 0 && bandDimension < rank;
        int numSrcBands = hasBands ? this.variable.getDimension(bandDimension).getLength() : 1;
        int numDstBands = raster.getNumBands();
        if (param != null) {
            NetcdfImageReader.checkReadParamBandSettings((ImageReadParam)param, (int)numSrcBands, (int)numDstBands);
        }
        Rectangle srcRegion = new Rectangle();
        Rectangle destRegion = new Rectangle();
        NetcdfImageReader.computeRegions((ImageReadParam)param, (int)width, (int)height, (BufferedImage)image, (Rectangle)srcRegion, (Rectangle)destRegion);
        NetcdfImageReader.flipVertically((ImageReadParam)param, (int)height, (Rectangle)srcRegion);
        Range[] ranges = new Range[rank];
        for (int i = 0; i < ranges.length; ++i) {
            int stride;
            int length;
            int first;
            switch (rank - i) {
                case 1: {
                    first = srcRegion.x;
                    length = srcRegion.width;
                    stride = strideX;
                    break;
                }
                case 2: {
                    first = srcRegion.y;
                    length = srcRegion.height;
                    stride = strideY;
                    break;
                }
                default: {
                    first = i == bandDimension ? 0 : this.getSliceIndice(param, i);
                    length = 1;
                    stride = 1;
                }
            }
            try {
                ranges[i] = new Range(first, first + length - 1, stride);
                continue;
            }
            catch (InvalidRangeException e) {
                throw this.netcdfFailure((Exception)((Object)e));
            }
        }
        List sections = Range.toList((Range[])ranges);
        this.processImageStarted(imageIndex);
        float toPercent = 100.0f / (float)numDstBands;
        int type = raster.getSampleModel().getDataType();
        int xmin = destRegion.x;
        int ymin = destRegion.y;
        int xmax = destRegion.width + xmin;
        int ymax = destRegion.height + ymin;
        for (int zi = 0; zi < numDstBands; ++zi) {
            Array array;
            int srcBand = srcBands == null ? zi : srcBands[zi];
            int dstBand = dstBands == null ? zi : dstBands[zi];
            try {
                if (hasBands) {
                    ranges[bandDimension] = new Range(srcBand, srcBand, 1);
                }
                array = this.variable.read(sections);
            }
            catch (InvalidRangeException e) {
                throw this.netcdfFailure((Exception)((Object)e));
            }
            IndexIterator it = array.getIndexIterator();
            int y = ymax;
            while (--y >= ymin) {
                block15: for (int x = xmin; x < xmax; ++x) {
                    switch (type) {
                        case 5: {
                            raster.setSample(x, y, dstBand, converter.convert(it.getDoubleNext()));
                            continue block15;
                        }
                        case 4: {
                            raster.setSample(x, y, dstBand, converter.convert(it.getFloatNext()));
                            continue block15;
                        }
                        default: {
                            raster.setSample(x, y, dstBand, converter.convert(it.getIntNext()));
                        }
                    }
                }
            }
            if (this.abortRequested()) {
                this.processReadAborted();
                return image;
            }
            this.processImageProgress((float)zi * toPercent);
        }
        if (this.lastError != null) {
            throw new IIOException(this.lastError);
        }
        this.processImageComplete();
        return image;
    }

    private IIOException netcdfFailure(Exception e) throws IOException {
        return new IIOException(Errors.format((int)163, (Object)this.dataset.getLocation()), e);
    }

    public boolean isCancel() {
        return this.abortRequested();
    }

    public void setError(String message) {
        this.lastError = message;
    }

    protected void close() throws IOException {
        this.metadataLoaded = false;
        this.streamMetadata = null;
        this.imageMetadata = null;
        this.lastError = null;
        this.variable = null;
        if (this.dataset != null) {
            this.dataset.close();
            this.dataset = null;
        }
        super.close();
    }

    static {
        VALID_TYPES.add(DataType.BOOLEAN);
        VALID_TYPES.add(DataType.BYTE);
        VALID_TYPES.add(DataType.SHORT);
        VALID_TYPES.add(DataType.INT);
        VALID_TYPES.add(DataType.LONG);
        VALID_TYPES.add(DataType.FLOAT);
        VALID_TYPES.add(DataType.DOUBLE);
    }

    public static class Spi
    extends StreamImageReader.Spi {
        private static final String[] NAMES = new String[]{"netcdf", "NetCDF"};
        private static final String[] MIME_TYPES = new String[]{"image/x-netcdf"};
        private static final String[] SUFFIXES = new String[]{"nc", "NC"};

        public Spi() {
            this.names = NAMES;
            this.MIMETypes = MIME_TYPES;
            this.suffixes = SUFFIXES;
            this.pluginClassName = "org.geotools.image.io.netcdf.NetcdfImageReader";
            this.vendorName = "Geotools";
            this.version = "2.4";
        }

        public String getDescription(Locale locale) {
            return "NetCDF image decoder";
        }

        public boolean canDecodeInput(Object source) throws IOException {
            return false;
        }

        public ImageReader createReaderInstance(Object extension) throws IOException {
            return new NetcdfImageReader(this);
        }
    }
}

