/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.netcdf;

import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.imageio.ImageReader;
import org.geotools.image.io.metadata.Axis;
import org.geotools.image.io.metadata.GeographicMetadata;
import org.geotools.image.io.metadata.ImageGeometry;
import org.geotools.image.io.metadata.ImageReferencing;
import org.geotools.image.io.metadata.MetadataAccessor;
import org.geotools.image.io.netcdf.VariableMetadata;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.LoggedFormat;
import org.opengis.referencing.cs.AxisDirection;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetcdfMetadata
extends GeographicMetadata {
    private static final boolean USE_UCAR_LIB = false;
    private static final Map<AxisType, AxisDirection> DIRECTIONS = new HashMap<AxisType, AxisDirection>(16);

    private static void add(AxisType type, AxisDirection direction) {
        if (DIRECTIONS.put(type, direction) != null) {
            throw new IllegalArgumentException(String.valueOf(type));
        }
    }

    public NetcdfMetadata(ImageReader reader, NetcdfDataset file) {
        super(reader);
        List systems = file.getCoordinateSystems();
        if (!systems.isEmpty()) {
            this.addCoordinateSystem((CoordinateSystem)systems.get(0));
        }
    }

    public NetcdfMetadata(ImageReader reader, VariableDS variable) {
        super(reader);
        List systems = variable.getCoordinateSystems();
        if (!systems.isEmpty()) {
            this.addCoordinateSystem((CoordinateSystem)systems.get(0));
        }
        this.setSampleType("packed");
        this.addSampleDimension(variable);
    }

    public void addCoordinateSystem(CoordinateSystem cs) {
        String csType;
        String crsType;
        if (cs.isLatLon()) {
            crsType = cs.hasVerticalAxis() ? "geographic3D" : "geographic";
            csType = "ellipsoidal";
        } else if (cs.isGeoXY()) {
            crsType = cs.hasVerticalAxis() ? "projected3D" : "projected";
            csType = "cartesian";
        } else {
            crsType = null;
            csType = null;
        }
        ImageReferencing referencing = this.getReferencing();
        referencing.setCoordinateReferenceSystem(null, crsType);
        referencing.setCoordinateSystem(cs.getName(), csType);
        ImageGeometry geometry = this.getGeometry();
        geometry.setPixelOrientation("center");
        List axis = cs.getCoordinateAxes();
        int i = axis.size();
        while (--i >= 0) {
            this.addCoordinateAxis((CoordinateAxis)axis.get(i));
        }
    }

    private static String getName(Variable variable) {
        String name = variable.getDescription();
        if (name == null || (name = name.trim()).length() == 0) {
            name = variable.getName();
        }
        return name;
    }

    public void addCoordinateAxis(CoordinateAxis axis) {
        String name = NetcdfMetadata.getName((Variable)axis);
        AxisType type = axis.getAxisType();
        String units = axis.getUnitsString();
        String direction = null;
        AxisDirection directionCode = DIRECTIONS.get(type);
        if (directionCode != null) {
            if ("down".equalsIgnoreCase(axis.getPositive())) {
                directionCode = directionCode.opposite();
            }
            direction = directionCode.name();
            int offset = units.lastIndexOf(95);
            if (offset >= 0) {
                String opposite;
                String unitsDirection = units.substring(offset + 1).trim();
                if (unitsDirection.equalsIgnoreCase(opposite = directionCode.opposite().name())) {
                    this.warning("addCoordinateAxis", 60, new String[]{name, direction});
                    direction = opposite;
                }
                if (unitsDirection.equalsIgnoreCase(direction)) {
                    units = units.substring(0, offset).trim();
                }
            }
        }
        Axis axisNode = this.getReferencing().addAxis(name, direction, units);
        if (AxisType.Time.equals(type)) {
            String origin = null;
            String[] unitsParts = units.split("(?i)\\s+since\\s+");
            if (unitsParts.length == 2) {
                units = unitsParts[0].trim();
                origin = unitsParts[1].trim();
            } else {
                Attribute attribute = axis.findAttribute("time_origin");
                if (attribute != null) {
                    origin = attribute.getStringValue();
                }
            }
            Date epoch = null;
            if (origin != null) {
                origin = MetadataAccessor.trimFractionalPart((String)origin);
                epoch = this.parse(type, origin, Date.class, "addCoordinateAxis");
            }
            axisNode.setTimeOrigin(epoch);
            axisNode.setUnits(units);
        }
        if (!axis.isNumeric()) {
            return;
        }
        if (axis instanceof CoordinateAxis1D) {
            CoordinateAxis1D axis1D = (CoordinateAxis1D)axis;
            ImageGeometry geometry = this.getGeometry();
            double[] values = axis1D.getCoordValues();
            geometry.addOrdinates(0, values);
        }
    }

    public void addSampleDimension(VariableDS variable) {
        VariableMetadata m = new VariableMetadata((Variable)variable, this.forcePacking("valid_range"));
        m.copyTo(this.addBand(NetcdfMetadata.getName((Variable)variable)));
    }

    private <T> T parse(AxisType type, String value, Class<T> expected, String caller) {
        LoggedFormat format = this.createLoggedFormat(this.getAxisFormat(type, value), expected);
        format.setLogger("org.geotools.image.io.netcdf");
        format.setCaller(NetcdfMetadata.class, caller);
        return (T)format.parse(value);
    }

    protected Format getAxisFormat(AxisType type, String prototype) {
        if (!type.equals(AxisType.Time)) {
            return NumberFormat.getNumberInstance(Locale.CANADA);
        }
        char dateSeparator = '-';
        boolean yearLast = false;
        boolean namedMonth = false;
        if (prototype != null) {
            char c;
            int field = 1;
            int digitCount = 0;
            int length = prototype.length();
            for (int i = 0; i < length && !Character.isWhitespace(c = prototype.charAt(i)); ++i) {
                if (Character.isDigit(c)) {
                    ++digitCount;
                    continue;
                }
                if (field == 2 && Character.isLetter(c)) {
                    namedMonth = true;
                    continue;
                }
                if (field == 1) {
                    dateSeparator = c;
                }
                digitCount = 0;
                ++field;
            }
            if (digitCount >= 4) {
                yearLast = true;
            }
        }
        String pattern = yearLast ? (namedMonth ? "dd-MMM-yyyy" : "dd-MM-yyyy") : (namedMonth ? "yyyy-MMM-dd" : "yyyy-MM-dd");
        pattern = pattern.replace('-', dateSeparator);
        pattern = pattern + " HH:mm:ss";
        SimpleDateFormat format = new SimpleDateFormat(pattern, Locale.CANADA);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    protected boolean forcePacking(String attribute) {
        return false;
    }

    private void warning(String method, int key, Object value) {
        LogRecord record = Errors.getResources((Locale)this.getLocale()).getLogRecord(Level.WARNING, key, value);
        record.setSourceClassName(NetcdfMetadata.class.getName());
        record.setSourceMethodName(method);
        this.warningOccurred(record);
    }

    static {
        NetcdfMetadata.add(AxisType.Time, AxisDirection.FUTURE);
        NetcdfMetadata.add(AxisType.GeoX, AxisDirection.EAST);
        NetcdfMetadata.add(AxisType.GeoY, AxisDirection.NORTH);
        NetcdfMetadata.add(AxisType.GeoZ, AxisDirection.UP);
        NetcdfMetadata.add(AxisType.Lat, AxisDirection.NORTH);
        NetcdfMetadata.add(AxisType.Lon, AxisDirection.EAST);
        NetcdfMetadata.add(AxisType.Height, AxisDirection.UP);
        NetcdfMetadata.add(AxisType.Pressure, AxisDirection.UP);
    }
}

