/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.db2.DB2SQLBuilder;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBCTextFeatureWriter;
import org.geotools.data.jdbc.QueryData;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB2FeatureWriter
extends JDBCTextFeatureWriter {
    private DB2SQLBuilder sqlBuilder;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.db2");

    public DB2FeatureWriter(FeatureReader<SimpleFeatureType, SimpleFeature> reader, QueryData queryData, DB2SQLBuilder sqlBuilder) throws IOException {
        super(reader, queryData);
        this.sqlBuilder = sqlBuilder;
    }

    protected String makeDeleteSql(SimpleFeature feature) throws IOException {
        String deleteSQL = this.sqlBuilder.makeDeleteSql(feature);
        return deleteSQL;
    }

    protected String makeInsertSql(SimpleFeature feature) throws IOException {
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        SimpleFeatureType featureType = ftInfo.getSchema();
        List attributes = featureType.getAttributeDescriptors();
        String insertSQL = this.sqlBuilder.makeInsertSql(attributes, feature);
        return insertSQL;
    }

    protected String makeUpdateSql(SimpleFeature live, SimpleFeature current) throws IOException {
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        SimpleFeatureType featureType = ftInfo.getSchema();
        List attributes = featureType.getAttributeDescriptors();
        String updateSQL = this.sqlBuilder.makeUpdateSql(attributes, live, current);
        return updateSQL;
    }

    protected String getGeometryInsertText(Geometry geom, int srid) throws IOException {
        return null;
    }
}

