/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.db2.DB2DataStore;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.datasource.DataSourceUtil;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.util.logging.Logging;

public class DB2DataStoreFactory
extends AbstractDataStoreFactory
implements DataStoreFactorySpi {
    public static final String DRIVERNAME = "com.ibm.db2.jcc.DB2Driver";
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.db2");
    private static final String DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    private static boolean isAvailable = false;
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "must be 'DB2'", true, (Object)"DB2");
    public static final DataAccessFactory.Param HOST = new DataAccessFactory.Param("host", String.class, "DB2 host machine", true, (Object)"localhost");
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "DB2 connection port", true, (Object)new Integer(50000));
    public static final DataAccessFactory.Param DATABASE = new DataAccessFactory.Param("database", String.class, "database name", true);
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param("user", String.class, "user name to login as", false);
    public static final DataAccessFactory.Param PASSWD = new DataAccessFactory.Param("passwd", String.class, "password used to login", false);
    public static final DataAccessFactory.Param TABSCHEMA = new DataAccessFactory.Param("tabschema", String.class, "default table schema", false);
    public static final DataAccessFactory.Param MAXCONN = new DataAccessFactory.Param("max connections", Integer.class, "maximum number of open connections", false, (Object)new Integer(10));
    public static final DataAccessFactory.Param MINCONN = new DataAccessFactory.Param("min connections", Integer.class, "minimum number of pooled connection", false, (Object)new Integer(4));
    public static final DataAccessFactory.Param VALIDATECONN = new DataAccessFactory.Param("validate connections", Boolean.class, "check connection is alive before using it", false, (Object)Boolean.FALSE);
    static final DataAccessFactory.Param[] DB2PARMS = new DataAccessFactory.Param[]{DBTYPE, HOST, PORT, DATABASE, USER, PASSWD, TABSCHEMA, MAXCONN, MINCONN, VALIDATECONN};
    private boolean canProcess = false;
    private Map lastParams = null;

    public DataStore createDataStore(Map params) throws IOException {
        DB2DataStore ds;
        if (!this.canProcess(params)) {
            throw new IOException("Invalid parameters");
        }
        if (!this.isAvailable()) {
            throw new IOException("DB2 Driver not available");
        }
        String host = (String)HOST.lookUp(params);
        String user = (String)USER.lookUp(params);
        String passwd = (String)PASSWD.lookUp(params);
        int port = (Integer)PORT.lookUp(params);
        String database = (String)DATABASE.lookUp(params);
        String tabschema = (String)TABSCHEMA.lookUp(params);
        Integer maxConn = (Integer)MAXCONN.lookUp(params);
        Integer minConn = (Integer)MINCONN.lookUp(params);
        Boolean validateConn = (Boolean)VALIDATECONN.lookUp(params);
        boolean validate = validateConn != null && validateConn != false;
        int maxActive = maxConn != null ? maxConn : 10;
        int maxIdle = minConn != null ? minConn : 4;
        String url = DB2DataStoreFactory.getJDBCUrl(host, port, database);
        ManageableDataSource source = DB2DataStoreFactory.getDefaultDataSource(url, user, passwd, maxActive, maxIdle, validate);
        if (tabschema == null || tabschema.length() == 0) {
            tabschema = user;
        }
        tabschema = tabschema.startsWith("\"") ? tabschema.substring(1, tabschema.length() - 1) : tabschema.toUpperCase();
        tabschema = tabschema.trim();
        JDBCDataStoreConfig config = new JDBCDataStoreConfig(tabschema, tabschema, 10000L);
        try {
            ds = new DB2DataStore((DataSource)source, config, url);
        }
        catch (IOException e) {
            LOGGER.info("Create DB2Datastore failed: " + e);
            throw new DataSourceException("Could not create DB2DataStore", (Throwable)e);
        }
        LOGGER.info("Successfully created DB2Datastore for: " + host + ":" + port + "/" + database);
        return ds;
    }

    public static ManageableDataSource getDefaultDataSource(String url, String user, String passwd, int maxActive, int minIdle, boolean validate) throws DataSourceException {
        return DataSourceUtil.buildDefaultDataSource((String)url, (String)"com.ibm.db2.jcc.DB2Driver", (String)user, (String)passwd, (int)maxActive, (int)minIdle, (String)(validate ? "select current date from sysibm.sysdummy1" : null), (boolean)false, (int)0);
    }

    public static String getJDBCUrl(String host, int port, String database) {
        String url = null;
        url = port == 0 ? "jdbc:db2:" + database : "jdbc:db2://" + host + ":" + port + "/" + database;
        return url;
    }

    public DataStore createNewDataStore(Map params) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Creating a new DB2 database is not supported");
    }

    public String getDescription() {
        return "DB2 Data Store";
    }

    public String getDisplayName() {
        return "DB2";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return DB2PARMS;
    }

    public boolean canProcess(Map params) {
        String logInfo = "";
        if (params == null) {
            return false;
        }
        String dbtype = (String)params.get("dbtype");
        if (dbtype == null) {
            return false;
        }
        if (!dbtype.equalsIgnoreCase("DB2")) {
            return false;
        }
        if (this.canProcess && this.lastParams == params) {
            return true;
        }
        if (!super.canProcess(params)) {
            return false;
        }
        this.lastParams = params;
        this.canProcess = true;
        return true;
    }

    public boolean isAvailable() {
        if (isAvailable) {
            return isAvailable;
        }
        try {
            Class.forName("com.ibm.db2.jcc.DB2Driver");
            isAvailable = true;
        }
        catch (ClassNotFoundException e) {
            isAvailable = false;
        }
        LOGGER.info("DB2 driver found: " + isAvailable);
        return isAvailable;
    }
}

