/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2008(c).
 * 
 * file: DataAccessException.java
 * created: 16/09/2008
 */
package org.geotools.data.gridcoverage.exception;

import org.opengis.coverage.grid.GridCoverage;
import org.geotools.data.gridcoverage.GridCoverageDataStore;
import org.geotools.data.gridcoverage.GridCoverageFeatureSource;

/**
 * Used for exceptions when attempting to retrieve {@link GridCoverage}
 * information from a {@link GridCoverageDataStore} or
 * {@link GridCoverageFeatureSource}
 * 
 * @author milton
 * @since TDK 3.0.0
 */
public class DataAccessGridCoverageException extends Exception
{
    private static final long serialVersionUID = -7147426222523440291L;

    /**
     * Constructs a new exception with the specified detail message. The cause
     * is not initialized, and may subsequently be initialized by a call to
     * {@link #initCause}.
     * 
     * @param message the detail message. The detail message is saved for later
     *            retrieval by the {@link #getMessage()} method.
     * @since TDK 3.0.0
     */
    public DataAccessGridCoverageException(String message)
    {
        super(message);
    }

    /**
     * Constructs a new exception with the specified detail message and cause.
     * <p>
     * Note that the detail message associated with <code>cause</code> is
     * <i>not</i> automatically incorporated in this exception's detail message.
     * 
     * @param message the detail message (which is saved for later retrieval by
     *            the {@link #getMessage()} method).
     * @param cause the cause (which is saved for later retrieval by the
     *            {@link #getCause()} method). (A <tt>null</tt> value is
     *            permitted, and indicates that the cause is nonexistent or
     *            unknown.)
     * @since TDK 3.0.0
     */
    public DataAccessGridCoverageException(String message, Throwable throwable)
    {
        super(message, throwable);
    }
}
