/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gridcoverage;

import java.io.IOException;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.collection.CollectionDataStore;
import org.geotools.data.gridcoverage.DefaultGridCoverageFeatureLocking;
import org.geotools.data.gridcoverage.DefaultGridCoverageFeatureSource;
import org.geotools.data.gridcoverage.DefaultGridCoverageFeatureStore;
import org.geotools.data.gridcoverage.GridCoverageDataStore;
import org.geotools.data.gridcoverage.GridCoverageFeatureSource;
import org.geotools.data.gridcoverage.exception.DataAccessGridCoverageException;
import org.geotools.feature.FeatureCollection;
import org.geotools.resources.coverage.FeatureUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.parameter.GeneralParameterValue;

public class DefaultGridCoverageDataStore
extends CollectionDataStore
implements GridCoverageDataStore {
    public DefaultGridCoverageDataStore(AbstractGridCoverage2DReader reader) throws DataAccessGridCoverageException {
        this(reader, null);
    }

    public DefaultGridCoverageDataStore(AbstractGridCoverage2DReader reader, GeneralParameterValue[] params) throws DataAccessGridCoverageException {
        super(DefaultGridCoverageDataStore.wrapGridCoverageReader(reader, params));
    }

    protected static FeatureCollection<SimpleFeatureType, SimpleFeature> wrapGridCoverageReader(AbstractGridCoverage2DReader reader, GeneralParameterValue[] params) throws DataAccessGridCoverageException {
        if (reader == null) {
            throw new NullPointerException("reader can't be null");
        }
        FeatureCollection wrappedReader = null;
        try {
            wrappedReader = FeatureUtilities.wrapGridCoverageReader((AbstractGridCoverage2DReader)reader, (GeneralParameterValue[])params);
        }
        catch (Exception e) {
            throw new DataAccessGridCoverageException("Could not wrap GridCoverageReader.", e);
        }
        return wrappedReader;
    }

    @Override
    public AbstractGridCoverage2DReader getCoverageReader() throws DataAccessGridCoverageException {
        String[] typeNames = this.getTypeNames();
        if (typeNames.length < 1) {
            throw new DataAccessGridCoverageException("DataStore should contain a typeName for the contained GridCoverageFeatureSource.");
        }
        FeatureSource<SimpleFeatureType, SimpleFeature> featSource = null;
        try {
            featSource = this.getFeatureSource(typeNames[0]);
        }
        catch (IOException e) {
            throw new DataAccessGridCoverageException("Could not retrieve first FeatureSource from GridCoverageDataStore.");
        }
        if (!(featSource instanceof GridCoverageFeatureSource)) {
            throw new DataAccessGridCoverageException("DataStore's first typeName should be a GridCoverageFeatureSource.");
        }
        return ((GridCoverageFeatureSource)featSource).getCoverageReader();
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(String typeName) throws IOException {
        SimpleFeatureType featureType = this.getSchema(typeName);
        if (this.isWriteable) {
            if (this.getLockingManager() != null) {
                return new DefaultGridCoverageFeatureLocking(this, featureType, this.getSupportedHints());
            }
            return new DefaultGridCoverageFeatureStore(this, featureType, this.getSupportedHints());
        }
        return new DefaultGridCoverageFeatureSource(this, featureType, this.getSupportedHints());
    }
}

