/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.gce.imagemosaic.jdbc.AbstractCmd;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.DBDialect;
import org.geotools.gce.imagemosaic.jdbc.SpatialExtension;

class DDLGenerator
extends AbstractCmd {
    private static final int DefaultPyramids = 0;
    private static final String FN_CREATEMETA = "createmeta.sql";
    private static final String FN_DROPMETA = "dropmeta.sql";
    private static final String UsageInfo = "Generating DDL scripts\n-config URLOrFile -spatialTNPrefix spatialTNPrefix [-tileTNPrefix tileTNPrefix]\n  [-pyramids pyramids] -statementDelim statementDelim [-srs srs ] -targetDir directory";
    private static final String NotSuppord = "DDL generation not supported for type ";
    private Config config;
    private String spatialTNPrefix;
    private String tileTNPrefix;
    private int pyramids = 0;
    private String statementDelim;
    private Logger logger;
    private DBDialect dbDialect;
    private String srs;
    private String targetDir;

    DDLGenerator(Config config, String spatialTNPrefix, String tileTNPrefix, int pyramids, String statementDelim, String srs, String targetDir) {
        this.config = config;
        this.pyramids = pyramids;
        this.spatialTNPrefix = spatialTNPrefix;
        this.tileTNPrefix = tileTNPrefix;
        this.statementDelim = statementDelim;
        this.srs = srs;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.dbDialect = DBDialect.getDBDialect(config);
        this.targetDir = targetDir.endsWith(File.separator) ? targetDir : String.valueOf(targetDir) + File.separator;
    }

    public static void start(String[] args) {
        Config config = null;
        String spatialTNPrefix = null;
        String tileTNPrefix = null;
        String statementDelim = null;
        String srs = null;
        String targetDir = null;
        int pyramids = 0;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(CONFIGPARAM)) {
                try {
                    config = Config.readFrom(DDLGenerator.getURLFromString(args[i + 1]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                if (config != null && (config.getSpatialExtension() == SpatialExtension.GEORASTER || config.getSpatialExtension() == SpatialExtension.CUSTOM)) {
                    System.out.println(NotSuppord + (Object)((Object)config.getSpatialExtension()));
                    System.exit(1);
                }
                ++i;
            } else if (args[i].equals(SPATIALTNPREFIXPARAM)) {
                spatialTNPrefix = args[i + 1];
                ++i;
            } else if (args[i].equals(TILETNPREFIXPARAM)) {
                tileTNPrefix = args[i + 1];
                ++i;
            } else if (args[i].equals("-statementDelim")) {
                statementDelim = args[i + 1];
                ++i;
            } else if (args[i].equals("-srs")) {
                srs = args[i + 1];
                ++i;
            } else if (args[i].equals("-pyramids")) {
                pyramids = new Integer(args[i + 1]);
                ++i;
            } else if (args[i].equals("-targetDir")) {
                targetDir = args[i + 1];
                ++i;
            } else {
                System.out.println("Unkwnown option: " + args[i]);
                System.exit(1);
            }
            ++i;
        }
        if (config == null || spatialTNPrefix == null || statementDelim == null) {
            System.out.println(UsageInfo);
            System.exit(1);
        }
        if (targetDir == null) {
            System.out.println("Must specify -targetDir ");
            System.exit(1);
        }
        if (DDLGenerator.needsSpatialRegistry(config) && srs == null) {
            System.out.println("Must specify -srs ");
            System.exit(1);
        }
        DDLGenerator gen = new DDLGenerator(config, spatialTNPrefix, tileTNPrefix, pyramids, statementDelim, srs, targetDir);
        try {
            gen.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    void generate() throws Exception {
        this.writeCreateMeta();
        this.writeDropMeta();
        String fn = String.valueOf(this.targetDir) + "add_" + this.config.getCoverageName() + ".sql";
        PrintWriter w = new PrintWriter(fn);
        w.println();
        this.writeFillMeta(w);
        w.println();
        this.writeCreateTables(w);
        w.println();
        this.writeRegister(w);
        w.println();
        this.writeCreateIndexes(w);
        w.close();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info(String.valueOf(fn) + " generated");
        }
        fn = String.valueOf(this.targetDir) + "remove_" + this.config.getCoverageName() + ".sql";
        w = new PrintWriter(fn);
        w.println();
        this.writeDropIndexes(w);
        w.println();
        this.writeUnRegister(w);
        w.println();
        this.writeDropTables(w);
        w.println();
        this.writeDeleteMeta(w);
        w.close();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info(String.valueOf(fn) + " generated");
        }
    }

    void writeFillMeta(PrintWriter w) throws IOException {
        String statmentString = "INSERT INTO " + this.config.getMasterTable() + "(" + this.config.getCoverageNameAttribute() + "," + this.config.getTileTableNameAtribute() + "," + this.config.getSpatialTableNameAtribute() + ") VALUES ('%s','%s','%s')";
        int i = 0;
        while (i <= this.pyramids) {
            String stn = DDLGenerator.getTableName(this.spatialTNPrefix, i);
            String ttn = this.tileTNPrefix == null ? stn : DDLGenerator.getTableName(this.tileTNPrefix, i);
            Object[] args = new Object[]{this.config.getCoverageName(), ttn, stn};
            w.printf(statmentString, args);
            w.println(this.statementDelim);
            ++i;
        }
    }

    void writeDeleteMeta(PrintWriter w) throws IOException {
        String statmentString = "DELETE FROM " + this.config.getMasterTable() + " WHERE " + this.config.getCoverageNameAttribute() + " = '%s' AND " + this.config.getTileTableNameAtribute() + " = '%s' AND " + this.config.getSpatialTableNameAtribute() + " = '%s'  ";
        int i = 0;
        while (i <= this.pyramids) {
            String stn = DDLGenerator.getTableName(this.spatialTNPrefix, i);
            String ttn = this.tileTNPrefix == null ? stn : DDLGenerator.getTableName(this.tileTNPrefix, i);
            Object[] args = new Object[]{this.config.getCoverageName(), ttn, stn};
            w.printf(statmentString, args);
            w.println(this.statementDelim);
            ++i;
        }
    }

    void writeCreateMeta() throws Exception {
        PrintWriter w = new PrintWriter(String.valueOf(this.targetDir) + FN_CREATEMETA);
        w.print(this.dbDialect.getCreateMasterStatement());
        w.println(this.statementDelim);
        w.close();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("createmeta.sql generated");
        }
    }

    void writeCreateTables(PrintWriter w) throws Exception {
        int i = 0;
        while (i <= this.pyramids) {
            if (this.tileTNPrefix == null) {
                w.print(this.dbDialect.getCreateSpatialTableStatementJoined(DDLGenerator.getTableName(this.spatialTNPrefix, i)));
                w.println(this.statementDelim);
            } else {
                w.print(this.dbDialect.getCreateSpatialTableStatement(DDLGenerator.getTableName(this.spatialTNPrefix, i)));
                w.println(this.statementDelim);
                w.print(this.dbDialect.getCreateTileTableStatement(DDLGenerator.getTableName(this.tileTNPrefix, i)));
                w.println(this.statementDelim);
            }
            ++i;
        }
    }

    void writeCreateIndexes(PrintWriter w) throws Exception {
        int i = 0;
        while (i <= this.pyramids) {
            w.print(this.dbDialect.getCreateIndexStatement(DDLGenerator.getTableName(this.spatialTNPrefix, i)));
            w.println(this.statementDelim);
            ++i;
        }
    }

    void writeDropMeta() throws IOException {
        PrintWriter w = new PrintWriter(String.valueOf(this.targetDir) + FN_DROPMETA);
        w.print(this.dbDialect.getDropTableStatement(this.config.getMasterTable()));
        w.println(this.statementDelim);
        w.close();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("dropmeta.sql generated");
        }
    }

    void writeDropTables(PrintWriter w) throws IOException {
        int i = 0;
        while (i <= this.pyramids) {
            w.print(this.dbDialect.getDropTableStatement(DDLGenerator.getTableName(this.spatialTNPrefix, i)));
            w.println(this.statementDelim);
            ++i;
        }
        if (this.tileTNPrefix != null) {
            w.println();
            i = 0;
            while (i <= this.pyramids) {
                w.print(this.dbDialect.getDropTableStatement(DDLGenerator.getTableName(this.tileTNPrefix, i)));
                w.println(this.statementDelim);
                ++i;
            }
        }
    }

    void writeDropIndexes(PrintWriter w) throws IOException {
        int i = 0;
        while (i <= this.pyramids) {
            w.print(this.dbDialect.getDropIndexStatment(DDLGenerator.getTableName(this.spatialTNPrefix, i)));
            w.println(this.statementDelim);
            ++i;
        }
    }

    static boolean needsSpatialRegistry(Config config) {
        SpatialExtension type = config.getSpatialExtension();
        return type == SpatialExtension.DB2 || type == SpatialExtension.POSTGIS || type == SpatialExtension.ORACLE;
    }

    void writeRegister(PrintWriter w) throws IOException {
        if (!DDLGenerator.needsSpatialRegistry(this.config)) {
            return;
        }
        int i = 0;
        while (i <= this.pyramids) {
            w.print(this.dbDialect.getRegisterSpatialStatement(DDLGenerator.getTableName(this.spatialTNPrefix, i), this.srs));
            w.println(this.statementDelim);
            ++i;
        }
    }

    void writeUnRegister(PrintWriter w) throws IOException {
        if (!DDLGenerator.needsSpatialRegistry(this.config)) {
            return;
        }
        int i = 0;
        while (i <= this.pyramids) {
            w.print(this.dbDialect.getUnregisterSpatialStatement(DDLGenerator.getTableName(this.spatialTNPrefix, i)));
            w.println(this.statementDelim);
            ++i;
        }
    }
}

