/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKBWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.PlanarImage;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureIterator;
import org.geotools.gce.imagemosaic.jdbc.AbstractCmd;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImportParam;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccessDB2;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccessOracle;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccessPostGis;
import org.geotools.gce.imagemosaic.jdbc.SpatialExtension;
import org.opengis.feature.simple.SimpleFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Import
extends AbstractCmd {
    private static final int DefaultCommitCount = 100;
    private static final String UsageInfo = "Importing from a shapefile or csv file\n\n Importing all levels \n\n-config URLOrFile -spatialTNPrefix spatialTablePrefix -tileTNPrefix tileTablePrefix [-commitCount commitCount] -shape shapeURLOrFile -shapeKeyField shapeKeyField\nImporting from a csv file\n-config URLOrFile -spatialTNPrefix spatialTablePrefix -tileTNPrefix tileTablePrefix [-commitCount commitCount] -csv csvURLOrFile -csvDelim csvDelim\nImporting using world wfiles\n-config URLOrFile -spatialTNPrefix spatialTablePrefix -tileTNPrefix tileTablePrefix [-commitCount commitCount] -dir directory -ext extension\n\n Importing one level \n\n-config URLOrFile -spatialTN spatialTableName -tileTN tileTableName [-commitCount commitCount] -shape shapeURLOrFile -shapeKeyField shapeKeyField\nImporting from a csv file\n-config URLOrFile -spatialTN spatialTableName -tileTN tileTableName [-commitCount commitCount] -csv csvURLOrFile -csvDelim csvDelim\nImporting using world wfiles\n-config URLOrFile -spatialTN spatialTableName -tileTN tileTableName [-commitCount commitCount] -dir directory -ext extension\n\nThe default for commitCount is 100\n";
    private static final String NotSupported = "Imporft not supported for type ";
    private Config config;
    private ImportTyp typ;
    private String spatialTableName;
    private String tileTableName;
    private Connection con;
    private String oracleInsertSpatial;
    private PreparedStatement sqlInsertImage;
    private PreparedStatement sqlInsertSpatial;
    private URL shapeFileUrl;
    private URL csvFileURL;
    private URL directoryURL;
    private String extension;
    private String csvDelimiter;
    private BufferedReader csvReader;
    private String keyInShapeFile;
    private Geometry currentGeom = null;
    private String currentLocation = null;
    private int currentPos;
    private int total;
    private int srs;
    private int commitCount = 100;
    private SimpleFeatureIterator featureIterator;
    private SimpleFeatureCollection featureColl;
    private File[] imageFiles;
    private Logger logger;

    Import(Config config, ImportParam param, int commitCount, Connection con) throws IOException, SQLException {
        this.config = config;
        this.commitCount = commitCount;
        this.spatialTableName = param.getSpatialTableName();
        this.typ = param.getTyp();
        this.tileTableName = param.getTileTableName();
        if (this.typ == ImportTyp.SHAPE) {
            this.shapeFileUrl = param.getSourceURL();
            this.keyInShapeFile = param.getSourceParam();
        } else if (this.typ == ImportTyp.CSV) {
            this.csvFileURL = param.getSourceURL();
            this.csvDelimiter = param.getSourceParam();
        }
        if (this.typ == ImportTyp.DIR) {
            this.directoryURL = param.getSourceURL();
            this.extension = param.getSourceParam();
        }
        this.logger = Logger.getLogger("Import <" + this.spatialTableName + "><" + this.tileTableName + ">");
        this.con = con;
        this.calculateSRS();
        if (!this.isJoined()) {
            this.sqlInsertImage = con.prepareStatement("insert into  " + this.tileTableName + " ( " + config.getBlobAttributeNameInTileTable() + "," + config.getKeyAttributeNameInTileTable() + " ) values (?,?)");
        }
        this.prepareSpatialInsert();
    }

    private void terminate() throws SQLException {
        try {
            if (this.sqlInsertImage != null) {
                this.sqlInsertImage.close();
            }
            if (this.sqlInsertSpatial != null) {
                this.sqlInsertSpatial.close();
            }
        }
        catch (SQLException e) {
            this.logError(e, null);
            throw e;
        }
    }

    public static void start(String[] args) {
        Config config = null;
        String spatialTableName = null;
        String tileTableName = null;
        String spatialTablePrefix = null;
        String tileTablePrefix = null;
        int commitCount = 100;
        URL csvUrl = null;
        URL shapeUrl = null;
        String csvDelim = null;
        String shapeKeyField = null;
        String extension = null;
        String dir = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(CONFIGPARAM)) {
                try {
                    config = Config.readFrom(Import.getURLFromString(args[i + 1]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                if (config != null && (config.getSpatialExtension() == SpatialExtension.GEORASTER || config.getSpatialExtension() == SpatialExtension.CUSTOM)) {
                    System.out.println(NotSupported + config.getSpatialExtension().toString());
                    System.exit(1);
                }
                ++i;
            } else if (args[i].equals("-spatialTN")) {
                spatialTableName = args[i + 1];
                ++i;
            } else if (args[i].equals("-tileTN")) {
                tileTableName = args[i + 1];
                ++i;
            } else if (args[i].equals(SPATIALTNPREFIXPARAM)) {
                spatialTablePrefix = args[i + 1];
                ++i;
            } else if (args[i].equals(TILETNPREFIXPARAM)) {
                tileTablePrefix = args[i + 1];
                ++i;
            } else if (args[i].equals("-commitCount")) {
                commitCount = new Integer(args[i + 1]);
                ++i;
            } else if (args[i].equals("-shape")) {
                shapeUrl = Import.getURLFromString(args[i + 1]);
                if (shapeUrl == null) {
                    System.out.println("Cannot open " + args[i + 1]);
                    System.exit(1);
                }
                ++i;
            } else if (args[i].equals("-csv")) {
                csvUrl = Import.getURLFromString(args[i + 1]);
                if (csvUrl == null) {
                    System.out.println("Cannot open " + args[i + 1]);
                    System.exit(1);
                }
                ++i;
            } else if (args[i].equals("-csvDelim")) {
                csvDelim = args[i + 1];
                ++i;
            } else if (args[i].equals("-shapeKeyField")) {
                shapeKeyField = args[i + 1];
                ++i;
            } else if (args[i].equals("-dir")) {
                dir = args[i + 1];
                File f = new File(dir);
                if (!f.exists()) {
                    System.out.println("Cannot open " + args[i + 1]);
                    System.exit(1);
                }
                ++i;
            } else if (args[i].equals("-ext")) {
                extension = args[i + 1];
                ++i;
            } else {
                System.out.println("Unkwnown option: " + args[i]);
                System.exit(1);
            }
            ++i;
        }
        if (config == null) {
            System.out.println(UsageInfo);
            System.exit(1);
        }
        boolean isLevelImport = false;
        boolean isPrefixImport = false;
        if (spatialTableName != null && tileTableName != null) {
            isLevelImport = true;
        }
        if (spatialTablePrefix != null && tileTablePrefix != null) {
            isPrefixImport = true;
        }
        if (isLevelImport && isPrefixImport || !isLevelImport && !isPrefixImport) {
            System.out.println(UsageInfo);
            System.exit(1);
        }
        ImportTyp typ = null;
        int countNull = 0;
        if (shapeUrl == null) {
            ++countNull;
        } else {
            typ = ImportTyp.SHAPE;
        }
        if (csvUrl == null) {
            ++countNull;
        } else {
            typ = ImportTyp.CSV;
        }
        if (dir == null) {
            ++countNull;
        } else {
            typ = ImportTyp.DIR;
        }
        if (countNull != 2) {
            System.out.println(UsageInfo);
            System.exit(1);
        }
        if (shapeUrl != null && shapeKeyField == null || csvUrl != null && csvDelim == null || dir != null && extension == null) {
            System.out.println(UsageInfo);
            System.exit(1);
        }
        Connection con = null;
        try {
            Class.forName(config.getDriverClassName());
            con = DriverManager.getConnection(config.getJdbcUrl(), config.getUsername(), config.getPassword());
            if (con.getAutoCommit()) {
                con.setAutoCommit(false);
            }
            ArrayList<ImportParam> importParamList = new ArrayList<ImportParam>();
            if (isLevelImport) {
                if (typ == ImportTyp.SHAPE) {
                    importParamList.add(new ImportParam(spatialTableName, tileTableName, shapeUrl, shapeKeyField, ImportTyp.SHAPE));
                }
                if (typ == ImportTyp.CSV) {
                    importParamList.add(new ImportParam(spatialTableName, tileTableName, csvUrl, csvDelim, ImportTyp.CSV));
                }
                if (typ == ImportTyp.DIR) {
                    importParamList.add(new ImportParam(spatialTableName, tileTableName, new File(dir).toURI().toURL(), extension, ImportTyp.DIR));
                }
            }
            if (isPrefixImport) {
                if (typ == ImportTyp.SHAPE) {
                    Import.fillImportParamList(spatialTablePrefix, tileTablePrefix, shapeUrl, shapeKeyField, ImportTyp.SHAPE, importParamList);
                }
                if (typ == ImportTyp.CSV) {
                    Import.fillImportParamList(spatialTablePrefix, tileTablePrefix, csvUrl, csvDelim, ImportTyp.CSV, importParamList);
                }
                if (typ == ImportTyp.DIR) {
                    Import.fillImportParamList(spatialTablePrefix, tileTablePrefix, new File(dir).toURI().toURL(), extension, ImportTyp.DIR, importParamList);
                }
            }
            for (ImportParam param : importParamList) {
                Import imp = new Import(config, param, commitCount, con);
                imp.fillSpatialTable();
                con.commit();
            }
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static void fillImportParamList(String spatialTablePrefix, String tileTablePrefix, URL sourceUrl, String sourceParam, ImportTyp typ, List<ImportParam> importParamList) {
        ImportParam param = new ImportParam(Import.getTableName(spatialTablePrefix, 0), Import.getTableName(tileTablePrefix, 0), sourceUrl, sourceParam, typ);
        importParamList.add(param);
        int level = 1;
        String path = sourceUrl.getPath();
        while (true) {
            String pyramidPath = null;
            int index = path.lastIndexOf(47);
            if (typ == ImportTyp.CSV || typ == ImportTyp.SHAPE) {
                pyramidPath = index == -1 ? String.valueOf(level) + "/" + path : String.valueOf(path.substring(0, index + 1)) + level + "/" + path.substring(index + 1, path.length());
                URL pyramidUrl = null;
                try {
                    pyramidUrl = new URL(sourceUrl.getProtocol(), sourceUrl.getHost(), sourceUrl.getPort(), pyramidPath);
                    pyramidUrl.openStream().close();
                }
                catch (Exception e) {
                    return;
                }
                param = new ImportParam(Import.getTableName(spatialTablePrefix, level), Import.getTableName(tileTablePrefix, level), pyramidUrl, sourceParam, typ);
                importParamList.add(param);
            }
            if (typ == ImportTyp.DIR) {
                File directory;
                pyramidPath = path;
                if (!pyramidPath.endsWith("/")) {
                    pyramidPath = String.valueOf(pyramidPath) + "/";
                }
                if ((directory = new File(pyramidPath = String.valueOf(pyramidPath) + level)).exists()) {
                    URL directoryURL = null;
                    try {
                        directoryURL = directory.toURI().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    param = new ImportParam(Import.getTableName(spatialTablePrefix, level), Import.getTableName(tileTablePrefix, level), directoryURL, sourceParam, typ);
                    importParamList.add(param);
                } else {
                    return;
                }
            }
            ++level;
        }
    }

    private void prepareSpatialInsert() throws SQLException {
        if (this.config.getSpatialExtension() == SpatialExtension.UNIVERSAL) {
            this.sqlInsertSpatial = this.isJoined() ? this.con.prepareStatement("INSERT INTO " + this.spatialTableName + " (" + this.config.getKeyAttributeNameInSpatialTable() + "," + this.config.getTileMinXAttribute() + "," + this.config.getTileMinYAttribute() + "," + this.config.getTileMaxXAttribute() + "," + this.config.getTileMaxYAttribute() + "," + this.config.getBlobAttributeNameInTileTable() + ") VALUES  (?,?,?,?,?,?)") : this.con.prepareStatement("INSERT INTO " + this.spatialTableName + " (" + this.config.getKeyAttributeNameInSpatialTable() + "," + this.config.getTileMinXAttribute() + "," + this.config.getTileMinYAttribute() + "," + this.config.getTileMaxXAttribute() + "," + this.config.getTileMaxYAttribute() + ") VALUES  (?,?,?,?,?)");
            return;
        }
        String geometryParam = null;
        if (this.config.getSpatialExtension() == SpatialExtension.DB2) {
            geometryParam = "db2gse.st_tomultipolygon(db2gse.st_geometry(cast (? as BLOB(4096))," + this.srs + "))";
        } else if (this.config.getSpatialExtension() == SpatialExtension.POSTGIS) {
            geometryParam = "geomfromwkb(?," + this.srs + ")";
        } else if (this.config.getSpatialExtension() == SpatialExtension.MYSQL) {
            geometryParam = "geomfromwkb(?)";
        } else if (this.config.getSpatialExtension() == SpatialExtension.ORACLE) {
            geometryParam = "{0}";
        }
        String statement = null;
        statement = this.isJoined() ? "INSERT INTO " + this.spatialTableName + " (" + this.config.getKeyAttributeNameInSpatialTable() + "," + this.config.getGeomAttributeNameInSpatialTable() + "," + this.config.getBlobAttributeNameInTileTable() + ") VALUES  (?," + geometryParam + ",?)" : "INSERT INTO " + this.spatialTableName + " (" + this.config.getKeyAttributeNameInSpatialTable() + "," + this.config.getGeomAttributeNameInSpatialTable() + ") VALUES  (?," + geometryParam + ")";
        if (this.config.getSpatialExtension() == SpatialExtension.ORACLE) {
            this.oracleInsertSpatial = statement;
        } else {
            this.sqlInsertSpatial = this.con.prepareStatement(statement);
        }
    }

    private void truncateTables() throws SQLException {
        String truncateTable = "truncate table {0}";
        if (this.config.getSpatialExtension() == SpatialExtension.DB2) {
            truncateTable = "alter table {0} activate not logged initially with empty table";
        }
        this.logInfo("Truncating table : " + this.spatialTableName);
        this.con.prepareStatement(MessageFormat.format(truncateTable, this.spatialTableName)).execute();
        if (!this.isJoined()) {
            this.logInfo("Truncating table : " + this.tileTableName);
            this.con.prepareStatement(MessageFormat.format(truncateTable, this.tileTableName)).execute();
        }
    }

    private void calculateSRS() throws SQLException, IOException {
        String schema = this.getSchema();
        String srsSelect = null;
        if (this.config.getSpatialExtension() == SpatialExtension.POSTGIS) {
            srsSelect = JDBCAccessPostGis.SRSSelect;
        } else if (this.config.getSpatialExtension() == SpatialExtension.DB2) {
            srsSelect = schema == null ? JDBCAccessDB2.SRSSelectCurrentSchema : JDBCAccessDB2.SRSSelect;
        } else if (this.config.getSpatialExtension() == SpatialExtension.ORACLE) {
            srsSelect = schema == null ? JDBCAccessOracle.SRSSelectCurrentSchema : JDBCAccessOracle.SRSSelect;
        } else {
            this.srs = 0;
            return;
        }
        PreparedStatement ps = this.con.prepareStatement(srsSelect);
        if (schema != null) {
            ps.setString(1, schema);
            ps.setString(2, this.spatialTableName);
            ps.setString(3, this.config.getGeomAttributeNameInSpatialTable());
        } else {
            ps.setString(1, this.spatialTableName);
            ps.setString(2, this.config.getGeomAttributeNameInSpatialTable());
        }
        ResultSet resultSet = ps.executeQuery();
        if (!resultSet.next()) {
            String msg = String.valueOf(srsSelect) + " has no result for " + (schema != null ? String.valueOf(schema) + "," : "") + this.spatialTableName + "," + this.config.getGeomAttributeNameInSpatialTable();
            throw new IOException(msg);
        }
        this.srs = resultSet.getInt(1);
        resultSet.close();
        ps.close();
    }

    private boolean isJoined() {
        return this.spatialTableName.equals(this.tileTableName);
    }

    private void insertImage(URL imageUrl, byte[] imageBytes) throws SQLException, IOException {
        try {
            this.sqlInsertImage.setBytes(1, imageBytes);
            String path = imageUrl.getPath();
            String location = new File(path).getName();
            this.sqlInsertImage.setString(2, location);
            this.sqlExecute(this.sqlInsertImage);
        }
        catch (SQLException ex) {
            this.logError(ex, null);
            throw ex;
        }
    }

    private void insertMasterRecord() throws Exception {
        this.deleteExistingMasterRecord();
        String statmentString = "INSERT INTO " + this.config.getMasterTable() + "(" + this.config.getCoverageNameAttribute() + "," + this.config.getTileTableNameAtribute() + "," + this.config.getSpatialTableNameAtribute() + ") VALUES (?,?,?)";
        PreparedStatement ps = this.con.prepareStatement(statmentString);
        ps.setString(1, this.config.getCoverageName());
        ps.setString(2, this.tileTableName);
        ps.setString(3, this.spatialTableName);
        ps.execute();
        ps.close();
    }

    private void deleteExistingMasterRecord() throws Exception {
        int count = 0;
        String statmentString = "SELECT count(*) from " + this.config.getMasterTable() + " where " + this.config.getCoverageNameAttribute() + " = ? " + " and " + this.config.getTileTableNameAtribute() + " = ? " + " and " + this.config.getSpatialTableNameAtribute() + " = ? ";
        PreparedStatement ps = this.con.prepareStatement(statmentString);
        ps.setString(1, this.config.getCoverageName());
        ps.setString(2, this.tileTableName);
        ps.setString(3, this.spatialTableName);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        ps.close();
        if (count == 0) {
            return;
        }
        statmentString = "DELETE FROM " + this.config.getMasterTable() + " where " + this.config.getCoverageNameAttribute() + " = ? " + " and " + this.config.getTileTableNameAtribute() + " = ? " + " and " + this.config.getSpatialTableNameAtribute() + " = ? ";
        ps = this.con.prepareStatement(statmentString);
        ps.setString(1, this.config.getCoverageName());
        ps.setString(2, this.tileTableName);
        ps.setString(3, this.spatialTableName);
        ps.execute();
        ps.close();
    }

    private byte[] getImageBytes(URL url) throws IOException {
        try {
            int len;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InputStream in = url.openStream();
            byte[] buff = new byte[4096];
            while ((len = in.read(buff)) > 0) {
                out.write(buff, 0, len);
            }
            out.close();
            in.close();
            return out.toByteArray();
        }
        catch (IOException ex) {
            this.logError(ex, "Error reading image");
            throw ex;
        }
    }

    private SimpleFeatureIterator getFeatureIterator() throws IOException {
        try {
            HashMap<String, URL> map = new HashMap<String, URL>();
            map.put("url", this.shapeFileUrl);
            DataStore shapefile = DataStoreFinder.getDataStore(map);
            int index = this.shapeFileUrl.getPath().lastIndexOf(47);
            int startIndex = index == -1 ? 0 : index + 1;
            index = this.shapeFileUrl.getPath().lastIndexOf(46);
            int endIndex = index == -1 ? this.shapeFileUrl.getPath().length() : index;
            String layerName = this.shapeFileUrl.getPath().substring(startIndex, endIndex);
            SimpleFeatureSource contents = shapefile.getFeatureSource(layerName);
            this.featureColl = contents.getFeatures();
            this.total = this.featureColl.size();
            this.logTotalInfo();
            return this.featureColl.features();
        }
        catch (IOException ex) {
            this.logError(ex, "Cannot open shape file");
            throw ex;
        }
    }

    private URL calculateImageUrl() {
        if (this.typ == ImportTyp.DIR) {
            try {
                return this.imageFiles[this.currentPos - 1].toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        URL startUrl = null;
        if (this.typ == ImportTyp.SHAPE) {
            startUrl = this.shapeFileUrl;
        }
        if (this.typ == ImportTyp.CSV) {
            startUrl = this.csvFileURL;
        }
        String path = startUrl.getPath();
        int index = path.lastIndexOf(47);
        String imagePath = null;
        imagePath = index == -1 ? this.currentLocation : String.valueOf(path.substring(0, index + 1)) + this.currentLocation;
        try {
            return new URL(startUrl.getProtocol(), startUrl.getHost(), startUrl.getPort(), imagePath);
        }
        catch (MalformedURLException e) {
            this.logError(e, e.getMessage());
            return null;
        }
    }

    private BufferedImage readImage2(byte[] imageBytes) throws IOException {
        ByteArraySeekableStream stream = new ByteArraySeekableStream(imageBytes);
        String decoderName = null;
        String[] stringArray = ImageCodec.getDecoderNames((SeekableStream)stream);
        if (stringArray.length != 0) {
            String dn;
            decoderName = dn = stringArray[0];
        }
        ImageDecoder decoder = ImageCodec.createImageDecoder(decoderName, (SeekableStream)stream, null);
        PlanarImage img = PlanarImage.wrapRenderedImage((RenderedImage)decoder.decodeAsRenderedImage());
        return img.getAsBufferedImage();
    }

    void fillSpatialTable() throws Exception {
        this.truncateTables();
        int insertCount = 0;
        while (this.next()) {
            URL imageUrl = this.calculateImageUrl();
            byte[] imageBytes = this.getImageBytes(imageUrl);
            if (this.typ == ImportTyp.DIR) {
                BufferedImage image = null;
                try {
                    image = ImageIO.read(new ByteArrayInputStream(imageBytes));
                }
                catch (IOException e) {
                    image = this.readImage2(imageBytes);
                }
                if (image == null) {
                    image = this.readImage2(imageBytes);
                }
                this.currentGeom = this.getGeomFromWorldFile(this.imageFiles[this.currentPos - 1], image.getWidth(), image.getHeight());
            }
            if (this.config.getSpatialExtension() == SpatialExtension.UNIVERSAL) {
                this.sqlInsertSpatial.setString(1, this.currentLocation);
                Envelope env = this.currentGeom.getEnvelopeInternal();
                this.sqlInsertSpatial.setDouble(2, env.getMinX());
                this.sqlInsertSpatial.setDouble(3, env.getMinY());
                this.sqlInsertSpatial.setDouble(4, env.getMaxX());
                this.sqlInsertSpatial.setDouble(5, env.getMaxY());
                if (this.isJoined()) {
                    this.sqlInsertSpatial.setBytes(6, imageBytes);
                } else {
                    this.insertImage(imageUrl, imageBytes);
                }
                this.sqlExecute(this.sqlInsertSpatial);
            } else if (this.config.getSpatialExtension() == SpatialExtension.DB2 || this.config.getSpatialExtension() == SpatialExtension.MYSQL || this.config.getSpatialExtension() == SpatialExtension.POSTGIS) {
                this.sqlInsertSpatial.setString(1, this.currentLocation);
                WKBWriter w = new WKBWriter();
                byte[] wkb = w.write(this.currentGeom);
                this.sqlInsertSpatial.setBytes(2, wkb);
                if (this.isJoined()) {
                    this.sqlInsertSpatial.setBytes(3, imageBytes);
                } else {
                    this.insertImage(imageUrl, imageBytes);
                }
                this.sqlExecute(this.sqlInsertSpatial);
            } else if (this.config.getSpatialExtension() == SpatialExtension.ORACLE) {
                String stmt = MessageFormat.format(this.oracleInsertSpatial, this.getOracleToGemoetryClause(this.currentGeom));
                this.sqlInsertSpatial = this.con.prepareStatement(stmt);
                this.sqlInsertSpatial.setString(1, this.currentLocation);
                if (this.isJoined()) {
                    this.sqlInsertSpatial.setBytes(2, imageBytes);
                } else {
                    this.insertImage(imageUrl, imageBytes);
                }
                this.sqlInsertSpatial.execute();
                this.sqlInsertSpatial.close();
            }
            this.logInfo("Inserted tile " + this.currentLocation + " : " + ++insertCount + "/" + this.total);
            if (insertCount % this.commitCount != 0) continue;
            this.sqlCommit();
        }
        this.insertMasterRecord();
        this.sqlCommit();
        this.terminate();
        this.logInfo("FINISHED");
    }

    private boolean next() throws IOException {
        block16: {
            block17: {
                block14: {
                    String line;
                    block15: {
                        block12: {
                            block13: {
                                if (this.typ != ImportTyp.SHAPE) break block12;
                                if (this.currentLocation == null) {
                                    this.featureIterator = this.getFeatureIterator();
                                }
                                if (this.featureIterator.hasNext()) break block13;
                                this.featureColl.close((FeatureIterator)this.featureIterator);
                                return false;
                            }
                            SimpleFeature feature = (SimpleFeature)this.featureIterator.next();
                            this.currentGeom = (Geometry)feature.getDefaultGeometry();
                            ++this.currentPos;
                            this.currentLocation = (String)feature.getAttribute(this.keyInShapeFile);
                            return true;
                        }
                        try {
                            if (this.typ != ImportTyp.CSV) break block14;
                            if (this.currentLocation == null) {
                                this.csvReader = new BufferedReader(new InputStreamReader(this.csvFileURL.openStream()));
                                while (this.csvReader.readLine() != null) {
                                    ++this.total;
                                }
                                this.logTotalInfo();
                                this.csvReader.close();
                                this.csvReader = new BufferedReader(new InputStreamReader(this.csvFileURL.openStream()));
                            }
                            if ((line = this.csvReader.readLine()) != null) break block15;
                            this.csvReader.close();
                            return false;
                        }
                        catch (IOException ex) {
                            this.logError(ex, null);
                            throw ex;
                        }
                    }
                    StringTokenizer tok = new StringTokenizer(line, this.csvDelimiter);
                    this.currentLocation = tok.nextToken();
                    Double minx = new Double(tok.nextToken());
                    Double maxx = new Double(tok.nextToken());
                    Double miny = new Double(tok.nextToken());
                    Double maxy = new Double(tok.nextToken());
                    ++this.currentPos;
                    GeometryFactory factory = new GeometryFactory();
                    Coordinate[] coords = new Coordinate[]{new Coordinate(minx.doubleValue(), miny.doubleValue()), new Coordinate(minx.doubleValue(), maxy.doubleValue()), new Coordinate(maxx.doubleValue(), maxy.doubleValue()), new Coordinate(maxx.doubleValue(), miny.doubleValue()), new Coordinate(minx.doubleValue(), miny.doubleValue())};
                    Polygon poly = factory.createPolygon(factory.createLinearRing(coords), new LinearRing[0]);
                    this.currentGeom = factory.createMultiPolygon(new Polygon[]{poly});
                    return true;
                }
                if (this.typ != ImportTyp.DIR) break block16;
                if (this.currentLocation == null) {
                    File dir = DataUtilities.urlToFile((URL)this.directoryURL);
                    this.imageFiles = dir.listFiles(new ImageFilter(this.extension));
                    if (this.imageFiles == null) {
                        this.logInfo("No files found in: " + dir.getPath() + " with extension " + this.extension);
                        System.exit(1);
                    }
                    this.total = this.imageFiles.length;
                    this.logTotalInfo();
                }
                if (this.currentPos != this.total) break block17;
                return false;
            }
            File imageFile = this.imageFiles[this.currentPos];
            this.currentLocation = imageFile.getName();
            this.currentGeom = null;
            ++this.currentPos;
            return true;
        }
        return false;
    }

    private Geometry getGeomFromWorldFile(File imageFile, int width, int height) throws IOException {
        StringBuffer buff = new StringBuffer(imageFile.getAbsolutePath());
        char charToRemove = buff.charAt(buff.length() - 2);
        buff = buff.deleteCharAt(buff.length() - 2);
        if (Character.isUpperCase(charToRemove)) {
            buff.append("W");
        } else {
            buff.append("w");
        }
        File f = new File(buff.toString());
        if (!f.exists()) {
            f = null;
            int index = buff.lastIndexOf(".");
            if (index != -1) {
                buff.delete(index + 1, buff.length());
                buff.append("wld");
                f = new File(buff.toString());
            }
        }
        if (!f.exists()) {
            throw new IOException("Cannot find world file for " + imageFile.getAbsolutePath());
        }
        BufferedReader in = new BufferedReader(new FileReader(f));
        Double resx = new Double(in.readLine());
        in.readLine();
        in.readLine();
        Double resy = new Double(in.readLine());
        Double ulx = new Double(in.readLine());
        Double uly = new Double(in.readLine());
        in.close();
        double minx = ulx;
        double maxx = ulx + (double)width * resx;
        if (resy > 0.0) {
            resy = resy * -1.0;
        }
        double miny = uly + (double)height * resy;
        double maxy = uly;
        GeometryFactory factory = new GeometryFactory();
        Coordinate[] coords = new Coordinate[]{new Coordinate(minx, miny), new Coordinate(minx, maxy), new Coordinate(maxx, maxy), new Coordinate(maxx, miny), new Coordinate(minx, miny)};
        Polygon poly = factory.createPolygon(factory.createLinearRing(coords), new LinearRing[0]);
        return factory.createMultiPolygon(new Polygon[]{poly});
    }

    private void logError(Exception e, String msg) {
        this.logger.log(Level.SEVERE, msg, e);
    }

    private void logInfo(String msg) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, msg);
        }
    }

    private void sqlExecute(PreparedStatement ps) throws SQLException {
        ps.addBatch();
    }

    private void sqlCommit() throws SQLException {
        if (this.sqlInsertImage != null) {
            this.sqlInsertImage.executeBatch();
        }
        if (this.config.getSpatialExtension() != SpatialExtension.ORACLE) {
            this.sqlInsertSpatial.executeBatch();
        }
        this.con.commit();
    }

    private String getSchema() {
        int index = this.spatialTableName.indexOf(46);
        if (index == -1) {
            if (this.config.getSpatialExtension() == SpatialExtension.POSTGIS) {
                return "public";
            }
            return null;
        }
        return this.spatialTableName.substring(0, index);
    }

    private void logTotalInfo() {
        this.logInfo("Number of tiles to import: " + this.total);
    }

    private String getOracleToGemoetryClause(Geometry g) {
        String pattern = "sdo_geometry (2007, " + this.srs + ", null, sdo_elem_info_array (1,1003,1)," + "sdo_ordinate_array ({0},{1}, {2},{3}, {4},{5}, {6},{7}, {8},{9}))";
        Envelope env = g.getEnvelopeInternal();
        NumberFormat f = NumberFormat.getNumberInstance(Locale.ENGLISH);
        f.setGroupingUsed(false);
        Object[] points = new Object[]{f.format(env.getMinX()), f.format(env.getMinY()), f.format(env.getMaxX()), f.format(env.getMinY()), f.format(env.getMaxX()), f.format(env.getMaxY()), f.format(env.getMinX()), f.format(env.getMaxY()), f.format(env.getMinX()), f.format(env.getMinY())};
        return MessageFormat.format(pattern, points);
    }

    class ImageFilter
    implements FileFilter {
        String extension;

        public ImageFilter(String extension) {
            this.extension = extension;
        }

        public boolean accept(File file) {
            int index = file.getName().lastIndexOf(".");
            if (index == -1) {
                return false;
            }
            String ext = file.getName().substring(index + 1);
            return this.extension.equalsIgnoreCase(ext);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImportTyp {
        SHAPE,
        CSV,
        DIR;

    }
}

