/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImageLevelInfo;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccessBase;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class JDBCAccessPostGis
extends JDBCAccessBase {
    static String SRSSelect = "select srid from geometry_columns where f_table_schema=? and f_table_name=? and f_geometry_column=? ";
    static String CRSSelect = "select srtext from spatial_ref_sys where srid=?";
    private String extentSelect = null;
    private String allSelect = null;
    private String allSelectJoined = null;
    private String gridSelect = null;
    private String gridSelectJoined = null;
    private String functionPrefix = "st_";

    JDBCAccessPostGis(Config config) throws IOException {
        super(config);
        this.initForPostGisVersion();
        this.initStatementStrings(config);
    }

    private void initForPostGisVersion() {
        String extentFunctionName = "st_extent";
        Connection con = null;
        ResultSet rs = null;
        Statement ps = null;
        try {
            try {
                con = this.dataSource.getConnection();
                ps = con.prepareStatement("select proname  from pg_proc where proname='" + extentFunctionName + "'");
                rs = ps.executeQuery();
                if (!rs.next()) {
                    this.functionPrefix = "";
                    LOGGER.info("Using depricated postgis functions eg 'extent' instead of 'st_extent'");
                }
            }
            catch (SQLException ex) {
                LOGGER.log(Level.WARNING, "could not verify existence of postgis function 'st_extent', falling back to depricated 'extent'");
                this.functionPrefix = "";
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        ps.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (con != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private void initStatementStrings(Config config) {
        String geomAttr = config.getGeomAttributeNameInSpatialTable();
        this.extentSelect = "select " + this.functionPrefix + "extent(" + geomAttr + ") from {0}";
        String spatialSelectClause = "select s." + config.getKeyAttributeNameInSpatialTable() + "," + "asbinary(" + this.functionPrefix + "envelope(s." + geomAttr + "))";
        this.allSelect = String.valueOf(spatialSelectClause) + ",s." + config.getBlobAttributeNameInTileTable() + " from {0} s";
        this.allSelectJoined = String.valueOf(spatialSelectClause) + ",t." + config.getBlobAttributeNameInTileTable() + " from {0} s, {1} t  WHERE ";
        this.allSelectJoined = String.valueOf(this.allSelectJoined) + " s." + config.getKeyAttributeNameInSpatialTable() + " = t." + config.getKeyAttributeNameInTileTable();
        String whereClause = String.valueOf(this.functionPrefix) + "intersects(" + geomAttr + "," + "GeomFromWKB(?,?))";
        this.gridSelect = String.valueOf(this.allSelect) + " WHERE " + whereClause;
        this.gridSelectJoined = String.valueOf(this.allSelectJoined) + " AND " + whereClause;
    }

    protected String getExtentSelectStatment(ImageLevelInfo li) {
        return MessageFormat.format(this.extentSelect, li.getSpatialTableName());
    }

    protected Envelope getExtent(ImageLevelInfo li, Connection con) throws SQLException, IOException {
        String extentSelect = this.getExtentSelectStatment(li);
        String statementString = MessageFormat.format(extentSelect, li.getSpatialTableName());
        Envelope extent = null;
        PreparedStatement s = con.prepareStatement(statementString);
        ResultSet r = s.executeQuery();
        if (r.next()) {
            Object o = r.getObject(1);
            String pgString = o.toString();
            int start = pgString.indexOf("(") + 1;
            int end = pgString.indexOf(")");
            pgString = pgString.substring(start, end);
            String[] coords = pgString.split(",");
            String[] lower = coords[0].split(" ");
            String[] upper = coords[1].split(" ");
            extent = new Envelope(new Coordinate(new Double(lower[0]).doubleValue(), new Double(lower[1]).doubleValue()), new Coordinate(new Double(upper[0]).doubleValue(), new Double(upper[1]).doubleValue()));
        }
        r.close();
        s.close();
        return extent;
    }

    protected Envelope getEnvelopeFromResultSet(ResultSet r) throws SQLException {
        byte[] bytes = r.getBytes(2);
        WKBReader reader = new WKBReader();
        Geometry bbox = null;
        try {
            bbox = reader.read(bytes);
        }
        catch (ParseException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new SQLException(e.getMessage());
        }
        return bbox.getEnvelopeInternal();
    }

    protected String getRandomTileStatement(ImageLevelInfo li) {
        if (li.isImplementedAsTableSplit()) {
            return MessageFormat.format(this.allSelectJoined, li.getSpatialTableName(), li.getTileTableName());
        }
        return MessageFormat.format(this.allSelect, li.getSpatialTableName());
    }

    protected String getGridSelectStatement(ImageLevelInfo li) {
        if (li.isImplementedAsTableSplit()) {
            return MessageFormat.format(this.gridSelectJoined, li.getSpatialTableName(), li.getTileTableName());
        }
        return MessageFormat.format(this.gridSelect, li.getSpatialTableName());
    }

    protected void setGridSelectParams(PreparedStatement s, GeneralEnvelope envelope, ImageLevelInfo li) throws SQLException {
        WKBWriter w = new WKBWriter();
        byte[] bytes = w.write((Geometry)this.polyFromEnvelope(envelope));
        s.setBytes(1, bytes);
        s.setInt(2, li.getSrsId());
    }

    protected Integer getSRSID(ImageLevelInfo li, Connection con) throws IOException {
        Integer result = null;
        String schema = null;
        try {
            schema = this.getSchemaFromSpatialTable(li.getSpatialTableName());
            PreparedStatement s = null;
            if (schema == null) {
                schema = "public";
            }
            s = con.prepareStatement(SRSSelect);
            s.setString(1, schema);
            s.setString(2, li.getSpatialTableName());
            s.setString(3, this.config.getGeomAttributeNameInSpatialTable());
            ResultSet r = s.executeQuery();
            if (r.next()) {
                result = (Integer)r.getObject(1);
            }
            r.close();
            s.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        if (result == null) {
            String msg = MessageFormat.format("No entry in geometry_columns for {0},{1},{2}", schema, li.getSpatialTableName(), this.config.getGeomAttributeNameInSpatialTable());
            LOGGER.log(Level.SEVERE, msg);
            throw new IOException(msg);
        }
        return result;
    }

    protected CoordinateReferenceSystem getCRS(ImageLevelInfo li, Connection con) throws IOException {
        CoordinateReferenceSystem result = null;
        try {
            PreparedStatement s = con.prepareStatement(CRSSelect);
            s.setInt(1, li.getSrsId());
            ResultSet r = s.executeQuery();
            if (r.next()) {
                String definition = r.getString(1);
                result = CRS.parseWKT((String)definition);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        return result;
    }
}

