/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImageLevelInfo;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccessBase;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class JDBCAccessUniversal
extends JDBCAccessBase {
    private String extentSelect = null;
    private String allSelect = null;
    private String allSelectJoined = null;
    private String gridSelect = null;
    private String gridSelectJoined = null;

    JDBCAccessUniversal(Config config) throws IOException {
        super(config);
        this.initStatementStrings(config);
    }

    private void initStatementStrings(Config config) {
        this.extentSelect = "SELECT ";
        this.extentSelect = String.valueOf(this.extentSelect) + "min(" + config.getTileMinXAttribute() + "),";
        this.extentSelect = String.valueOf(this.extentSelect) + "min(" + config.getTileMinYAttribute() + "),";
        this.extentSelect = String.valueOf(this.extentSelect) + "max(" + config.getTileMaxXAttribute() + "),";
        this.extentSelect = String.valueOf(this.extentSelect) + "max(" + config.getTileMaxYAttribute() + ")";
        this.extentSelect = String.valueOf(this.extentSelect) + " FROM {0}";
        String spatialSelectClause = "SELECT ";
        spatialSelectClause = String.valueOf(spatialSelectClause) + "s." + config.getKeyAttributeNameInSpatialTable() + ",";
        spatialSelectClause = String.valueOf(spatialSelectClause) + "s." + config.getTileMinXAttribute() + ",";
        spatialSelectClause = String.valueOf(spatialSelectClause) + "s." + config.getTileMinYAttribute() + ",";
        spatialSelectClause = String.valueOf(spatialSelectClause) + "s." + config.getTileMaxXAttribute() + ",";
        spatialSelectClause = String.valueOf(spatialSelectClause) + "s." + config.getTileMaxYAttribute();
        this.allSelect = String.valueOf(spatialSelectClause) + ",s." + config.getBlobAttributeNameInTileTable() + " FROM {0} s";
        this.allSelectJoined = String.valueOf(spatialSelectClause) + ",t." + config.getBlobAttributeNameInTileTable() + " FROM {0} s, {1} t WHERE ";
        this.allSelectJoined = String.valueOf(this.allSelectJoined) + " s." + config.getKeyAttributeNameInSpatialTable() + " = t." + config.getKeyAttributeNameInTileTable();
        String whereClause = "";
        whereClause = String.valueOf(whereClause) + " ? > s." + config.getTileMinXAttribute() + " AND ";
        whereClause = String.valueOf(whereClause) + " ? > s." + config.getTileMinYAttribute() + " AND ";
        whereClause = String.valueOf(whereClause) + " ? < s." + config.getTileMaxXAttribute() + " AND ";
        whereClause = String.valueOf(whereClause) + " ? < s." + config.getTileMaxYAttribute();
        this.gridSelect = String.valueOf(this.allSelect) + " WHERE " + whereClause;
        this.gridSelectJoined = String.valueOf(this.allSelectJoined) + " AND " + whereClause;
    }

    protected String getExtentSelectStatment(ImageLevelInfo li) {
        return MessageFormat.format(this.extentSelect, li.getSpatialTableName());
    }

    protected String getRandomTileStatement(ImageLevelInfo li) {
        if (li.isImplementedAsTableSplit()) {
            return MessageFormat.format(this.allSelectJoined, li.getSpatialTableName(), li.getTileTableName());
        }
        return MessageFormat.format(this.allSelect, li.getSpatialTableName());
    }

    protected String getGridSelectStatement(ImageLevelInfo li) {
        if (li.isImplementedAsTableSplit()) {
            return MessageFormat.format(this.gridSelectJoined, li.getSpatialTableName(), li.getTileTableName());
        }
        return MessageFormat.format(this.gridSelect, li.getSpatialTableName());
    }

    protected void setGridSelectParams(PreparedStatement s, GeneralEnvelope envelope, ImageLevelInfo li) throws SQLException {
        s.setDouble(1, envelope.getMaximum(0));
        s.setDouble(2, envelope.getMaximum(1));
        s.setDouble(3, envelope.getMinimum(0));
        s.setDouble(4, envelope.getMinimum(1));
    }

    protected CoordinateReferenceSystem getCRS(ImageLevelInfo li, Connection con) throws IOException {
        return null;
    }
}

