/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc.custom;

import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKBReader;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImageLevelInfo;
import org.geotools.gce.imagemosaic.jdbc.TileQueueElement;
import org.geotools.gce.imagemosaic.jdbc.custom.JDBCAccessCustom;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCAccessOracleGeoRaster
extends JDBCAccessCustom {
    private static final Logger LOGGER = Logging.getLogger((String)JDBCAccessOracleGeoRaster.class.getPackage().getName());
    private static String StmtTemplatePixel = "SELECT  sdo_geor.getCellCoordinate(%s, ?, sdo_geometry(2001,%s,sdo_point_type(?,?,null), null,null)),  sdo_geor.getCellCoordinate(%s, ?, sdo_geometry(2001,%s,sdo_point_type(?,?,null), null,null))  from %s where %s = ?";
    private static String StmtTemplateExport = "declare gr sdo_georaster; lb blob; begin dbms_lob.createtemporary(lb,true); select a.%s into gr from %s a where a.%s = ?; sdo_geor.exportTo(gr, ?, '%s', lb); ?:=lb; end; ";
    private String stmtPixel;
    private String stmtExport;

    public JDBCAccessOracleGeoRaster(Config config) throws IOException {
        super(config);
    }

    @Override
    public void initialize() {
        LOGGER.fine("Starting GeoRaster Image Mosaic");
        Connection con = null;
        try {
            con = this.getConnection();
            int srid = this.getSRID(con);
            this.stmtPixel = String.format(StmtTemplatePixel, this.getConfig().getGeoRasterAttribute(), Integer.toString(srid), this.getConfig().getGeoRasterAttribute(), Integer.toString(srid), this.getConfig().getMasterTable(), this.getConfig().getCoverageNameAttribute());
            this.stmtExport = String.format(StmtTemplateExport, this.getConfig().getGeoRasterAttribute(), this.getConfig().getMasterTable(), this.getConfig().getCoverageNameAttribute(), "TIFF");
            CoordinateReferenceSystem crs = this.getCRS();
            Envelope extent = this.getExtent(con);
            double[] spatialResolutions = this.getSpatialResolutions(con);
            int numberOfPyramidLevels = this.getPyramidLevels(con);
            LOGGER.fine("Base Spatial Resolution X: " + spatialResolutions[0] + ", Y: " + spatialResolutions[1]);
            LOGGER.fine("Number of Pyramids" + numberOfPyramidLevels);
            LOGGER.fine("minX " + extent.getMinX());
            LOGGER.fine("maxX " + extent.getMaxX());
            LOGGER.fine("maxY " + extent.getMaxY());
            LOGGER.fine("minY " + extent.getMinY());
            int i = 0;
            while (i < numberOfPyramidLevels) {
                ImageLevelInfo imageLevel = new ImageLevelInfo();
                imageLevel.setCoverageName(this.getConfig().getCoverageName());
                imageLevel.setSpatialTableName(new String(String.valueOf(i)));
                imageLevel.setTileTableName(new String(String.valueOf(i)));
                imageLevel.setResX(spatialResolutions[0] * Math.pow(2.0, i));
                imageLevel.setResY(spatialResolutions[1] * Math.pow(2.0, i));
                imageLevel.setExtentMinX(extent.getMinX());
                imageLevel.setExtentMinY(extent.getMinY());
                imageLevel.setExtentMaxX(extent.getMaxX());
                imageLevel.setExtentMaxY(extent.getMaxY());
                imageLevel.setSrsId(srid);
                imageLevel.setCrs(crs);
                this.getLevelInfos().add(imageLevel);
                LOGGER.fine("New Level Info for Coverage: " + this.getConfig().getCoverageName() + " Pyramid Level: " + imageLevel.getSpatialTableName());
                LOGGER.fine("Resolution X: " + imageLevel.getResX());
                LOGGER.fine("Resolution Y: " + imageLevel.getResY());
                LOGGER.fine("SRID: " + imageLevel.getSrsId());
                LOGGER.fine("CRS: " + imageLevel.getCrs());
                ++i;
            }
            LOGGER.fine("Image Level List Size: " + this.getLevelInfos().size());
        }
        finally {
            this.closeConnection(con);
        }
    }

    private Envelope getExtent(Connection con) {
        LOGGER.fine("Get Extent Method");
        String extentSelectLBX = "select sdo_geometry.get_wkb(sdo_geor.generateSpatialExtent(" + this.getConfig().getGeoRasterAttribute() + ")) from " + this.getConfig().getMasterTable() + " where " + this.getConfig().getCoverageNameAttribute() + "=?";
        PreparedStatement s = null;
        ResultSet r = null;
        Envelope extent = null;
        try {
            try {
                s = con.prepareStatement(extentSelectLBX);
                s.setString(1, this.getConfig().getCoverageName());
                r = s.executeQuery();
                r.next();
                byte[] wkb = r.getBytes(1);
                Geometry geom = new WKBReader().read(wkb);
                extent = geom.getEnvelopeInternal();
                LOGGER.fine("creating Extent");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(r);
            this.closePreparedStmt(s);
            throw throwable;
        }
        this.closeResultSet(r);
        this.closePreparedStmt(s);
        LOGGER.fine("returning Extent");
        return extent;
    }

    private int getSRID(Connection con) {
        LOGGER.fine("getSRId Method");
        String SRSSelect = "select sdo_geor.getModelSRID(" + this.getConfig().getGeoRasterAttribute() + ") from " + this.getConfig().getMasterTable() + " where " + this.getConfig().getCoverageNameAttribute() + "=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int srid = 0;
        try {
            try {
                stmt = con.prepareStatement(SRSSelect);
                stmt.setString(1, this.getConfig().getCoverageName());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    srid = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closePreparedStmt(stmt);
            throw throwable;
        }
        this.closeResultSet(rs);
        this.closePreparedStmt(stmt);
        return srid;
    }

    private double[] getSpatialResolutions(Connection con) {
        double[] spatialResolution;
        block5: {
            LOGGER.fine("getSpatialResolution Method");
            String sqlSpatialResolution = "select sdo_geor.getspatialresolutions(" + this.getConfig().getGeoRasterAttribute() + ") from " + this.getConfig().getMasterTable() + " where " + this.getConfig().getCoverageNameAttribute() + "=?";
            LOGGER.fine("Sptial Reso SQL:" + sqlSpatialResolution);
            spatialResolution = new double[2];
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = con.prepareStatement(sqlSpatialResolution);
                    stmt.setString(1, this.getConfig().getCoverageName());
                    rs = stmt.executeQuery();
                    rs.next();
                    Array array = rs.getArray(1);
                    BigDecimal[] javaArray = (BigDecimal[])array.getArray();
                    spatialResolution[1] = javaArray[0].doubleValue();
                    spatialResolution[0] = javaArray[1].doubleValue();
                    LOGGER.fine("Assigned X Value: " + spatialResolution[0]);
                    LOGGER.fine("Assigned Y Value: " + spatialResolution[1]);
                }
                catch (Exception ex) {
                    LOGGER.severe("Failure getting spatial resolution");
                    this.closeResultSet(rs);
                    this.closePreparedStmt(stmt);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closePreparedStmt(stmt);
                throw throwable;
            }
            this.closeResultSet(rs);
            this.closePreparedStmt(stmt);
        }
        LOGGER.fine("getSpatialResolution Finished");
        return spatialResolution;
    }

    private int getPyramidLevels(Connection con) {
        LOGGER.fine("getPyrmidLevels Method");
        String sqlPyramidLevels = "select sdo_geor.getPyramidMaxLevel(" + this.getConfig().getGeoRasterAttribute() + ") from " + this.getConfig().getMasterTable() + " where " + this.getConfig().getCoverageNameAttribute() + " = ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int numberOfPyramidLevels = 0;
        try {
            try {
                LOGGER.fine("get pyramid level sql: " + sqlPyramidLevels);
                stmt = con.prepareStatement(sqlPyramidLevels);
                stmt.setString(1, this.getConfig().getCoverageName());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    LOGGER.fine("Assiging number of levels");
                    numberOfPyramidLevels = rs.getInt(1) + 1;
                    LOGGER.fine("Assigned number of levels");
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closePreparedStmt(stmt);
            throw throwable;
        }
        this.closeResultSet(rs);
        this.closePreparedStmt(stmt);
        LOGGER.fine("Returning Pyramid Levels");
        return numberOfPyramidLevels;
    }

    @Override
    public void startTileDecoders(Rectangle pixelDimension, GeneralEnvelope requestEnvelope, ImageLevelInfo info, LinkedBlockingQueue<TileQueueElement> tileQueue, GridCoverageFactory coverageFactory) throws IOException {
        long start = System.currentTimeMillis();
        LOGGER.fine("Starting GeoRaster Tile Decoder");
        Connection con = null;
        con = this.getConnection();
        TileQueueElement tqe = this.getSingleTQElement(requestEnvelope, info, con);
        tileQueue.add(tqe);
        this.closeConnection(con);
        tileQueue.add(TileQueueElement.ENDELEMENT);
        LOGGER.fine("Finished GeoRaster Tile Decoder");
        LOGGER.info("GeoRaster Generation time: " + (System.currentTimeMillis() - start));
    }

    private TileQueueElement getSingleTQElement(GeneralEnvelope envelopeOrig, ImageLevelInfo info, Connection conn) {
        int level = Integer.parseInt(info.getTileTableName());
        BufferedImage bimg = null;
        GeneralEnvelope envelope = new GeneralEnvelope((org.opengis.geometry.Envelope)envelopeOrig);
        GeneralEnvelope intersectEnvelope = new GeneralEnvelope(new double[]{info.getExtentMinX(), info.getExtentMinY()}, new double[]{info.getExtentMaxX(), info.getExtentMaxY()});
        intersectEnvelope.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
        envelope.intersect((org.opengis.geometry.Envelope)intersectEnvelope);
        try {
            ImageDecoder decoder;
            RenderedImage rimage;
            ColorModel cm;
            LOGGER.fine("Starting to Retrieve GeoRaster Image");
            byte[] bytes = this.getImageBytesUsingSDOExport(envelope, level, conn);
            ByteArraySeekableStream stream = new ByteArraySeekableStream(bytes);
            String decoderName = null;
            String[] stringArray = ImageCodec.getDecoderNames((SeekableStream)stream);
            if (stringArray.length != 0) {
                String dn;
                decoderName = dn = stringArray[0];
            }
            if ((cm = (rimage = (decoder = ImageCodec.createImageDecoder(decoderName, (SeekableStream)stream, null)).decodeAsRenderedImage()).getColorModel()) == null) {
                cm = PlanarImage.createColorModel((SampleModel)rimage.getSampleModel());
            }
            PlanarImage pimage = PlanarImage.wrapRenderedImage((RenderedImage)rimage);
            bimg = pimage.getAsBufferedImage(null, cm);
            LOGGER.fine("Creating BufferedImage from GeoRaster Object");
            return new TileQueueElement(this.getConfig().getCoverageName(), bimg, envelope);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private byte[] getImageBytesUsingSDOExport(GeneralEnvelope envelope, int level, Connection conn) {
        byte[] byArray;
        PreparedStatement ps = null;
        CallableStatement cs = null;
        ResultSet r = null;
        try {
            ps = conn.prepareStatement(this.stmtPixel);
            ps.setInt(1, level);
            ps.setDouble(2, envelope.getMinimum(0));
            ps.setDouble(3, envelope.getMaximum(1));
            ps.setInt(4, level);
            ps.setDouble(5, envelope.getMaximum(0));
            ps.setDouble(6, envelope.getMinimum(1));
            ps.setString(7, this.getConfig().getCoverageName());
            r = ps.executeQuery();
            BigDecimal[] pixelCoords1 = null;
            BigDecimal[] pixelCoords2 = null;
            if (!r.next()) {
                throw new RuntimeException("No cell/pixel coordinates for world Envelope " + envelope);
            }
            pixelCoords1 = (BigDecimal[])r.getArray(1).getArray();
            pixelCoords2 = (BigDecimal[])r.getArray(2).getArray();
            r.close();
            ps.close();
            cs = conn.prepareCall(this.stmtExport);
            cs.setString(1, this.getConfig().getCoverageName());
            String params = String.format("pLevel=%d cropArea=(%d,%d,%d,%d)", level, pixelCoords1[0].intValue(), pixelCoords1[1].intValue(), pixelCoords2[0].intValue(), pixelCoords2[1].intValue());
            cs.setString(2, params);
            cs.registerOutParameter(3, 2004);
            cs.execute();
            Blob blob = cs.getBlob(3);
            byte[] bytes = blob.getBytes(1L, (int)blob.length());
            cs.close();
            byArray = bytes;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(r);
                this.closeStmt(ps);
                this.closeStmt(cs);
                throw throwable;
            }
        }
        this.closeResultSet(r);
        this.closeStmt(ps);
        this.closeStmt(cs);
        return byArray;
    }
}

