/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImageLevelInfo;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccessBase;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class JDBCAccessMySql
extends JDBCAccessBase {
    private String extentSelect = null;
    private String allSelect = null;
    private String allSelectJoined = null;
    private String gridSelect = null;
    private String gridSelectJoined = null;

    JDBCAccessMySql(Config config) throws IOException {
        super(config);
        this.initStatementStrings(config);
    }

    private void initStatementStrings(Config config) {
        String geomAttr = config.getGeomAttributeNameInSpatialTable();
        this.extentSelect = "select asbinary(envelope(" + geomAttr + ")) from {0}";
        String spatialSelectClause = "select s." + config.getKeyAttributeNameInSpatialTable() + "," + "asbinary(envelope(s." + geomAttr + "))";
        this.allSelect = spatialSelectClause + ",s." + config.getBlobAttributeNameInTileTable() + " from {0} s";
        this.allSelectJoined = spatialSelectClause + ",t." + config.getBlobAttributeNameInTileTable() + " from {0} s, {1} t  WHERE ";
        this.allSelectJoined = this.allSelectJoined + " s." + config.getKeyAttributeNameInSpatialTable() + " = t." + config.getKeyAttributeNameInTileTable();
        String whereClause = "mbrIntersects(" + geomAttr + "," + "GeomFromWKB(?)) = 1";
        this.gridSelect = this.allSelect + " WHERE " + whereClause;
        this.gridSelectJoined = this.allSelectJoined + " AND " + whereClause;
    }

    protected void setGridSelectParams(PreparedStatement s, GeneralEnvelope envelope, ImageLevelInfo li) throws SQLException {
        WKBWriter w = new WKBWriter();
        byte[] bytes = w.write((Geometry)this.polyFromEnvelope(envelope));
        s.setBytes(1, bytes);
    }

    protected String getRandomTileStatement(ImageLevelInfo li) {
        if (li.isImplementedAsTableSplit()) {
            return MessageFormat.format(this.allSelectJoined, li.getSpatialTableName(), li.getTileTableName());
        }
        return MessageFormat.format(this.allSelect, li.getSpatialTableName());
    }

    protected String getGridSelectStatement(ImageLevelInfo li) {
        if (li.isImplementedAsTableSplit()) {
            return MessageFormat.format(this.gridSelectJoined, li.getSpatialTableName(), li.getTileTableName());
        }
        return MessageFormat.format(this.gridSelect, li.getSpatialTableName());
    }

    protected String getExtentSelectStatment(ImageLevelInfo li) {
        return MessageFormat.format(this.extentSelect, li.getSpatialTableName());
    }

    protected Envelope getExtent(ImageLevelInfo li, Connection con) throws SQLException, IOException {
        String extentSelect = this.getExtentSelectStatment(li);
        String statementString = MessageFormat.format(extentSelect, li.getSpatialTableName());
        Envelope extent = null;
        PreparedStatement s = con.prepareStatement(statementString);
        ResultSet r = s.executeQuery();
        WKBReader reader = new WKBReader();
        while (r.next()) {
            Geometry g;
            byte[] bytes = r.getBytes(1);
            try {
                g = reader.read(bytes);
            }
            catch (ParseException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                throw new IOException(e.getMessage());
            }
            if (extent == null) {
                extent = g.getEnvelopeInternal();
                continue;
            }
            extent.expandToInclude(g.getEnvelopeInternal());
        }
        r.close();
        s.close();
        return extent;
    }

    protected Envelope getEnvelopeFromResultSet(ResultSet r) throws SQLException {
        byte[] bytes = r.getBytes(2);
        WKBReader reader = new WKBReader();
        Geometry bbox = null;
        try {
            bbox = reader.read(bytes);
        }
        catch (ParseException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new SQLException(e.getMessage());
        }
        return bbox.getEnvelopeInternal();
    }

    protected CoordinateReferenceSystem getCRS(ImageLevelInfo li, Connection con) throws IOException {
        return null;
    }
}

