/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc.custom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImageDecoderThread;
import org.geotools.gce.imagemosaic.jdbc.ImageLevelInfo;
import org.geotools.gce.imagemosaic.jdbc.TileQueueElement;
import org.geotools.gce.imagemosaic.jdbc.custom.JDBCAccessCustom;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCAccessPGRaster
extends JDBCAccessCustom {
    private static final Logger LOGGER = Logging.getLogger((String)JDBCAccessPGRaster.class.getPackage().getName());
    protected Map<ImageLevelInfo, String> statementMap;

    public JDBCAccessPGRaster(Config config) throws IOException {
        super(config);
    }

    @Override
    public void initialize() throws IOException {
        Connection con = null;
        try {
            con = this.getConnection();
            if (con.getAutoCommit()) {
                con.setAutoCommit(false);
            }
            this.listGDALFormats(con);
            this.initFromDB(this.getConfig().getCoverageName(), con);
            this.calculateExtentsFromDB(this.getConfig().getCoverageName(), con);
            this.calculateResolutionsFromDB(this.getConfig().getCoverageName(), con);
            con.close();
            for (ImageLevelInfo levelInfo : this.getLevelInfos()) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info(levelInfo.infoString());
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            LOGGER.severe(e.getMessage());
            throw new IOException(e.getMessage());
        }
        if (this.getLevelInfos().isEmpty()) {
            String msg = "No level available for " + this.getConfig().getCoverageName();
            LOGGER.severe(msg);
            throw new IOException(msg);
        }
        TreeSet<ImageLevelInfo> sortColl = new TreeSet<ImageLevelInfo>();
        sortColl.addAll(this.getLevelInfos());
        this.getLevelInfos().clear();
        this.getLevelInfos().addAll(sortColl);
    }

    @Override
    public void startTileDecoders(Rectangle pixelDimension, GeneralEnvelope requestEnvelope, ImageLevelInfo levelInfo, LinkedBlockingQueue<TileQueueElement> tileQueue, GridCoverageFactory coverageFactory) throws IOException {
        Date start = new Date();
        Connection con = null;
        ArrayList<ImageDecoderThread> threads = new ArrayList<ImageDecoderThread>();
        ExecutorService pool = this.getExecutorServivicePool();
        String gridStatement = this.statementMap.get(levelInfo);
        try {
            con = this.getConnection();
            PreparedStatement s = con.prepareStatement(gridStatement);
            WKBWriter w = new WKBWriter();
            byte[] bytes = w.write((Geometry)this.polyFromEnvelope(requestEnvelope));
            s.setBytes(1, bytes);
            s.setInt(2, levelInfo.getSrsId());
            ResultSet r = s.executeQuery();
            while (r.next()) {
                Geometry g;
                byte[] tileBytes = r.getBytes(2);
                byte[] envBytes = r.getBytes(1);
                WKBReader reader = new WKBReader();
                try {
                    g = reader.read(envBytes);
                }
                catch (ParseException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    throw new IOException(e.getMessage());
                }
                Envelope env = g.getEnvelopeInternal();
                Rectangle2D.Double tmp = new Rectangle2D.Double(env.getMinX(), env.getMinY(), env.getWidth(), env.getHeight());
                GeneralEnvelope tileGeneralEnvelope = new GeneralEnvelope((Rectangle2D)tmp);
                tileGeneralEnvelope.setCoordinateReferenceSystem(requestEnvelope.getCoordinateReferenceSystem());
                ImageDecoderThread thread = new ImageDecoderThread(tileBytes, "", tileGeneralEnvelope, pixelDimension, requestEnvelope, levelInfo, tileQueue, this.getConfig());
                threads.add(thread);
                pool.execute(thread);
            }
            r.close();
            s.close();
            con.close();
        }
        catch (SQLException e) {
            try {
                con.close();
            }
            catch (SQLException e1) {
                // empty catch block
            }
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Getting " + threads.size() + " Tiles needs " + (new Date().getTime() - start.getTime()) + " millisecs");
        }
        pool.shutdown();
        try {
            pool.awaitTermination(3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        tileQueue.add(TileQueueElement.ENDELEMENT);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Getting and decoding  " + threads.size() + " Tiles needs " + (new Date().getTime() - start.getTime()) + " millisecs");
        }
    }

    protected void initFromDB(String coverageName, Connection con) throws SQLException, IOException {
        PreparedStatement s = null;
        ResultSet res = null;
        try {
            String stmt = this.getConfig().getSqlSelectCoverageStatement();
            s = con.prepareStatement(stmt);
            s.setString(1, coverageName);
            res = s.executeQuery();
            while (res.next()) {
                ImageLevelInfo imageLevelInfo = new ImageLevelInfo();
                imageLevelInfo.setCoverageName(coverageName);
                imageLevelInfo.setTileTableName(res.getString(this.getConfig().getTileTableNameAtribute()));
                imageLevelInfo.setExtentMaxX(new Double(res.getDouble(this.getConfig().getMaxXAttribute())));
                if (res.wasNull()) {
                    imageLevelInfo.setExtentMaxX(null);
                }
                imageLevelInfo.setExtentMaxY(new Double(res.getDouble(this.getConfig().getMaxYAttribute())));
                if (res.wasNull()) {
                    imageLevelInfo.setExtentMaxY(null);
                }
                imageLevelInfo.setExtentMinX(new Double(res.getDouble(this.getConfig().getMinXAttribute())));
                if (res.wasNull()) {
                    imageLevelInfo.setExtentMinX(null);
                }
                imageLevelInfo.setExtentMinY(new Double(res.getDouble(this.getConfig().getMinYAttribute())));
                if (res.wasNull()) {
                    imageLevelInfo.setExtentMinY(null);
                }
                imageLevelInfo.setResX(new Double(res.getDouble(this.getConfig().getResXAttribute())));
                if (res.wasNull()) {
                    imageLevelInfo.setResX(null);
                }
                imageLevelInfo.setResY(new Double(res.getDouble(this.getConfig().getResYAttribute())));
                if (res.wasNull()) {
                    imageLevelInfo.setResY(null);
                }
                this.getLevelInfos().add(imageLevelInfo);
                imageLevelInfo.setCrs(this.getCRS());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (res != null) {
                res.close();
            }
            if (s != null) {
                s.close();
            }
        }
    }

    void calculateExtentsFromDB(String coverageName, Connection con) throws SQLException, IOException {
        PreparedStatement stmt = con.prepareStatement(this.getConfig().getSqlUpdateMosaicStatement());
        ArrayList<ImageLevelInfo> toBeRemoved = new ArrayList<ImageLevelInfo>();
        for (ImageLevelInfo li : this.getLevelInfos()) {
            if (!li.getCoverageName().equals(coverageName) || !li.calculateExtentsNeeded()) continue;
            Date start = new Date();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Calculate extent for " + li.toString());
            }
            String rasterAttr = this.getConfig().getBlobAttributeNameInTileTable();
            String envSelect = "with envelopes as ( select st_envelope(" + rasterAttr + " ) as env from " + li.getTileTableName() + " ) select st_asbinary(st_extent(env)) from envelopes";
            Envelope envelope = null;
            PreparedStatement s = con.prepareStatement(envSelect);
            ResultSet r = s.executeQuery();
            WKBReader reader = new WKBReader();
            if (r.next()) {
                Geometry g;
                byte[] bytes = r.getBytes(1);
                try {
                    g = reader.read(bytes);
                }
                catch (ParseException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    throw new IOException(e.getMessage());
                }
                envelope = g.getEnvelopeInternal();
            }
            r.close();
            s.close();
            if (envelope == null) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "No extent, removing this level");
                }
                toBeRemoved.add(li);
                continue;
            }
            li.setExtentMaxX(new Double(envelope.getMaxX()));
            li.setExtentMaxY(new Double(envelope.getMaxY()));
            li.setExtentMinX(new Double(envelope.getMinX()));
            li.setExtentMinY(new Double(envelope.getMinY()));
            stmt.setDouble(1, li.getExtentMaxX());
            stmt.setDouble(2, li.getExtentMaxY());
            stmt.setDouble(3, li.getExtentMinX());
            stmt.setDouble(4, li.getExtentMinY());
            stmt.setString(5, li.getCoverageName());
            stmt.setString(6, li.getTileTableName());
            stmt.execute();
            long msecs = new Date().getTime() - start.getTime();
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            LOGGER.info("Calculate extent for " + li.toString() + " finished in " + msecs + " ms ");
        }
        this.getLevelInfos().removeAll(toBeRemoved);
        if (stmt != null) {
            stmt.close();
        }
    }

    void calculateResolutionsFromDB(String coverageName, Connection con) throws SQLException, IOException {
        PreparedStatement stmt = null;
        stmt = con.prepareStatement(this.getConfig().getSqlUpdateResStatement());
        ArrayList<ImageLevelInfo> toBeRemoved = new ArrayList<ImageLevelInfo>();
        this.statementMap = new HashMap<ImageLevelInfo, String>();
        for (ImageLevelInfo li : this.getLevelInfos()) {
            if (!li.getCoverageName().equals(coverageName) || !li.calculateResolutionNeeded()) continue;
            Date start = new Date();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Calculate resolutions for " + li.toString());
            }
            String select = "select st_scalex(" + this.getConfig().getBlobAttributeNameInTileTable() + ")," + "st_scaley(" + this.getConfig().getBlobAttributeNameInTileTable() + ")," + "st_srid(" + this.getConfig().getBlobAttributeNameInTileTable() + ") " + " from " + li.getTileTableName() + " LIMIT 1";
            double[] resolutions = null;
            PreparedStatement ps = con.prepareStatement(select);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                resolutions = new double[]{rs.getDouble(1), rs.getDouble(2)};
                li.setSrsId(rs.getInt(3));
            }
            rs.close();
            ps.close();
            if (resolutions == null) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "No image found, removing " + li.toString());
                }
                toBeRemoved.add(li);
                continue;
            }
            if (resolutions[0] < 0.0) {
                resolutions[0] = resolutions[0] * -1.0;
            }
            if (resolutions[1] < 0.0) {
                resolutions[1] = resolutions[1] * -1.0;
            }
            li.setResX(resolutions[0]);
            li.setResY(resolutions[1]);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("ResX: " + li.getResX() + " ResY: " + li.getResY());
            }
            if ((rs = (ps = con.prepareStatement(select = "select (ST_BandMetaData(" + this.getConfig().getBlobAttributeNameInTileTable() + ")).isoutdb " + " from " + li.getTileTableName() + " LIMIT 1")).executeQuery()).next()) {
                Boolean isOut = (Boolean)rs.getObject("isoutdb");
                String gridStatement = isOut != false ? "SELECT st_asbinary(st_envelope (" + this.getConfig().getBlobAttributeNameInTileTable() + "))," + this.getConfig().getBlobAttributeNameInTileTable() + " from " + li.getTileTableName() + " where st_intersects(" + this.getConfig().getBlobAttributeNameInTileTable() + " ,ST_GeomFromWKB(?,?))" : "SELECT st_asbinary(st_envelope (" + this.getConfig().getBlobAttributeNameInTileTable() + ")),st_aspng(" + this.getConfig().getBlobAttributeNameInTileTable() + ") " + " from " + li.getTileTableName() + " where st_intersects(" + this.getConfig().getBlobAttributeNameInTileTable() + " ,ST_GeomFromWKB(?,?))";
                this.statementMap.put(li, gridStatement);
            }
            rs.close();
            ps.close();
            stmt.setDouble(1, li.getResX());
            stmt.setDouble(2, li.getResY());
            stmt.setString(3, li.getCoverageName());
            stmt.setString(4, li.getTileTableName());
            stmt.execute();
            long msecs = new Date().getTime() - start.getTime();
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            LOGGER.info("Calculate resolutions for " + li.toString() + " finished in " + msecs + " ms ");
        }
        this.getLevelInfos().removeAll(toBeRemoved);
        if (stmt != null) {
            stmt.close();
        }
    }

    protected Polygon polyFromEnvelope(GeneralEnvelope env) {
        GeometryFactory factory = new GeometryFactory();
        Coordinate[] coords = new Coordinate[]{new Coordinate(env.getMinimum(0), env.getMinimum(1)), new Coordinate(env.getMinimum(0), env.getMaximum(1)), new Coordinate(env.getMaximum(0), env.getMaximum(1)), new Coordinate(env.getMaximum(0), env.getMinimum(1)), new Coordinate(env.getMinimum(0), env.getMinimum(1))};
        return factory.createPolygon(factory.createLinearRing(coords), new LinearRing[0]);
    }

    public ExecutorService getExecutorServivicePool() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        LOGGER.info("Using " + availableProcessors + " CPU(s)");
        return Executors.newFixedThreadPool(availableProcessors);
    }

    public void listGDALFormats(Connection con) throws SQLException {
        if (!LOGGER.isLoggable(Level.INFO)) {
            return;
        }
        String statement = "SELECT short_name, long_name FROM st_gdaldrivers() ORDER BY short_name";
        PreparedStatement ps = con.prepareStatement(statement);
        ResultSet rs = ps.executeQuery();
        StringBuffer buff = new StringBuffer("\n\n");
        buff.append("Supported GDAL formats for postgis raster\n");
        buff.append("Short Name\t\t\tLong Name\n");
        buff.append("-----------------------------------------------\n");
        while (rs.next()) {
            buff.append(rs.getString(1));
            buff.append("\t\t\t");
            buff.append(rs.getString(2));
            buff.append("\n");
        }
        LOGGER.info(buff.toString());
        rs.close();
        ps.close();
    }
}

