/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImageLevelInfo;
import org.geotools.gce.imagemosaic.jdbc.TileQueueElement;
import org.geotools.geometry.GeneralEnvelope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractThread
extends Thread {
    LinkedBlockingQueue<TileQueueElement> tileQueue;
    Config config;
    GeneralEnvelope requestEnvelope;
    Rectangle pixelDimension;
    ImageLevelInfo levelInfo;
    double rescaleX;
    double rescaleY;
    double resX;
    double resY;

    AbstractThread(Rectangle pixelDimenison, GeneralEnvelope requestEnvelope, ImageLevelInfo levelInfo, LinkedBlockingQueue<TileQueueElement> tileQueue, Config config) {
        this.config = config;
        this.tileQueue = tileQueue;
        this.requestEnvelope = requestEnvelope;
        this.levelInfo = levelInfo;
        this.pixelDimension = pixelDimenison;
        this.resX = requestEnvelope.getSpan(0) / pixelDimenison.getWidth();
        this.resY = requestEnvelope.getSpan(1) / pixelDimenison.getHeight();
        this.rescaleX = levelInfo.getResX() / this.resX;
        this.rescaleY = levelInfo.getResY() / this.resY;
    }

    Map<RenderingHints.Key, Object> getRenderingHints() {
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        Object interpolation = null;
        if (this.config.getInterpolation() == 1) {
            interpolation = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        }
        if (this.config.getInterpolation() == 2) {
            interpolation = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        }
        if (this.config.getInterpolation() == 3) {
            interpolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
        }
        hints.put(RenderingHints.KEY_INTERPOLATION, interpolation);
        return hints;
    }

    protected BufferedImage rescaleImage(BufferedImage image) {
        BufferedImage scaledImage = null;
        int imageType = image.getType();
        scaledImage = (imageType == 12 || imageType == 13) && image.getColorModel() instanceof IndexColorModel ? new BufferedImage((int)Math.floor((double)image.getWidth() * this.rescaleX), (int)Math.floor((double)image.getHeight() * this.rescaleY), image.getType(), (IndexColorModel)image.getColorModel()) : new BufferedImage((int)Math.floor((double)image.getWidth() * this.rescaleX), (int)Math.floor((double)image.getHeight() * this.rescaleY), image.getType());
        Graphics2D g2D = (Graphics2D)scaledImage.getGraphics();
        g2D.addRenderingHints(this.getRenderingHints());
        g2D.drawImage(image, AffineTransform.getScaleInstance(this.rescaleX, this.rescaleY), null);
        return scaledImage;
    }
}

