/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.factory.Hints;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.visitor.ClientTransactionAccessor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class GeoAPISQLBuilder
implements SQLBuilder {
    protected FilterToSQL encoder;
    protected SimpleFeatureType ft;
    protected ClientTransactionAccessor accessor;
    private Filter lastFilter = null;
    private Filter lastPreFilter = null;
    private Filter lastPostFilter = null;
    private Hints hints;

    public GeoAPISQLBuilder() {
        this(new FilterToSQL(), null, null);
    }

    public GeoAPISQLBuilder(FilterToSQL encoder, SimpleFeatureType featureType, ClientTransactionAccessor accessor) {
        this.encoder = encoder;
        this.ft = featureType;
        this.accessor = accessor;
        encoder.setFeatureType(featureType);
    }

    public void setHints(Hints hints) {
        this.hints = hints;
    }

    public boolean isForce2D() {
        if (this.hints == null) {
            return false;
        }
        Boolean force2d = (Boolean)this.hints.get((Object)Hints.FEATURE_2D);
        if (force2d == null) {
            return false;
        }
        return force2d;
    }

    public Filter getPostQueryFilter(Filter filter) {
        if (!(filter == null || this.lastFilter != null && filter.equals(this.lastFilter))) {
            this.splitFilter(filter);
        }
        return this.lastPostFilter;
    }

    public Filter getPreQueryFilter(Filter filter) {
        if (!(filter == null || this.lastFilter != null && filter.equals(this.lastFilter))) {
            this.splitFilter(filter);
        }
        return this.lastPreFilter;
    }

    protected void splitFilter(Filter filter) {
        this.lastFilter = filter;
        FilterCapabilities cap = this.encoder.getCapabilities();
        PostPreProcessFilterSplittingVisitor pfv = new PostPreProcessFilterSplittingVisitor(cap, this.ft, this.accessor);
        filter.accept((FilterVisitor)pfv, null);
        this.lastPreFilter = pfv.getFilterPre();
        this.lastPostFilter = pfv.getFilterPost();
        SimplifyingFilterVisitor.FIDValidator validator = this.getFidValidator();
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        visitor.setFIDValidator(validator);
        this.lastPreFilter = (Filter)this.lastPreFilter.accept((FilterVisitor)visitor, null);
        this.lastPostFilter = (Filter)this.lastPostFilter.accept((FilterVisitor)visitor, null);
    }

    protected SimplifyingFilterVisitor.FIDValidator getFidValidator() {
        final FIDMapper mapper = this.encoder.getFIDMapper();
        SimplifyingFilterVisitor.FIDValidator validator = mapper == null ? SimplifyingFilterVisitor.ANY_FID_VALID : new SimplifyingFilterVisitor.FIDValidator(){

            public boolean isValid(String fid) {
                return mapper.isValid(fid);
            }
        };
        return validator;
    }

    public void sqlFrom(StringBuffer sql, String typeName) {
        sql.append(" FROM ");
        sql.append(this.encoder.escapeName(typeName));
    }

    public void sqlWhere(StringBuffer sql, Filter preFilter) throws SQLEncoderException {
        if (preFilter != null && preFilter != Filter.INCLUDE) {
            try {
                String where = this.encoder.encodeToString(preFilter);
                sql.append(" ");
                sql.append(where);
            }
            catch (FilterToSQLException fse) {
                throw new SQLEncoderException("", fse);
            }
        }
    }

    public String buildSQLQuery(String typeName, FIDMapper mapper, AttributeDescriptor[] attrTypes, Filter filter, SortBy[] sortBy, Integer offset, Integer limit) throws SQLEncoderException {
        if (offset != null && offset != 0) {
            throw new UnsupportedOperationException("Requested an startIndex of " + offset + " where its not supported");
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT ");
        this.sqlColumns(sqlBuffer, mapper, attrTypes);
        this.sqlFrom(sqlBuffer, typeName);
        this.encoder.setFIDMapper(mapper);
        this.sqlWhere(sqlBuffer, filter);
        if (sortBy != null) {
            this.sqlOrderBy(sqlBuffer, null, sortBy);
        }
        String sqlStmt = sqlBuffer.toString();
        return sqlStmt;
    }

    public String buildSQLQuery(String typeName, FIDMapper mapper, AttributeDescriptor[] attrTypes, Filter filter) throws SQLEncoderException {
        return this.buildSQLQuery(typeName, mapper, attrTypes, filter, null, null, null);
    }

    public void sqlColumns(StringBuffer sql, FIDMapper mapper, AttributeDescriptor[] attributes) {
        int i = 0;
        while (i < mapper.getColumnCount()) {
            sql.append(String.valueOf(this.encoder.escapeName(mapper.getColumnName(i))) + ", ");
            ++i;
        }
        i = 0;
        while (i < attributes.length) {
            if (attributes[i] instanceof GeometryDescriptor) {
                this.sqlGeometryColumn(sql, attributes[i]);
            } else {
                sql.append(this.encoder.escapeName(attributes[i].getLocalName()));
            }
            if (i < attributes.length - 1) {
                sql.append(", ");
            }
            ++i;
        }
    }

    public void sqlGeometryColumn(StringBuffer sql, AttributeDescriptor geomAttribute) {
        sql.append(this.encoder.escapeName(geomAttribute.getLocalName()));
    }

    public void sqlOrderBy(StringBuffer sql, SortBy[] sortBy) throws SQLEncoderException {
        this.sqlOrderBy(sql, null, sortBy);
    }

    public void sqlOrderBy(StringBuffer sql, FIDMapper mapper, SortBy[] sortBy) throws SQLEncoderException {
        if (sortBy == null || sortBy.length == 0) {
            return;
        }
        sql.append(" ORDER BY ");
        int i = 0;
        while (i < sortBy.length) {
            AttributeDescriptor type = (AttributeDescriptor)sortBy[i].getPropertyName().evaluate((Object)this.ft);
            if (type != null) {
                sql.append(this.encoder.escapeName(type.getLocalName()));
            } else {
                sql.append(this.encoder.escapeName(sortBy[i].getPropertyName().getPropertyName()));
            }
            if (SortOrder.DESCENDING.equals((Object)sortBy[i].getSortOrder())) {
                sql.append(" DESC");
            } else {
                sql.append(" ASC");
            }
            if (i < sortBy.length - 1) {
                sql.append(", ");
            }
            ++i;
        }
    }

    public void encode(StringBuffer sql, Expression expression) throws SQLEncoderException {
        try {
            sql.append(this.encoder.encodeToString(expression));
        }
        catch (FilterToSQLException fse) {
            throw new SQLEncoderException("", fse);
        }
    }

    public void encode(StringBuffer sql, Filter filter) throws SQLEncoderException {
        try {
            sql.append(this.encoder.encodeToString(filter).replaceAll("^\\s*WHERE\\s*", ""));
        }
        catch (FilterToSQLException fse) {
            throw new SQLEncoderException("", fse);
        }
    }
}

