/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureReader;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.MutableFIDFeature;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.geometry.BoundingBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDBCTextFeatureWriter
extends JDBCFeatureWriter {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.jdbc");
    protected FIDMapper mapper = null;
    final int STATE_WAIT = 1;
    final int STATE_SUCCESS = 2;
    final int STATE_FAILURE = 3;
    private FeatureListenerManager listenerManager;

    public JDBCTextFeatureWriter(FeatureReader<SimpleFeatureType, SimpleFeature> fReader, QueryData queryData) throws IOException {
        super(fReader, queryData);
        this.mapper = queryData.getMapper();
        this.listenerManager = queryData.getListenerManager();
    }

    @Override
    protected void doInsert(MutableFIDFeature current) throws IOException, SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("inserting into postgis feature " + (Object)((Object)current));
        }
        Statement statement = null;
        Connection conn = null;
        try {
            try {
                conn = this.queryData.getConnection();
                statement = conn.createStatement();
                String sql = this.makeInsertSql((SimpleFeature)current);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(sql);
                }
                statement.executeUpdate(sql);
                if (this.mapper.getColumnCount() > 0 && this.mapper.hasAutoIncrementColumns()) {
                    current.setID(this.mapper.createID(conn, (SimpleFeature)current, statement));
                }
            }
            catch (SQLException sqle) {
                String msg = "SQL Exception writing geometry column" + sqle.getLocalizedMessage();
                LOGGER.log(Level.SEVERE, msg, sqle);
                this.queryData.close(sqle);
                throw new DataSourceException(msg, (Throwable)sqle);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    String msg = "Error closing JDBC Statement";
                    LOGGER.log(Level.WARNING, msg, e);
                }
            }
        }
    }

    protected String makeInsertSql(SimpleFeature feature) throws IOException {
        String attrValue;
        int i;
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        SimpleFeatureType featureType = ftInfo.getSchema();
        String tableName = this.encodeName(featureType.getTypeName());
        List attributeTypes = featureType.getAttributeDescriptors();
        StringBuffer statementSQL = new StringBuffer("INSERT INTO " + tableName + " (");
        HashSet<String> autoincrementColumns = null;
        if (!this.mapper.returnFIDColumnsAsAttributes()) {
            autoincrementColumns = Collections.EMPTY_SET;
            i = 0;
            while (i < this.mapper.getColumnCount()) {
                if (!this.mapper.isAutoIncrement(i) || feature.getAttribute(this.mapper.getColumnName(i)) != null) {
                    statementSQL.append(this.mapper.getColumnName(i)).append(",");
                }
                ++i;
            }
        } else {
            autoincrementColumns = new HashSet<String>();
            i = 0;
            while (i < this.mapper.getColumnCount()) {
                if (this.mapper.isAutoIncrement(i)) {
                    autoincrementColumns.add(this.mapper.getColumnName(i));
                }
                ++i;
            }
        }
        i = 0;
        while (i < attributeTypes.size()) {
            String attName = ((AttributeDescriptor)attributeTypes.get(i)).getLocalName();
            if (!autoincrementColumns.contains(attName) || feature.getAttribute(attName) != null) {
                String colName = this.encodeColumnName(attName);
                statementSQL.append(colName).append(",");
            }
            ++i;
        }
        statementSQL.setCharAt(statementSQL.length() - 1, ')');
        statementSQL.append(" VALUES (");
        if (!this.mapper.returnFIDColumnsAsAttributes() && !this.mapper.hasAutoIncrementColumns()) {
            String FID = this.mapper.createID(this.queryData.getConnection(), feature, null);
            if (this.current instanceof MutableFIDFeature) {
                ((MutableFIDFeature)this.current).setID(FID);
            }
            Object[] primaryKey = this.mapper.getPKAttributes(FID);
            int i2 = 0;
            while (i2 < primaryKey.length) {
                if (!this.mapper.isAutoIncrement(i2) || primaryKey[i2] != null) {
                    attrValue = this.addQuotes(primaryKey[i2]);
                    statementSQL.append(attrValue).append(",");
                }
                ++i2;
            }
        }
        Object[] attributes = feature.getAttributes().toArray();
        int i3 = 0;
        while (i3 < attributeTypes.size()) {
            attrValue = null;
            if (attributeTypes.get(i3) instanceof GeometryDescriptor) {
                GeometryDescriptor descriptor = (GeometryDescriptor)attributeTypes.get(i3);
                String geomName = ((AttributeDescriptor)attributeTypes.get(i3)).getLocalName();
                int srid = ftInfo.getSRID(geomName);
                Geometry geometry = (Geometry)attributes[i3];
                int dimension = 2;
                if (descriptor.getUserData().get(Hints.COORDINATE_DIMENSION) instanceof Integer) {
                    dimension = (Integer)descriptor.getUserData().get(Hints.COORDINATE_DIMENSION);
                } else if (descriptor.getCoordinateReferenceSystem() != null) {
                    dimension = descriptor.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
                }
                attrValue = geometry == null ? "NULL" : this.getGeometryInsertText(geometry, srid, dimension);
            } else if (!autoincrementColumns.contains(((AttributeDescriptor)attributeTypes.get(i3)).getLocalName()) || attributes[i3] != null) {
                attrValue = this.addQuotes(attributes[i3]);
            }
            if (attrValue != null) {
                statementSQL.append(String.valueOf(attrValue) + ",");
            }
            ++i3;
        }
        statementSQL.setCharAt(statementSQL.length() - 1, ')');
        return statementSQL.toString();
    }

    protected String addQuotes(Object value) {
        String retString = value != null ? (value instanceof Number ? value.toString() : "'" + this.doubleQuote(value) + "'") : "null";
        return retString;
    }

    String doubleQuote(Object obj) {
        return obj.toString().replaceAll("'", "''");
    }

    protected abstract String getGeometryInsertText(Geometry var1, int var2) throws IOException;

    protected String getGeometryInsertText(Geometry geom, int srid, int dimension) throws IOException {
        return this.getGeometryInsertText(geom, srid);
    }

    @Override
    public void remove() throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("inserting into postgis feature " + this.current);
        }
        Statement statement = null;
        Connection conn = null;
        try {
            try {
                conn = this.queryData.getConnection();
                statement = conn.createStatement();
                ReferencedEnvelope bounds = ReferencedEnvelope.reference((BoundingBox)this.live.getBounds());
                String sql = this.makeDeleteSql(this.current);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(sql);
                }
                statement.executeUpdate(sql);
                this.listenerManager.fireFeaturesRemoved(this.getFeatureType().getTypeName(), this.queryData.getTransaction(), bounds, false);
            }
            catch (SQLException sqle) {
                String msg = "SQL Exception writing geometry column";
                LOGGER.log(Level.SEVERE, msg, sqle);
                this.queryData.close(sqle);
                throw new DataSourceException(msg, (Throwable)sqle);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    String msg = "Error closing JDBC Statement";
                    LOGGER.log(Level.WARNING, msg, e);
                }
            }
        }
    }

    protected String makeDeleteSql(SimpleFeature feature) throws IOException {
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        SimpleFeatureType fetureType = ftInfo.getSchema();
        String tableName = this.encodeName(fetureType.getTypeName());
        StringBuffer statementSQL = new StringBuffer("DELETE FROM " + tableName + " WHERE ");
        Object[] pkValues = this.mapper.getPKAttributes(feature.getID());
        int i = 0;
        while (i < this.mapper.getColumnCount()) {
            statementSQL.append(this.encodeColumnName(this.mapper.getColumnName(i))).append(" = ").append(this.addQuotes(pkValues[i]));
            if (i < this.mapper.getColumnCount() - 1) {
                statementSQL.append(" AND ");
            }
            ++i;
        }
        return statementSQL.toString();
    }

    @Override
    protected void doUpdate(SimpleFeature live, SimpleFeature current) throws IOException, SQLException {
        block26: {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("updating postgis feature " + current);
            }
            Statement statement = null;
            Connection conn = null;
            try {
                try {
                    conn = this.queryData.getConnection();
                    statement = conn.createStatement();
                    boolean hasLock = false;
                    String sql = this.makeSelectForUpdateSql(current);
                    if (sql == null) {
                        LOGGER.fine("Lock acquisition not attempted, JDBCTextFeatureWriter may block during concurrent updates");
                    } else {
                        ResultSet result = null;
                        try {
                            try {
                                result = statement.executeQuery(sql);
                                hasLock = true;
                            }
                            catch (SQLException e) {
                                LOGGER.severe(e.getLocalizedMessage());
                                throw new FeatureLockException("Your feature is locked!", current.getID(), (Throwable)e);
                            }
                        }
                        finally {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (SQLException sQLException) {}
                                result = null;
                            }
                        }
                    }
                    if (sql == null || hasLock) {
                        sql = this.makeUpdateSql(live, current);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(sql);
                        }
                        statement.executeUpdate(sql);
                        break block26;
                    }
                    throw new IOException("Feature Lock failed; giving up");
                }
                catch (SQLException sqle) {
                    String msg = "SQL Exception writing geometry column";
                    LOGGER.log(Level.SEVERE, msg, sqle);
                    this.queryData.close(sqle);
                    throw new DataSourceException(msg, (Throwable)sqle);
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        String msg = "Error closing JDBC Statement";
                        LOGGER.log(Level.WARNING, msg, e);
                    }
                }
            }
        }
    }

    protected String makeSelectForUpdateSql(SimpleFeature current) {
        return null;
    }

    protected String makeUpdateSql(SimpleFeature live, SimpleFeature current) throws IOException {
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        SimpleFeatureType featureType = ftInfo.getSchema();
        AttributeDescriptor[] attributes = featureType.getAttributeDescriptors().toArray(new AttributeDescriptor[featureType.getAttributeDescriptors().size()]);
        String tableName = this.encodeName(featureType.getTypeName());
        StringBuffer statementSQL = new StringBuffer("UPDATE " + tableName + " SET ");
        int i = 0;
        while (i < current.getAttributeCount()) {
            Object currAtt = current.getAttribute(i);
            Object liveAtt = live.getAttribute(i);
            if (!DataUtilities.attributesEqual((Object)liveAtt, (Object)currAtt)) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.fine("modifying att# " + i + " to " + currAtt);
                }
                String attrValue = null;
                if (attributes[i] instanceof GeometryDescriptor) {
                    String geomName = attributes[i].getLocalName();
                    int srid = ftInfo.getSRID(geomName);
                    Geometry geometry = (Geometry)currAtt;
                    attrValue = geometry == null ? "NULL" : this.getGeometryInsertText(geometry, srid);
                } else {
                    attrValue = this.addQuotes(currAtt);
                }
                String colName = this.encodeColumnName(attributes[i].getLocalName());
                statementSQL.append(colName).append(" = ").append(attrValue).append(", ");
            }
            ++i;
        }
        statementSQL.setLength(statementSQL.length() - 2);
        statementSQL.append(" WHERE ");
        Object[] pkValues = this.mapper.getPKAttributes(current.getID());
        int i2 = 0;
        while (i2 < this.mapper.getColumnCount()) {
            statementSQL.append(this.mapper.getColumnName(i2)).append(" = ").append(this.addQuotes(pkValues[i2]));
            if (i2 < this.mapper.getColumnCount() - 1) {
                statementSQL.append(" AND ");
            }
            ++i2;
        }
        return statementSQL.toString();
    }

    @Override
    protected boolean useQueryDataForInsert() {
        return false;
    }
}

