/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.fidmapper;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.Statement;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.fidmapper.AbstractFIDMapper;
import org.opengis.feature.simple.SimpleFeature;

public class MultiColumnFIDMapper
extends AbstractFIDMapper {
    private static final long serialVersionUID = 1L;
    private static final String UTF8 = "UTF-8";

    public MultiColumnFIDMapper(String tableSchemaName, String tableName, String[] colNames, int[] colTypes, int[] colSizes, int[] colDecimalDigits, boolean[] autoIncrement) {
        super(tableSchemaName, tableName);
        if (colNames == null || colTypes == null || autoIncrement == null) {
            throw new IllegalArgumentException("Column description arrays must be not null");
        }
        if (colNames.length == 0) {
            throw new IllegalArgumentException("Column description arrays must be not empty");
        }
        if (colNames.length != colTypes.length || colNames.length != autoIncrement.length) {
            throw new IllegalArgumentException("Column description arrays must have the same size");
        }
        this.colNames = colNames;
        this.colTypes = colTypes;
        this.colSizes = colSizes;
        this.colDecimalDigits = colDecimalDigits;
        this.autoIncrement = autoIncrement;
        this.returnFIDColumnsAsAttributes = true;
    }

    public MultiColumnFIDMapper(String[] colNames, int[] colTypes, int[] colSizes, int[] colDecimalDigits, boolean[] autoIncrement) {
        this(null, null, colNames, colTypes, colSizes, colDecimalDigits, autoIncrement);
    }

    public String getID(Object[] attributes) {
        StringBuffer sb = new StringBuffer();
        try {
            int i = 0;
            while (i < attributes.length) {
                sb.append(URLEncoder.encode(attributes[i].toString(), UTF8));
                if (i < attributes.length - 1) {
                    sb.append("&");
                }
                ++i;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return sb.toString();
    }

    public Object[] getPKAttributes(String FID) throws IOException {
        Object[] attributes = FID.split("&");
        if (attributes.length != this.colNames.length) {
            throw new DataSourceException("The FID is not compatible with MultiColumnFIDMapper, was expecting " + this.colNames.length + " URL-encoded columns and got " + attributes.length + " columns");
        }
        int i = 0;
        while (i < attributes.length) {
            attributes[i] = URLDecoder.decode((String)attributes[i], UTF8);
            ++i;
        }
        return attributes;
    }

    public String createID(Connection conn, SimpleFeature feature, Statement statement) throws IOException {
        Object[] attValues = new String[this.colNames.length];
        int i = 0;
        while (i < this.colNames.length) {
            attValues[i] = feature.getAttribute(this.colNames[i]).toString();
            ++i;
        }
        return this.getID(attValues);
    }

    public boolean isValid(String fid) {
        String[] attributes = fid.split("&");
        return attributes.length == this.colNames.length;
    }
}

