/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import org.geotools.data.DelegatingFeatureWriter;
import org.geotools.data.FeatureWriter;
import org.geotools.jdbc.JDBCFeatureReader;
import org.geotools.jdbc.JDBCFeatureSource;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCClosingFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    FeatureWriter writer;

    public JDBCClosingFeatureWriter(FeatureWriter writer) {
        this.writer = writer;
    }

    public SimpleFeatureType getFeatureType() {
        return (SimpleFeatureType)this.writer.getFeatureType();
    }

    public boolean hasNext() throws IOException {
        return this.writer.hasNext();
    }

    public SimpleFeature next() throws IOException {
        return (SimpleFeature)this.writer.next();
    }

    public void remove() throws IOException {
        this.writer.remove();
    }

    public void write() throws IOException {
        this.writer.write();
    }

    public void close() throws IOException {
        FeatureWriter w = this.writer;
        while (w instanceof DelegatingFeatureWriter) {
            if (w instanceof JDBCFeatureReader) break;
            w = ((DelegatingFeatureWriter)w).getDelegate();
        }
        if (w instanceof JDBCFeatureReader) {
            JDBCFeatureReader jdbcReader = (JDBCFeatureReader)w;
            JDBCFeatureSource fs = jdbcReader.featureSource;
            Connection cx = jdbcReader.cx;
            try {
                this.writer.close();
            }
            finally {
                fs.getDataStore().releaseConnection(cx, fs.getState());
            }
        }
    }
}

