/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import junit.framework.TestCase;
import org.easymock.classextension.EasyMock;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCFeatureCollection;
import org.geotools.data.jdbc.JDBCFeatureSource;
import org.opengis.feature.simple.SimpleFeatureType;

public class JDBCFeatureCollectionTest
extends TestCase {
    public void testMaxFeatureOptimized() throws Exception {
        DefaultQuery q = new DefaultQuery("roads");
        q.setMaxFeatures(10);
        SimpleFeatureType type = DataUtilities.createType((String)"roads", (String)"_=the_geom:Point,FID:String,NAME:String");
        JDBCFeatureSource fs = (JDBCFeatureSource)EasyMock.createMock(JDBCFeatureSource.class);
        org.easymock.EasyMock.expect((Object)fs.getSchema()).andReturn((Object)type).anyTimes();
        org.easymock.EasyMock.expect((Object)fs.count((Query)q, Transaction.AUTO_COMMIT)).andReturn((Object)20);
        EasyMock.replay((Object[])new Object[]{fs});
        JDBCFeatureCollection results = new JDBCFeatureCollection(fs, (Query)q);
        JDBCFeatureCollectionTest.assertEquals((int)10, (int)results.size());
    }

    public void testMaxfeaturesHandCount() throws Exception {
        DefaultQuery q = new DefaultQuery("roads");
        q.setMaxFeatures(1);
        FeatureReader fr = (FeatureReader)EasyMock.createNiceMock(FeatureReader.class);
        org.easymock.EasyMock.expect((Object)fr.hasNext()).andReturn((Object)true).times(2).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{fr});
        DataStore ds = (DataStore)EasyMock.createMock(JDBC1DataStore.class);
        org.easymock.EasyMock.expect((Object)ds.getFeatureReader((Query)q, Transaction.AUTO_COMMIT)).andReturn((Object)fr);
        EasyMock.replay((Object[])new Object[]{ds});
        SimpleFeatureType type = DataUtilities.createType((String)"roads", (String)"_=the_geom:Point,FID:String,NAME:String");
        JDBCFeatureSource fs = (JDBCFeatureSource)EasyMock.createMock(JDBCFeatureSource.class);
        org.easymock.EasyMock.expect((Object)fs.getSchema()).andReturn((Object)type).anyTimes();
        org.easymock.EasyMock.expect((Object)fs.count((Query)q, Transaction.AUTO_COMMIT)).andReturn((Object)-1);
        org.easymock.EasyMock.expect((Object)fs.getCount((Query)q)).andReturn((Object)-1);
        org.easymock.EasyMock.expect((Object)fs.getDataStore()).andReturn((Object)ds);
        EasyMock.replay((Object[])new Object[]{fs});
        JDBCFeatureCollection results = new JDBCFeatureCollection(fs, (Query)q);
        JDBCFeatureCollectionTest.assertEquals((int)1, (int)results.size());
    }
}

