/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.jdbc.JDBCEmptyGeometryTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.simple.SimpleFeature;

public abstract class JDBCEmptyGeometryTest
extends JDBCTestSupport {
    protected abstract JDBCEmptyGeometryTestSetup createTestSetup();

    public void testEmptyPoint() throws Exception {
        this.testInsertEmptyGeometry("POINT");
    }

    public void testEmptyLine() throws Exception {
        this.testInsertEmptyGeometry("LINESTRING");
    }

    public void testEmptyPolygon() throws Exception {
        this.testInsertEmptyGeometry("POLYGON");
    }

    public void testEmptyMultiPoint() throws Exception {
        this.testInsertEmptyGeometry("MULTIPOINT");
    }

    public void testEmptyMultiLine() throws Exception {
        this.testInsertEmptyGeometry("MULTILINESTRING");
    }

    public void testEmptyMultiPolygon() throws Exception {
        this.testInsertEmptyGeometry("MULTIPOLYGON");
    }

    private void testInsertEmptyGeometry(String type) throws Exception {
        WKTReader reader = new WKTReader();
        Geometry emptyGeometry = reader.read(type.toUpperCase() + " EMPTY");
        DefaultTransaction tx = new DefaultTransaction();
        FeatureWriter writer = this.dataStore.getFeatureWriterAppend(this.tname("empty"), (Transaction)tx);
        SimpleFeature feature = (SimpleFeature)writer.next();
        feature.setAttribute(this.aname("id"), (Object)new Integer(100));
        feature.setAttribute(this.aname("geom_" + type.toLowerCase()), (Object)emptyGeometry);
        feature.setAttribute(this.aname("name"), (Object)new String("empty " + type));
        writer.write();
        writer.close();
        tx.commit();
        tx.close();
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname("empty")).getFeatures();
        JDBCEmptyGeometryTest.assertEquals((int)1, (int)fc.size());
        SimpleFeatureIterator fi = fc.features();
        SimpleFeature nf = (SimpleFeature)fi.next();
        fi.close();
        Geometry geometry = (Geometry)nf.getDefaultGeometry();
        JDBCEmptyGeometryTest.assertTrue((geometry == null || geometry.isEmpty() ? 1 : 0) != 0);
    }
}

