/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.geotools.data.jdbc.ManagedPooledConnection;
import org.geotools.util.logging.Logging;

public final class ConnectionPool {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.jdbc");
    private static final long DEFAULT_POOL_CLEANER_WAIT = 30000L;
    private Object mutex = new Object();
    private ConnectionPoolDataSource cpDataSource;
    private LinkedList availableConnections = new LinkedList();
    private LinkedList usedConnections = new LinkedList();
    private ConnectionListManager listManager = new ConnectionListManager();
    private ConnectionPoolCleaner poolCleaner;
    private boolean closed = false;

    public ConnectionPool(ConnectionPoolDataSource cpDataSource) {
        this.cpDataSource = cpDataSource;
        this.poolCleaner = new ConnectionPoolCleaner(30000L);
        Thread cleanerThread = new Thread(this.poolCleaner);
        cleanerThread.setDaemon(true);
        cleanerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        if (this.closed) {
            throw new SQLException("The ConnectionPool has been closed.");
        }
        Connection conn = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.availableConnections.size() > 0) {
                LOGGER.fine("Getting available connection.");
                ManagedPooledConnection mConn = (ManagedPooledConnection)this.availableConnections.removeFirst();
                conn = mConn.pooledConn.getConnection();
                mConn.lastUsed = System.currentTimeMillis();
                mConn.inUse = true;
                this.usedConnections.add(mConn);
            } else {
                LOGGER.fine("No available connections, creating a new one.");
                PooledConnection pConn = this.cpDataSource.getPooledConnection();
                conn = pConn.getConnection();
                pConn.addConnectionEventListener(this.listManager);
                ManagedPooledConnection mConn = new ManagedPooledConnection(pConn);
                mConn.inUse = true;
                mConn.lastUsed = System.currentTimeMillis();
                this.usedConnections.add(mConn);
            }
        }
        return conn;
    }

    private ManagedPooledConnection getInUseManagedPooledConnection(PooledConnection conn) {
        ManagedPooledConnection returnConn = null;
        for (ManagedPooledConnection mConn : this.usedConnections) {
            if (mConn.pooledConn != conn) continue;
            returnConn = mConn;
        }
        return returnConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            ManagedPooledConnection mPool;
            int i;
            int size = this.usedConnections.size();
            for (i = 0; i < size; ++i) {
                mPool = (ManagedPooledConnection)this.usedConnections.removeFirst();
                mPool.pooledConn.removeConnectionEventListener(this.listManager);
                try {
                    mPool.pooledConn.close();
                    continue;
                }
                catch (SQLException e) {
                    LOGGER.warning("Failed to close PooledConnection: " + e);
                }
            }
            size = this.availableConnections.size();
            for (i = 0; i < size; ++i) {
                mPool = (ManagedPooledConnection)this.availableConnections.removeFirst();
                mPool.pooledConn.removeConnectionEventListener(this.listManager);
                try {
                    mPool.pooledConn.close();
                    continue;
                }
                catch (SQLException e) {
                    LOGGER.warning("Failed to close PooledConnection: " + e);
                }
            }
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private class ConnectionPoolCleaner
    implements Runnable {
        private long waitTime;
        private boolean active = true;

        ConnectionPoolCleaner(long waitTime) {
            this.waitTime = waitTime;
        }

        void disable() {
            this.active = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.active) {
                Object object = ConnectionPool.this.mutex;
                synchronized (object) {
                    Iterator iter = ConnectionPool.this.availableConnections.iterator();
                    while (iter.hasNext()) {
                        ManagedPooledConnection conn = (ManagedPooledConnection)iter.next();
                        conn.pooledConn.removeConnectionEventListener(ConnectionPool.this.listManager);
                        if (!conn.isValid()) {
                            LOGGER.fine("Connection invalid, removing from pool");
                            try {
                                conn.pooledConn.close();
                            }
                            catch (SQLException e) {
                                LOGGER.log(Level.WARNING, "Error closing dead connection", e);
                            }
                            iter.remove();
                            continue;
                        }
                        conn.pooledConn.addConnectionEventListener(ConnectionPool.this.listManager);
                    }
                }
                try {
                    Thread.sleep(this.waitTime);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Interrupted exception when wait in Pool Cleaner", e);
                }
            }
        }
    }

    private class ConnectionListManager
    implements ConnectionEventListener {
        private ConnectionListManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed(ConnectionEvent event) {
            LOGGER.fine("Connection closed - adding to available connections.");
            PooledConnection conn = (PooledConnection)event.getSource();
            Object object = ConnectionPool.this.mutex;
            synchronized (object) {
                ManagedPooledConnection mConn = ConnectionPool.this.getInUseManagedPooledConnection(conn);
                mConn.inUse = false;
                ConnectionPool.this.usedConnections.remove(mConn);
                ConnectionPool.this.availableConnections.addLast(mConn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionErrorOccurred(ConnectionEvent event) {
            PooledConnection conn = (PooledConnection)event.getSource();
            Object object = ConnectionPool.this.mutex;
            synchronized (object) {
                ManagedPooledConnection mConn = ConnectionPool.this.getInUseManagedPooledConnection(conn);
                conn.removeConnectionEventListener(this);
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, "Error closing a connection", e);
                }
                ConnectionPool.this.usedConnections.remove(mConn);
            }
        }
    }
}

