/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.geotools.data.Transaction;
import org.geotools.jdbc.JDBCDataStore;

final class JDBCTransactionState
implements Transaction.State {
    JDBCDataStore dataStore;
    Transaction tx;
    Connection cx;
    boolean external;

    public JDBCTransactionState(Connection cx, JDBCDataStore dataStore) {
        this(cx, dataStore, false);
    }

    public JDBCTransactionState(Connection cx, JDBCDataStore dataStore, boolean external) {
        this.cx = cx;
        this.dataStore = dataStore;
        this.external = external;
    }

    public void setTransaction(Transaction tx) {
        if (tx != null && this.tx != null) {
            throw new IllegalStateException("New transaction set without closing old transaction first.");
        }
        if (tx == null) {
            if (this.cx != null && !this.external) {
                this.dataStore.closeSafe(this.cx);
            } else {
                this.dataStore.getLogger().warning("Transaction is attempting to close an already closed connection");
            }
            this.cx = null;
        }
        this.tx = tx;
    }

    public void addAuthorization(String AuthID) throws IOException {
    }

    public void commit() throws IOException {
        if (!this.external) {
            try {
                this.cx.commit();
            }
            catch (SQLException e) {
                String msg = "Error occured on commit";
                throw (IOException)new IOException(msg).initCause(e);
            }
        }
    }

    public void rollback() throws IOException {
        if (!this.external) {
            try {
                this.cx.rollback();
            }
            catch (SQLException e) {
                String msg = "Error occured on rollback";
                throw (IOException)new IOException(msg).initCause(e);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (!this.external && this.cx != null && !this.cx.isClosed()) {
            Logger.getLogger("org.geotools.jdbc").severe("State finalized with open connection.");
            this.dataStore.closeSafe(this.cx);
        }
    }
}

