/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataAccessFinder {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data");
    private static FactoryRegistry registry;

    private DataAccessFinder() {
    }

    public static synchronized DataAccess<FeatureType, Feature> getDataStore(Map<String, Serializable> params) throws IOException {
        Iterator<DataAccessFactory> ps = DataAccessFinder.getAvailableDataStores();
        return DataAccessFinder.getDataStore(params, ps);
    }

    static DataAccess<? extends FeatureType, ? extends Feature> getDataStore(Map<String, Serializable> params, Iterator<? extends DataAccessFactory> ps) throws IOException {
        IOException canProcessButNotAvailable = null;
        while (ps.hasNext()) {
            DataAccessFactory fac = ps.next();
            boolean canProcess = false;
            try {
                canProcess = fac.canProcess(params);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Problem asking " + fac.getDisplayName() + " if it can process request:" + t, t);
                continue;
            }
            if (!canProcess) continue;
            boolean isAvailable = false;
            try {
                isAvailable = fac.isAvailable();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Difficulity checking if " + fac.getDisplayName() + " is available:" + t, t);
                continue;
            }
            if (isAvailable) {
                try {
                    return fac.createDataStore(params);
                }
                catch (IOException couldNotConnect) {
                    canProcessButNotAvailable = couldNotConnect;
                    LOGGER.log(Level.WARNING, fac.getDisplayName() + " should be used, but could not connect", couldNotConnect);
                    continue;
                }
            }
            canProcessButNotAvailable = new IOException(fac.getDisplayName() + " should be used, but is not availble. Have you installed the required drivers or jar files?");
            LOGGER.log(Level.WARNING, fac.getDisplayName() + " should be used, but is not availble", canProcessButNotAvailable);
        }
        if (canProcessButNotAvailable != null) {
            throw canProcessButNotAvailable;
        }
        return null;
    }

    public static synchronized Iterator<DataAccessFactory> getAllDataStores() {
        HashSet<Object> all = new HashSet<Object>();
        Iterator<DataStoreFactorySpi> allDataStores = DataStoreFinder.getAllDataStores();
        Iterator<DataAccessFactory> allDataAccess = DataAccessFinder.getAllDataStores(DataAccessFinder.getServiceRegistry(), DataAccessFactory.class);
        while (allDataStores.hasNext()) {
            DataStoreFactorySpi next = allDataStores.next();
            all.add(next);
        }
        while (allDataAccess.hasNext()) {
            all.add(allDataAccess.next());
        }
        return all.iterator();
    }

    static synchronized <T extends DataAccessFactory> Iterator<T> getAllDataStores(FactoryRegistry registry, Class<T> category) {
        return registry.getServiceProviders(category, null, null);
    }

    public static synchronized Iterator<DataAccessFactory> getAvailableDataStores() {
        FactoryRegistry serviceRegistry = DataAccessFinder.getServiceRegistry();
        Set<DataAccessFactory> availableDS = DataAccessFinder.getAvailableDataStores(serviceRegistry, DataAccessFactory.class);
        Iterator<DataStoreFactorySpi> availableDataStores = DataStoreFinder.getAvailableDataStores();
        while (availableDataStores.hasNext()) {
            availableDS.add((DataAccessFactory)availableDataStores.next());
        }
        return availableDS.iterator();
    }

    static synchronized <T extends DataAccessFactory> Set<T> getAvailableDataStores(FactoryRegistry registry, Class<T> targetClass) {
        HashSet<DataAccessFactory> availableDS = new HashSet<DataAccessFactory>(5);
        Iterator it = registry.getServiceProviders(targetClass, null, null);
        while (it.hasNext()) {
            DataAccessFactory dsFactory = (DataAccessFactory)it.next();
            if (!dsFactory.isAvailable()) continue;
            availableDS.add(dsFactory);
        }
        return availableDS;
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(DataAccessFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(DataAccessFactory.class));
        }
        return registry;
    }

    public static synchronized void scanForPlugins() {
        DataStoreFinder.scanForPlugins();
        DataAccessFinder.getServiceRegistry().scanForPlugins();
    }

    public static void reset() {
        FactoryRegistry copy = registry;
        registry = null;
        if (copy != null) {
            copy.deregisterAll();
        }
    }
}

