/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sort;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.sort.FeatureBlockReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MergeSortReader
implements SimpleFeatureReader {
    List<FeatureBlockReader> readers;
    RandomAccessFile raf;
    File file;
    SimpleFeatureType schema;
    Comparator<SimpleFeature> comparator;

    public MergeSortReader(SimpleFeatureType schema, RandomAccessFile raf, File file, List<FeatureBlockReader> readers, Comparator<SimpleFeature> comparator) {
        this.schema = schema;
        this.comparator = comparator;
        this.readers = readers;
        this.raf = raf;
        this.file = file;
    }

    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        SimpleFeature sf;
        if (this.readers.size() == 0) {
            throw new NoSuchElementException();
        }
        int selected = 0;
        for (int i = 1; i < this.readers.size(); ++i) {
            SimpleFeature cf;
            sf = this.readers.get(selected).feature();
            if (this.comparator.compare(sf, cf = this.readers.get(i).feature()) <= 0) continue;
            selected = i;
        }
        FeatureBlockReader reader = this.readers.get(selected);
        sf = reader.feature();
        if (reader.next() == null) {
            this.readers.remove(selected);
        }
        return sf;
    }

    public boolean hasNext() throws IOException {
        return this.readers.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.raf.close();
        }
        finally {
            this.file.delete();
        }
    }
}

