/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredIterator<F extends Feature>
implements Iterator<F> {
    private FeatureCollection<? extends FeatureType, F> collection;
    private Iterator<F> delegate;
    private Filter filter;
    private F next;

    public FilteredIterator(Iterator<F> iterator, Filter filter) {
        this.collection = null;
        this.delegate = iterator;
        this.filter = filter;
    }

    public FilteredIterator(FeatureCollection<? extends FeatureType, F> collection, Filter filter) {
        this.collection = collection;
        this.delegate = collection.iterator();
        this.filter = filter;
        this.next = this.getNext();
    }

    void close() {
        if (this.collection != null) {
            this.collection.close(this.delegate);
        }
        this.collection = null;
        this.delegate = null;
        this.filter = null;
        this.next = null;
    }

    private F getNext() {
        Feature item = null;
        while (this.delegate.hasNext()) {
            item = (Feature)this.delegate.next();
            if (!this.filter.evaluate((Object)item)) continue;
            return (F)item;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public F next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        F current = this.next;
        this.next = this.getNext();
        return current;
    }

    @Override
    public void remove() {
        if (this.delegate == null) {
            throw new IllegalStateException();
        }
        this.delegate.remove();
    }
}

