/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.filter.FallbackFunction;
import org.geotools.filter.FunctionFactory;
import org.geotools.util.logging.Logging;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class FunctionFinder {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    private volatile Map<String, FunctionFactory> functionFactoryCache;

    public FunctionFinder(Hints hints) {
    }

    public Function findFunction(String name) {
        return this.findFunction(name, null);
    }

    public Function findFunction(String name, List parameters) {
        return this.findFunction(name, parameters, null);
    }

    public Function findFunction(String name, List parameters, Literal fallback) {
        Function f = this.findFunctionInternal(name, parameters, fallback);
        if (f == null && name.endsWith("Function")) {
            name = name.substring(0, name.length() - "Function".length());
            f = this.findFunctionInternal(name, parameters, fallback);
        }
        if (f == null && fallback != null) {
            return new FallbackFunction(name, parameters, fallback);
        }
        if (f != null) {
            return f;
        }
        throw new RuntimeException("Unable to find function " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Function findFunctionInternal(String name, List parameters, Literal fallback) {
        if (this.functionFactoryCache == null) {
            FunctionFinder functionFinder = this;
            synchronized (functionFinder) {
                if (this.functionFactoryCache == null) {
                    this.functionFactoryCache = this.lookupFunctions();
                }
            }
        }
        if (this.functionFactoryCache.containsKey(name)) {
            return this.functionFactoryCache.get(name).function(name, parameters, fallback);
        }
        Function f = null;
        for (FunctionFactory ff : CommonFactoryFinder.getFunctionFactories(null)) {
            f = ff.function(name, parameters, fallback);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    private HashMap lookupFunctions() {
        HashMap<String, FunctionFactory> result = new HashMap<String, FunctionFactory>();
        Set functionFactories = CommonFactoryFinder.getFunctionFactories(null);
        for (FunctionFactory ff : functionFactories) {
            for (FunctionName functionName : ff.getFunctionNames()) {
                result.put(functionName.getName(), ff);
            }
        }
        return result;
    }
}

