/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.styling.AbstractSymbolizer;
import org.geotools.styling.Description;
import org.geotools.styling.Displacement;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.Fill;
import org.geotools.styling.FillImpl;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.StrokeImpl;
import org.geotools.styling.StyleVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Symbolizer;
import org.opengis.util.Cloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonSymbolizerImpl
extends AbstractSymbolizer
implements PolygonSymbolizer,
Cloneable {
    private Expression offset;
    private DisplacementImpl disp;
    private Fill fill = new FillImpl();
    private StrokeImpl stroke = new StrokeImpl();

    protected PolygonSymbolizerImpl() {
        this(null, null, null, null, null, null, null, null);
    }

    protected PolygonSymbolizerImpl(Stroke stroke, Fill fill, Displacement disp, Expression offset, Unit<Length> uom, String geom, String name, Description desc) {
        super(name, desc, geom, uom);
        this.stroke = StrokeImpl.cast((org.opengis.style.Stroke)stroke);
        this.fill = fill;
        this.disp = DisplacementImpl.cast((org.opengis.style.Displacement)disp);
        this.offset = offset;
    }

    public Expression getPerpendicularOffset() {
        return this.offset;
    }

    public void setPerpendicularOffset(Expression offset) {
        this.offset = offset;
    }

    public Displacement getDisplacement() {
        return this.disp;
    }

    public void setDisplacement(org.opengis.style.Displacement displacement) {
        this.disp = DisplacementImpl.cast(displacement);
    }

    public Fill getFill() {
        return this.fill;
    }

    public void setFill(org.opengis.style.Fill fill) {
        if (this.fill == fill) {
            return;
        }
        this.fill = FillImpl.cast(fill);
    }

    public StrokeImpl getStroke() {
        return this.stroke;
    }

    public void setStroke(org.opengis.style.Stroke stroke) {
        if (this.stroke == stroke) {
            return;
        }
        this.stroke = StrokeImpl.cast(stroke);
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.PolygonSymbolizer)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((PolygonSymbolizer)this);
    }

    public Object clone() {
        PolygonSymbolizerImpl clone;
        try {
            clone = (PolygonSymbolizerImpl)super.clone();
            if (this.fill != null) {
                clone.fill = (Fill)((Cloneable)this.fill).clone();
            }
            if (this.stroke != null) {
                clone.stroke = (StrokeImpl)this.stroke.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.disp == null ? 0 : this.disp.hashCode());
        result = 31 * result + (this.fill == null ? 0 : this.fill.hashCode());
        result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
        result = 31 * result + (this.stroke == null ? 0 : this.stroke.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PolygonSymbolizerImpl other = (PolygonSymbolizerImpl)obj;
        if (this.disp == null ? other.disp != null : !this.disp.equals(other.disp)) {
            return false;
        }
        if (this.fill == null ? other.fill != null : !this.fill.equals(other.fill)) {
            return false;
        }
        if (this.offset == null ? other.offset != null : !this.offset.equals(other.offset)) {
            return false;
        }
        return !(this.stroke == null ? other.stroke != null : !this.stroke.equals(other.stroke));
    }

    static PolygonSymbolizerImpl cast(Symbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        if (symbolizer instanceof PolygonSymbolizerImpl) {
            return (PolygonSymbolizerImpl)symbolizer;
        }
        if (symbolizer instanceof org.opengis.style.PolygonSymbolizer) {
            org.opengis.style.PolygonSymbolizer polygonSymbolizer = (org.opengis.style.PolygonSymbolizer)symbolizer;
            PolygonSymbolizerImpl copy = new PolygonSymbolizerImpl();
            copy.setStroke((org.opengis.style.Stroke)StrokeImpl.cast(polygonSymbolizer.getStroke()));
            copy.setDescription(polygonSymbolizer.getDescription());
            copy.setDisplacement(polygonSymbolizer.getDisplacement());
            copy.setFill(polygonSymbolizer.getFill());
            copy.setGeometryPropertyName(polygonSymbolizer.getGeometryPropertyName());
            copy.setName(polygonSymbolizer.getName());
            copy.setPerpendicularOffset(polygonSymbolizer.getPerpendicularOffset());
            copy.setUnitOfMeasure((Unit<Length>)polygonSymbolizer.getUnitOfMeasure());
            return copy;
        }
        return null;
    }
}

