/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiLineString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.DataStore;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.EmptyFeatureWriter;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockFactory;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryDataStoreTest
extends DataTestCase {
    MemoryDataStore data;

    public MemoryDataStoreTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.data = new MemoryDataStore();
        this.data.addFeatures(this.roadFeatures);
        this.data.addFeatures(this.riverFeatures);
    }

    protected void tearDown() throws Exception {
        this.data = null;
        super.tearDown();
    }

    public void testEmpty() throws Exception {
        SimpleFeatureType type = DataUtilities.createType((String)"namespace.typename", (String)"name:String,id:0,geom:MultiLineString");
        MemoryDataStore memory = new MemoryDataStore(type);
        FeatureSource source = memory.getFeatureSource("typename");
        MemoryDataStoreTest.assertEquals((int)0, (int)source.getCount(Query.ALL));
    }

    public void testFixture() throws Exception {
        SimpleFeatureType type = DataUtilities.createType((String)"namespace.typename", (String)"name:String,id:0,geom:MultiLineString");
        MemoryDataStoreTest.assertEquals((String)"namespace", (String)"namespace", (String)type.getName().getNamespaceURI());
        MemoryDataStoreTest.assertEquals((String)"typename", (String)"typename", (String)type.getTypeName());
        MemoryDataStoreTest.assertEquals((String)"attributes", (int)3, (int)type.getAttributeCount());
        MemoryDataStoreTest.assertEquals((String)"a1", (String)"name", (String)type.getDescriptor(0).getLocalName());
        MemoryDataStoreTest.assertEquals((String)"a1", String.class, (Object)type.getDescriptor(0).getType().getBinding());
        MemoryDataStoreTest.assertEquals((String)"a2", (String)"id", (String)type.getDescriptor(1).getLocalName());
        MemoryDataStoreTest.assertEquals((String)"a2", Integer.class, (Object)type.getDescriptor(1).getType().getBinding());
        MemoryDataStoreTest.assertEquals((String)"a3", (String)"geom", (String)type.getDescriptor(2).getLocalName());
        MemoryDataStoreTest.assertEquals((String)"a3", MultiLineString.class, (Object)type.getDescriptor(2).getType().getBinding());
    }

    public void testMemoryDataStore() throws Exception {
        MemoryDataStore store = new MemoryDataStore();
    }

    public void testMemoryDataStoreFeatureCollection() {
        MemoryDataStore store = new MemoryDataStore(DataUtilities.collection((SimpleFeature[])this.roadFeatures));
    }

    public void testMemoryDataStoreFeatureArray() throws IOException {
        MemoryDataStore store = new MemoryDataStore(this.roadFeatures);
    }

    public void testMemoryDataStoreFeatureReader() throws IOException {
        FeatureReader reader = DataUtilities.reader((SimpleFeature[])this.roadFeatures);
        MemoryDataStore store = new MemoryDataStore(reader);
    }

    public void testGetFeatureTypes() {
        Object[] names = this.data.getTypeNames();
        MemoryDataStoreTest.assertEquals((int)2, (int)names.length);
        MemoryDataStoreTest.assertTrue((boolean)this.contains(names, "road"));
        MemoryDataStoreTest.assertTrue((boolean)this.contains(names, "river"));
    }

    boolean contains(Object[] array, Object expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(expected)) continue;
            return true;
        }
        return false;
    }

    boolean containsLax(SimpleFeature[] array, SimpleFeature expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        SimpleFeatureType type = expected.getFeatureType();
        for (int i = 0; i < array.length; ++i) {
            if (!this.match(array[i], expected)) continue;
            return true;
        }
        return false;
    }

    boolean match(SimpleFeature expected, SimpleFeature actual) {
        SimpleFeatureType type = expected.getFeatureType();
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            Geometry eg;
            Geometry ag;
            Object av = actual.getAttribute(i);
            Object ev = expected.getAttribute(i);
            if (av == null && ev != null) {
                return false;
            }
            if (ev == null && av != null) {
                return false;
            }
            if (!(av instanceof Geometry && ev instanceof Geometry ? !(ag = (Geometry)av).equals(eg = (Geometry)ev) : !av.equals(ev))) continue;
            return false;
        }
        return true;
    }

    public void testGetSchema() throws IOException {
        MemoryDataStoreTest.assertSame((Object)this.roadType, (Object)this.data.getSchema("road"));
        MemoryDataStoreTest.assertSame((Object)this.riverType, (Object)this.data.getSchema("river"));
    }

    void assertCovers(String msg, FeatureCollection<SimpleFeatureType, SimpleFeature> c1, FeatureCollection<SimpleFeatureType, SimpleFeature> c2) {
        if (c1 == c2) {
            return;
        }
        MemoryDataStoreTest.assertNotNull((String)msg, c1);
        MemoryDataStoreTest.assertNotNull((String)msg, c2);
        MemoryDataStoreTest.assertEquals((String)(msg + " size"), (int)c1.size(), (int)c2.size());
        FeatureIterator i = c1.features();
        while (i.hasNext()) {
            SimpleFeature f = (SimpleFeature)i.next();
            MemoryDataStoreTest.assertTrue((String)(msg + " " + f.getID()), (boolean)c2.contains((Object)f));
        }
    }

    public void testGetFeatureReader() throws IOException, IllegalAttributeException {
        FeatureReader reader = this.data.getFeatureReader("road");
        this.assertCovered(this.roadFeatures, (FeatureReader<SimpleFeatureType, SimpleFeature>)reader);
        MemoryDataStoreTest.assertEquals((boolean)false, (boolean)reader.hasNext());
    }

    public void testGetFeatureReaderMutability() throws IOException, IllegalAttributeException {
        SimpleFeature feature;
        FeatureReader reader = this.data.getFeatureReader("road");
        while (reader.hasNext()) {
            feature = (SimpleFeature)reader.next();
            feature.setAttribute("name", null);
        }
        reader.close();
        reader = this.data.getFeatureReader("road");
        while (reader.hasNext()) {
            feature = (SimpleFeature)reader.next();
            MemoryDataStoreTest.assertNotNull((Object)feature.getAttribute("name"));
        }
        reader.close();
        try {
            reader.next();
            MemoryDataStoreTest.fail((String)"next should fail with an IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testGetFeatureReaderConcurancy() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureReader reader1 = this.data.getFeatureReader("road");
        FeatureReader reader2 = this.data.getFeatureReader("road");
        FeatureReader reader3 = this.data.getFeatureReader("river");
        while (reader1.hasNext() || reader2.hasNext() || reader3.hasNext()) {
            MemoryDataStoreTest.assertTrue((boolean)this.contains(this.roadFeatures, reader1.next()));
            MemoryDataStoreTest.assertTrue((boolean)this.contains(this.roadFeatures, reader2.next()));
            if (!reader3.hasNext()) continue;
            MemoryDataStoreTest.assertTrue((boolean)this.contains(this.riverFeatures, reader3.next()));
        }
        try {
            reader1.next();
            MemoryDataStoreTest.fail((String)"next should fail with an IOException");
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            reader2.next();
            MemoryDataStoreTest.fail((String)"next should fail with an IOException");
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            reader3.next();
            MemoryDataStoreTest.fail((String)"next should fail with an IOException");
        }
        catch (IOException expected) {
            // empty catch block
        }
        reader1.close();
        reader2.close();
        reader3.close();
    }

    public void testGetFeatureReaderFilterAutoCommit() throws NoSuchElementException, IOException, IllegalAttributeException {
        SimpleFeatureType type = this.data.getSchema("road");
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertFalse((boolean)(reader instanceof FilteringFeatureReader));
        MemoryDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        MemoryDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)Filter.EXCLUDE), Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertTrue((boolean)(reader instanceof EmptyFeatureReader));
        MemoryDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        MemoryDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", this.rd1Filter), Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertTrue((boolean)(reader instanceof FilteringFeatureReader));
        MemoryDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        MemoryDataStoreTest.assertEquals((int)1, (int)this.count(reader));
    }

    public void testGetFeatureReaderFilterTransaction() throws NoSuchElementException, IOException, IllegalAttributeException {
        DefaultTransaction t = new DefaultTransaction();
        SimpleFeatureType type = this.data.getSchema("road");
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)Filter.EXCLUDE), (Transaction)t);
        MemoryDataStoreTest.assertTrue((boolean)(reader instanceof EmptyFeatureReader));
        MemoryDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        MemoryDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), (Transaction)t);
        MemoryDataStoreTest.assertTrue((boolean)(reader instanceof DiffFeatureReader));
        MemoryDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        MemoryDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", this.rd1Filter), (Transaction)t);
        MemoryDataStoreTest.assertEquals((Object)type, (Object)reader.getFeatureType());
        MemoryDataStoreTest.assertEquals((int)1, (int)this.count(reader));
        TransactionStateDiff state = (TransactionStateDiff)t.getState((Object)this.data);
        FeatureWriter writer = state.writer("road", (Filter)Filter.INCLUDE);
        while (writer.hasNext()) {
            SimpleFeature feature = (SimpleFeature)writer.next();
            if (!feature.getID().equals("road.rd1")) continue;
            writer.remove();
        }
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)Filter.EXCLUDE), (Transaction)t);
        MemoryDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), (Transaction)t);
        MemoryDataStoreTest.assertEquals((int)(this.roadFeatures.length - 1), (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", this.rd1Filter), (Transaction)t);
        MemoryDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        t.rollback();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)Filter.EXCLUDE), (Transaction)t);
        MemoryDataStoreTest.assertEquals((int)0, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), (Transaction)t);
        MemoryDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", this.rd1Filter), (Transaction)t);
        MemoryDataStoreTest.assertEquals((int)1, (int)this.count(reader));
    }

    public void testOrderPreservationRoad() throws Exception {
        this.assertOrderSame(this.roadFeatures);
    }

    public void testOrderPreservationRiver() throws Exception {
        this.assertOrderSame(this.riverFeatures);
    }

    public void testOrderPreservationMemFetures() throws Exception {
        SimpleFeature[] dynFeatures = new SimpleFeature[]{SimpleFeatureBuilder.build((SimpleFeatureType)this.roadType, (Object[])new Object[]{new Integer(1), this.line(new int[]{1, 1, 2, 2, 4, 2, 5, 1}), "r1"}, null), SimpleFeatureBuilder.build((SimpleFeatureType)this.roadType, (Object[])new Object[]{new Integer(2), this.line(new int[]{3, 0, 3, 2, 3, 3, 3, 4}), "r2"}, null), SimpleFeatureBuilder.build((SimpleFeatureType)this.roadType, (Object[])new Object[]{new Integer(3), this.line(new int[]{3, 2, 4, 2, 5, 3}), "r3"}, null)};
        this.assertOrderSame(dynFeatures);
    }

    void assertOrderSame(SimpleFeature[] features) throws Exception {
        FeatureReader reader = DataUtilities.reader((SimpleFeature[])features);
        MemoryDataStore store1 = new MemoryDataStore(reader);
        this.assertReaderOrderSame(features, (DataStore)store1);
        MemoryDataStore store2 = new MemoryDataStore(features);
        this.assertReaderOrderSame(features, (DataStore)store2);
    }

    private void assertReaderOrderSame(SimpleFeature[] features, DataStore store) throws IOException, IllegalAttributeException {
        FeatureReader r1 = store.getFeatureReader((Query)new DefaultQuery(features[0].getFeatureType().getTypeName()), Transaction.AUTO_COMMIT);
        FeatureReader r2 = DataUtilities.reader((SimpleFeature[])features);
        while (r1.hasNext() && r2.hasNext()) {
            SimpleFeature f1 = (SimpleFeature)r1.next();
            SimpleFeature f2 = (SimpleFeature)r2.next();
            MemoryDataStoreTest.assertEquals((Object)f1, (Object)f2);
        }
        MemoryDataStoreTest.assertEquals((boolean)r1.hasNext(), (boolean)r2.hasNext());
        r1.close();
        r2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertCovered(SimpleFeature[] features, FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                MemoryDataStoreTest.assertTrue((boolean)this.contains(features, reader.next()));
                ++count;
            }
        }
        finally {
            reader.close();
        }
        MemoryDataStoreTest.assertEquals((int)features.length, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean covers(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.contains(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean covers(FeatureIterator<SimpleFeature> reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.contains(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean coversLax(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.containsLax(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean coversLax(FeatureIterator<SimpleFeature> reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.containsLax(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                System.out.println(count + " feature:" + feature);
                ++count;
            }
        }
        finally {
            reader.close();
        }
    }

    void dump(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            System.out.println(i + " feature:" + array[i]);
        }
    }

    public void testGetFeatureWriter() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureWriter writer = this.data.getFeatureWriter("road", Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(writer));
        try {
            writer.hasNext();
            MemoryDataStoreTest.fail((String)"Should not be able to use a closed writer");
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            writer.next();
            MemoryDataStoreTest.fail((String)"Should not be able to use a closed writer");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testGetFeatureWriterRemove() throws IOException, IllegalAttributeException {
        FeatureWriter writer = this.data.getFeatureWriter("road", Transaction.AUTO_COMMIT);
        while (writer.hasNext()) {
            SimpleFeature feature = (SimpleFeature)writer.next();
            if (!feature.getID().equals("road.rd1")) continue;
            writer.remove();
        }
        MemoryDataStoreTest.assertEquals((int)(this.roadFeatures.length - 1), (int)this.data.features("road").size());
    }

    public void testGetFeaturesWriterAdd() throws IOException, IllegalAttributeException {
        SimpleFeature feature;
        FeatureWriter writer = this.data.getFeatureWriter("road", Transaction.AUTO_COMMIT);
        while (writer.hasNext()) {
            feature = (SimpleFeature)writer.next();
        }
        MemoryDataStoreTest.assertFalse((boolean)writer.hasNext());
        feature = (SimpleFeature)writer.next();
        feature.setAttributes(this.newRoad.getAttributes());
        writer.write();
        MemoryDataStoreTest.assertFalse((boolean)writer.hasNext());
        MemoryDataStoreTest.assertEquals((int)(this.roadFeatures.length + 1), (int)this.data.features("road").size());
    }

    public void testGetFeaturesWriterModify() throws IOException, IllegalAttributeException {
        SimpleFeature feature;
        FeatureWriter writer = this.data.getFeatureWriter("road", Transaction.AUTO_COMMIT);
        while (writer.hasNext()) {
            feature = (SimpleFeature)writer.next();
            if (!feature.getID().equals("road.rd1")) continue;
            feature.setAttribute("name", (Object)"changed");
            writer.write();
        }
        feature = (SimpleFeature)this.data.features("road").get("road.rd1");
        MemoryDataStoreTest.assertEquals((Object)"changed", (Object)feature.getAttribute("name"));
    }

    public void testGetFeatureWriterTypeNameTransaction() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureWriter writer = this.data.getFeatureWriter("road", Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(writer));
        writer.close();
    }

    public void testGetFeatureWriterAppendTypeNameTransaction() throws Exception {
        FeatureWriter writer = this.data.getFeatureWriterAppend("road", Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertEquals((int)0, (int)this.count(writer));
        writer.close();
    }

    public void testGetFeatureWriterFilter() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureWriter writer = this.data.getFeatureWriter("road", (Filter)Filter.EXCLUDE, Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertTrue((boolean)(writer instanceof EmptyFeatureWriter));
        MemoryDataStoreTest.assertEquals((int)0, (int)this.count(writer));
        writer = this.data.getFeatureWriter("road", (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertFalse((boolean)(writer instanceof FilteringFeatureWriter));
        MemoryDataStoreTest.assertEquals((int)this.roadFeatures.length, (int)this.count(writer));
        writer = this.data.getFeatureWriter("road", this.rd1Filter, Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertTrue((boolean)(writer instanceof FilteringFeatureWriter));
        MemoryDataStoreTest.assertEquals((int)1, (int)this.count(writer));
    }

    public void testGetFeatureWriterTransaction() throws Exception {
        SimpleFeature feature;
        int i;
        DefaultTransaction t1 = new DefaultTransaction();
        DefaultTransaction t2 = new DefaultTransaction();
        FeatureWriter writer1 = this.data.getFeatureWriter("road", this.rd1Filter, (Transaction)t1);
        FeatureWriter writer2 = this.data.getFeatureWriterAppend("road", (Transaction)t2);
        SimpleFeatureType road = this.data.getSchema("road");
        SimpleFeature[] ORIGIONAL = this.roadFeatures;
        SimpleFeature[] REMOVE = new SimpleFeature[ORIGIONAL.length - 1];
        SimpleFeature[] ADD = new SimpleFeature[ORIGIONAL.length + 1];
        SimpleFeature[] FINAL = new SimpleFeature[ORIGIONAL.length];
        int index = 0;
        for (i = 0; i < ORIGIONAL.length; ++i) {
            feature = ORIGIONAL[i];
            if (feature.getID().equals("road.rd1")) continue;
            REMOVE[index++] = feature;
        }
        for (i = 0; i < ORIGIONAL.length; ++i) {
            ADD[i] = ORIGIONAL[i];
        }
        ADD[i] = this.newRoad;
        for (i = 0; i < REMOVE.length; ++i) {
            FINAL[i] = REMOVE[i];
        }
        FINAL[i] = this.newRoad;
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGIONAL));
        while (writer1.hasNext()) {
            feature = (SimpleFeature)writer1.next();
            MemoryDataStoreTest.assertEquals((String)"road.rd1", (String)feature.getID());
            writer1.remove();
        }
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGIONAL));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), (Transaction)t1);
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
        writer1.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGIONAL));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), (Transaction)t1);
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
        feature = (SimpleFeature)writer2.next();
        feature.setAttributes(this.newRoad.getAttributes());
        writer2.write();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGIONAL));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), (Transaction)t2);
        MemoryDataStoreTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ADD));
        writer2.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGIONAL));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), (Transaction)t2);
        MemoryDataStoreTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ADD));
        t1.commit();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), (Transaction)t1);
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), (Transaction)t2);
        MemoryDataStoreTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
        t2.commit();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), Transaction.AUTO_COMMIT);
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), Transaction.AUTO_COMMIT);
        MemoryDataStoreTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), (Transaction)t1);
        MemoryDataStoreTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road"), (Transaction)t2);
        MemoryDataStoreTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
    }

    public void testModifyInTransactionFidFilter() throws Exception {
        DefaultTransaction t1 = new DefaultTransaction();
        GeometryFactory fac = new GeometryFactory();
        FeatureWriter writer1 = this.data.getFeatureWriter("road", this.rd1Filter, (Transaction)t1);
        ((SimpleFeature)writer1.next()).setDefaultGeometry((Object)fac.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 1.0)}));
        writer1.write();
        writer1.close();
        FeatureReader reader = this.data.getFeatureReader((Query)new DefaultQuery("road", this.rd1Filter), (Transaction)t1);
        Geometry geom1 = (Geometry)((SimpleFeature)reader.next()).getDefaultGeometry();
        reader.close();
        MemoryDataStoreTest.assertEquals((Object)new Coordinate(0.0, 0.0), (Object)geom1.getCoordinates()[0]);
        MemoryDataStoreTest.assertEquals((Object)new Coordinate(0.0, 1.0), (Object)geom1.getCoordinates()[1]);
        writer1 = this.data.getFeatureWriter("road", this.rd1Filter, (Transaction)t1);
        ((SimpleFeature)writer1.next()).setDefaultGeometry((Object)fac.createLineString(new Coordinate[]{new Coordinate(10.0, 0.0), new Coordinate(10.0, 1.0)}));
        writer1.write();
        writer1.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", this.rd1Filter), (Transaction)t1);
        geom1 = (Geometry)((SimpleFeature)reader.next()).getDefaultGeometry();
        reader.close();
        MemoryDataStoreTest.assertEquals((Object)new Coordinate(10.0, 0.0), (Object)geom1.getCoordinates()[0]);
        MemoryDataStoreTest.assertEquals((Object)new Coordinate(10.0, 1.0), (Object)geom1.getCoordinates()[1]);
        FeatureWriter writer = this.data.getFeatureWriterAppend("road", (Transaction)t1);
        SimpleFeature feature = (SimpleFeature)writer.next();
        feature.setDefaultGeometry((Object)fac.createLineString(new Coordinate[]{new Coordinate(20.0, 0.0), new Coordinate(20.0, 1.0)}));
        writer.write();
        writer.close();
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
        Id filter = filterFactory.id(Collections.singleton(filterFactory.featureId(feature.getID())));
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)filter), (Transaction)t1);
        geom1 = (Geometry)((SimpleFeature)reader.next()).getDefaultGeometry();
        reader.close();
        MemoryDataStoreTest.assertEquals((Object)new Coordinate(20.0, 0.0), (Object)geom1.getCoordinates()[0]);
        MemoryDataStoreTest.assertEquals((Object)new Coordinate(20.0, 1.0), (Object)geom1.getCoordinates()[1]);
        writer1 = this.data.getFeatureWriter("road", (Filter)filter, (Transaction)t1);
        ((SimpleFeature)writer1.next()).setDefaultGeometry((Object)fac.createLineString(new Coordinate[]{new Coordinate(30.0, 0.0), new Coordinate(30.0, 1.0)}));
        writer1.write();
        writer1.close();
        reader = this.data.getFeatureReader((Query)new DefaultQuery("road", (Filter)filter), (Transaction)t1);
        geom1 = (Geometry)((SimpleFeature)reader.next()).getDefaultGeometry();
        reader.close();
        MemoryDataStoreTest.assertEquals((Object)new Coordinate(30.0, 0.0), (Object)geom1.getCoordinates()[0]);
        MemoryDataStoreTest.assertEquals((Object)new Coordinate(30.0, 1.0), (Object)geom1.getCoordinates()[1]);
    }

    public void testGetFeatureSourceRoad() throws IOException {
        FeatureSource road = this.data.getFeatureSource("road");
        MemoryDataStoreTest.assertSame((Object)this.roadType, (Object)road.getSchema());
        MemoryDataStoreTest.assertSame((Object)this.data, (Object)road.getDataStore());
        MemoryDataStoreTest.assertEquals((int)3, (int)road.getCount(Query.ALL));
        MemoryDataStoreTest.assertEquals((Object)new ReferencedEnvelope(1.0, 5.0, 0.0, 4.0, null), (Object)road.getBounds(Query.ALL));
        FeatureCollection all = road.getFeatures();
        MemoryDataStoreTest.assertEquals((int)3, (int)all.size());
        MemoryDataStoreTest.assertEquals((Object)this.roadBounds, (Object)all.getBounds());
        FeatureCollection expected = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        this.assertCovers("all", (FeatureCollection<SimpleFeatureType, SimpleFeature>)expected, (FeatureCollection<SimpleFeatureType, SimpleFeature>)all);
        MemoryDataStoreTest.assertEquals((Object)this.roadBounds, (Object)all.getBounds());
        FeatureCollection some = road.getFeatures(this.rd12Filter);
        MemoryDataStoreTest.assertEquals((int)2, (int)some.size());
        MemoryDataStoreTest.assertEquals((Object)this.rd12Bounds, (Object)some.getBounds());
        MemoryDataStoreTest.assertEquals((Object)some.getSchema(), (Object)road.getSchema());
        DefaultQuery query = new DefaultQuery("road", this.rd12Filter, new String[]{"name"});
        FeatureCollection half = road.getFeatures((Query)query);
        MemoryDataStoreTest.assertEquals((int)2, (int)half.size());
        MemoryDataStoreTest.assertEquals((int)1, (int)((SimpleFeatureType)half.getSchema()).getAttributeCount());
        FeatureIterator reader = half.features();
        SimpleFeatureType type = (SimpleFeatureType)half.getSchema();
        reader.close();
        SimpleFeatureType actual = (SimpleFeatureType)half.getSchema();
        MemoryDataStoreTest.assertEquals((String)type.getTypeName(), (String)actual.getTypeName());
        MemoryDataStoreTest.assertEquals((Object)type.getName(), (Object)actual.getName());
        MemoryDataStoreTest.assertEquals((int)type.getAttributeCount(), (int)actual.getAttributeCount());
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            MemoryDataStoreTest.assertEquals((Object)type.getDescriptor(i), (Object)actual.getDescriptor(i));
        }
        MemoryDataStoreTest.assertNull((Object)type.getGeometryDescriptor());
        MemoryDataStoreTest.assertEquals((Object)type.getGeometryDescriptor(), (Object)actual.getGeometryDescriptor());
        MemoryDataStoreTest.assertEquals((Object)type, (Object)actual);
        ReferencedEnvelope b = half.getBounds();
        MemoryDataStoreTest.assertEquals((Object)new Envelope(1.0, 5.0, 0.0, 4.0), (Object)b);
    }

    public void testGetFeatureSourceRiver() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureSource river = this.data.getFeatureSource("river");
        MemoryDataStoreTest.assertSame((Object)this.riverType, (Object)river.getSchema());
        MemoryDataStoreTest.assertSame((Object)this.data, (Object)river.getDataStore());
        FeatureCollection all = river.getFeatures();
        MemoryDataStoreTest.assertEquals((int)2, (int)all.size());
        MemoryDataStoreTest.assertEquals((Object)this.riverBounds, (Object)all.getBounds());
        MemoryDataStoreTest.assertTrue((String)"rivers", (boolean)this.covers((FeatureIterator<SimpleFeature>)all.features(), this.riverFeatures));
        FeatureCollection expected = DataUtilities.collection((SimpleFeature[])this.riverFeatures);
        this.assertCovers("all", (FeatureCollection<SimpleFeatureType, SimpleFeature>)expected, (FeatureCollection<SimpleFeatureType, SimpleFeature>)all);
        MemoryDataStoreTest.assertEquals((Object)this.riverBounds, (Object)all.getBounds());
    }

    public void testGetFeatureStoreModifyFeatures1() throws IOException {
        FeatureStore road = (FeatureStore)this.data.getFeatureSource("road");
        AttributeDescriptor name = this.roadType.getDescriptor("name");
        road.modifyFeatures(name, (Object)"changed", this.rd1Filter);
        FeatureCollection results = road.getFeatures(this.rd1Filter);
        MemoryDataStoreTest.assertEquals((Object)"changed", (Object)((SimpleFeature)results.features().next()).getAttribute("name"));
    }

    public void testGetFeatureStoreModifyFeatures2() throws IOException {
        FeatureStore road = (FeatureStore)this.data.getFeatureSource("road");
        AttributeDescriptor name = this.roadType.getDescriptor("name");
        road.modifyFeatures(new AttributeDescriptor[]{name}, new Object[]{"changed"}, this.rd1Filter);
        FeatureCollection results = road.getFeatures(this.rd1Filter);
        MemoryDataStoreTest.assertEquals((Object)"changed", (Object)((SimpleFeature)results.features().next()).getAttribute("name"));
    }

    public void testGetFeatureStoreRemoveFeatures() throws IOException {
        FeatureStore road = (FeatureStore)this.data.getFeatureSource("road");
        road.removeFeatures(this.rd1Filter);
        MemoryDataStoreTest.assertEquals((int)0, (int)road.getFeatures(this.rd1Filter).size());
        MemoryDataStoreTest.assertEquals((int)(this.roadFeatures.length - 1), (int)road.getFeatures().size());
    }

    public void testGetFeatureStoreAddFeatures() throws IOException {
        FeatureReader reader = DataUtilities.reader((SimpleFeature[])new SimpleFeature[]{this.newRoad});
        FeatureStore road = (FeatureStore)this.data.getFeatureSource("road");
        road.addFeatures(DataUtilities.collection((FeatureReader)reader));
        MemoryDataStoreTest.assertEquals((int)(this.roadFeatures.length + 1), (int)road.getFeatures().size());
    }

    public void testGetFeatureStoreSetFeatures() throws IOException {
        FeatureReader reader = DataUtilities.reader((SimpleFeature[])new SimpleFeature[]{this.newRoad});
        FeatureStore road = (FeatureStore)this.data.getFeatureSource("road");
        road.setFeatures(reader);
        MemoryDataStoreTest.assertEquals((int)1, (int)road.getFeatures().size());
    }

    public void testGetFeatureStoreTransactionSupport() throws Exception {
        int i;
        DefaultTransaction t1 = new DefaultTransaction();
        DefaultTransaction t2 = new DefaultTransaction();
        FeatureStore road = (FeatureStore)this.data.getFeatureSource("road");
        FeatureStore road1 = (FeatureStore)this.data.getFeatureSource("road");
        FeatureStore road2 = (FeatureStore)this.data.getFeatureSource("road");
        road1.setTransaction((Transaction)t1);
        road2.setTransaction((Transaction)t2);
        SimpleFeature[] ORIGIONAL = this.roadFeatures;
        SimpleFeature[] REMOVE = new SimpleFeature[ORIGIONAL.length - 1];
        SimpleFeature[] ADD = new SimpleFeature[ORIGIONAL.length + 1];
        SimpleFeature[] FINAL = new SimpleFeature[ORIGIONAL.length];
        int index = 0;
        for (i = 0; i < ORIGIONAL.length; ++i) {
            SimpleFeature feature = ORIGIONAL[i];
            if (feature.getID().equals("road.rd1")) continue;
            REMOVE[index++] = feature;
        }
        for (i = 0; i < ORIGIONAL.length; ++i) {
            ADD[i] = ORIGIONAL[i];
        }
        ADD[i] = this.newRoad;
        for (i = 0; i < REMOVE.length; ++i) {
            FINAL[i] = REMOVE[i];
        }
        FINAL[i] = this.newRoad;
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureIterator<SimpleFeature>)road.getFeatures().features(), ORIGIONAL));
        road1.removeFeatures(this.rd1Filter);
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureIterator<SimpleFeature>)road.getFeatures().features(), ORIGIONAL));
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureIterator<SimpleFeature>)road1.getFeatures().features(), REMOVE));
        FeatureReader reader = DataUtilities.reader((SimpleFeature[])new SimpleFeature[]{this.newRoad});
        road2.addFeatures(DataUtilities.collection((FeatureReader)reader));
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureIterator<SimpleFeature>)road.getFeatures().features(), ORIGIONAL));
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureIterator<SimpleFeature>)road1.getFeatures().features(), REMOVE));
        MemoryDataStoreTest.assertTrue((boolean)this.coversLax((FeatureIterator<SimpleFeature>)road2.getFeatures().features(), ADD));
        t1.commit();
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureIterator<SimpleFeature>)road.getFeatures().features(), REMOVE));
        MemoryDataStoreTest.assertTrue((boolean)this.covers((FeatureIterator<SimpleFeature>)road1.getFeatures().features(), REMOVE));
        MemoryDataStoreTest.assertTrue((boolean)this.coversLax((FeatureIterator<SimpleFeature>)road2.getFeatures().features(), FINAL));
        t2.commit();
        MemoryDataStoreTest.assertTrue((boolean)this.coversLax((FeatureIterator<SimpleFeature>)road.getFeatures().features(), FINAL));
        MemoryDataStoreTest.assertTrue((boolean)this.coversLax((FeatureIterator<SimpleFeature>)road1.getFeatures().features(), FINAL));
        MemoryDataStoreTest.assertTrue((boolean)this.coversLax((FeatureIterator<SimpleFeature>)road2.getFeatures().features(), FINAL));
    }

    boolean isLocked(String typeName, String fid) {
        InProcessLockingManager lockingManager = (InProcessLockingManager)this.data.getLockingManager();
        return lockingManager.isLocked(typeName, fid);
    }

    public void testFeatureEvents() throws Exception {
        FeatureStore store1 = (FeatureStore)this.data.getFeatureSource(this.roadFeatures[0].getFeatureType().getTypeName());
        FeatureStore store2 = (FeatureStore)this.data.getFeatureSource(this.roadFeatures[0].getFeatureType().getTypeName());
        store1.setTransaction((Transaction)new DefaultTransaction());
        class Listener
        implements FeatureListener {
            String name;
            List events = new ArrayList();

            public Listener(String name) {
                this.name = name;
            }

            public void changed(FeatureEvent featureEvent) {
                this.events.add(featureEvent);
            }

            FeatureEvent getEvent(int i) {
                return (FeatureEvent)this.events.get(i);
            }
        }
        Listener listener1 = new Listener("one");
        Listener listener2 = new Listener("two");
        store1.addFeatureListener((FeatureListener)listener1);
        store2.addFeatureListener((FeatureListener)listener2);
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        SimpleFeature feature = this.roadFeatures[0];
        store1.removeFeatures((Filter)factory.id(Collections.singleton(factory.featureId(feature.getID()))));
        MemoryDataStoreTest.assertEquals((int)1, (int)listener1.events.size());
        MemoryDataStoreTest.assertEquals((int)0, (int)listener2.events.size());
        FeatureEvent event = listener1.getEvent(0);
        MemoryDataStoreTest.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        MemoryDataStoreTest.assertEquals((int)-1, (int)event.getEventType());
        listener1.events.clear();
        listener2.events.clear();
        store1.getTransaction().commit();
        MemoryDataStoreTest.assertEquals((int)0, (int)listener1.events.size());
        MemoryDataStoreTest.assertEquals((int)3, (int)listener2.events.size());
        event = listener2.getEvent(0);
        MemoryDataStoreTest.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        MemoryDataStoreTest.assertEquals((int)-1, (int)event.getEventType());
        listener1.events.clear();
        listener2.events.clear();
        store1.addFeatures(DataUtilities.collection((SimpleFeature)feature));
        MemoryDataStoreTest.assertEquals((int)1, (int)listener1.events.size());
        event = listener1.getEvent(0);
        MemoryDataStoreTest.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        MemoryDataStoreTest.assertEquals((int)1, (int)event.getEventType());
        MemoryDataStoreTest.assertEquals((int)0, (int)listener2.events.size());
        listener1.events.clear();
        listener2.events.clear();
        store1.getTransaction().rollback();
        MemoryDataStoreTest.assertEquals((int)1, (int)listener1.events.size());
        event = listener1.getEvent(0);
        MemoryDataStoreTest.assertNull((Object)event.getBounds());
        MemoryDataStoreTest.assertEquals((int)0, (int)event.getEventType());
        MemoryDataStoreTest.assertEquals((int)0, (int)listener2.events.size());
        listener1.events.clear();
        listener2.events.clear();
        store2.addFeatures(DataUtilities.collection((SimpleFeature)feature));
        MemoryDataStoreTest.assertEquals((int)1, (int)listener1.events.size());
        event = listener1.getEvent(0);
        MemoryDataStoreTest.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        MemoryDataStoreTest.assertEquals((int)1, (int)event.getEventType());
        MemoryDataStoreTest.assertEquals((int)0, (int)listener2.events.size());
    }

    public void testLockFeatures() throws IOException {
        FeatureLock lock = FeatureLockFactory.generate((String)"test", (long)3600L);
        FeatureLocking road = (FeatureLocking)this.data.getFeatureSource("road");
        road.setFeatureLock(lock);
        MemoryDataStoreTest.assertFalse((boolean)this.isLocked("road", "road.rd1"));
        road.lockFeatures();
        MemoryDataStoreTest.assertTrue((boolean)this.isLocked("road", "road.rd1"));
    }

    public void testUnLockFeatures() throws IOException {
        FeatureLock lock = FeatureLockFactory.generate((String)"test", (long)3600L);
        FeatureLocking road = (FeatureLocking)this.data.getFeatureSource("road");
        road.setFeatureLock(lock);
        road.lockFeatures();
        try {
            road.unLockFeatures();
            MemoryDataStoreTest.fail((String)"unlock should fail due on AUTO_COMMIT");
        }
        catch (IOException expected) {
            // empty catch block
        }
        DefaultTransaction t = new DefaultTransaction();
        road.setTransaction((Transaction)t);
        try {
            road.unLockFeatures();
            MemoryDataStoreTest.fail((String)"unlock should fail due lack of authorization");
        }
        catch (IOException expected) {
            // empty catch block
        }
        t.addAuthorization(lock.getAuthorization());
        road.unLockFeatures();
    }

    public void testLockFeatureInteraction() throws IOException {
        FeatureLock lockA = FeatureLockFactory.generate((String)"LockA", (long)3600L);
        FeatureLock lockB = FeatureLockFactory.generate((String)"LockB", (long)3600L);
        DefaultTransaction t1 = new DefaultTransaction();
        DefaultTransaction t2 = new DefaultTransaction();
        FeatureLocking road1 = (FeatureLocking)this.data.getFeatureSource("road");
        FeatureLocking road2 = (FeatureLocking)this.data.getFeatureSource("road");
        road1.setTransaction((Transaction)t1);
        road2.setTransaction((Transaction)t2);
        road1.setFeatureLock(lockA);
        road2.setFeatureLock(lockB);
        MemoryDataStoreTest.assertFalse((boolean)this.isLocked("road", "road.rd1"));
        MemoryDataStoreTest.assertFalse((boolean)this.isLocked("road", "road.rd2"));
        MemoryDataStoreTest.assertFalse((boolean)this.isLocked("road", "road.rd3"));
        road1.lockFeatures(this.rd1Filter);
        MemoryDataStoreTest.assertTrue((boolean)this.isLocked("road", "road.rd1"));
        MemoryDataStoreTest.assertFalse((boolean)this.isLocked("road", "road.rd2"));
        MemoryDataStoreTest.assertFalse((boolean)this.isLocked("road", "road.rd3"));
        road2.lockFeatures(this.rd2Filter);
        MemoryDataStoreTest.assertTrue((boolean)this.isLocked("road", "road.rd1"));
        MemoryDataStoreTest.assertTrue((boolean)this.isLocked("road", "road.rd2"));
        MemoryDataStoreTest.assertFalse((boolean)this.isLocked("road", "road.rd3"));
        try {
            road1.unLockFeatures(this.rd1Filter);
            MemoryDataStoreTest.fail((String)"need authorization");
        }
        catch (IOException expected) {
            // empty catch block
        }
        t1.addAuthorization(lockA.getAuthorization());
        try {
            road1.unLockFeatures(this.rd2Filter);
            MemoryDataStoreTest.fail((String)"need correct authorization");
        }
        catch (IOException expected) {
            // empty catch block
        }
        road1.unLockFeatures(this.rd1Filter);
        MemoryDataStoreTest.assertFalse((boolean)this.isLocked("road", "road.rd1"));
        MemoryDataStoreTest.assertTrue((boolean)this.isLocked("road", "road.rd2"));
        MemoryDataStoreTest.assertFalse((boolean)this.isLocked("road", "road.rd3"));
        t2.addAuthorization(lockB.getAuthorization());
        road2.unLockFeatures(this.rd2Filter);
        MemoryDataStoreTest.assertFalse((boolean)this.isLocked("road", "road.rd1"));
        MemoryDataStoreTest.assertFalse((boolean)this.isLocked("road", "road.rd2"));
        MemoryDataStoreTest.assertFalse((boolean)this.isLocked("road", "road.rd3"));
    }

    public void testGetFeatureLockingExpire() throws Exception {
        FeatureLock lock = FeatureLockFactory.generate((String)"Timed", (long)500L);
        FeatureLocking road = (FeatureLocking)this.data.getFeatureSource("road");
        road.setFeatureLock(lock);
        MemoryDataStoreTest.assertFalse((boolean)this.isLocked("road", "road.rd1"));
        road.lockFeatures(this.rd1Filter);
        MemoryDataStoreTest.assertTrue((boolean)this.isLocked("road", "road.rd1"));
        long then = System.currentTimeMillis();
        do {
            Thread.sleep(15L);
        } while (then > System.currentTimeMillis() - 515L);
        MemoryDataStoreTest.assertFalse((boolean)this.isLocked("road", "road.rd1"));
    }
}

