/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import com.vividsolutions.jts.geom.Point;
import java.util.Collections;
import junit.framework.TestCase;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.feature.type.SchemaImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SimpleTypeBuilderTest
extends TestCase {
    static final String URI = "gopher://localhost/test";
    SimpleFeatureTypeBuilder builder;

    protected void setUp() throws Exception {
        SchemaImpl schema = new SchemaImpl("test");
        FeatureTypeFactoryImpl typeFactory = new FeatureTypeFactoryImpl();
        GeometryType pointType = typeFactory.createGeometryType((Name)new NameImpl("test", "pointType"), Point.class, null, false, false, Collections.EMPTY_LIST, null, null);
        schema.put((Object)new NameImpl("test", "pointType"), (Object)pointType);
        AttributeType intType = typeFactory.createAttributeType((Name)new NameImpl("test", "intType"), Integer.class, false, false, Collections.EMPTY_LIST, null, null);
        schema.put((Object)new NameImpl("test", "intType"), (Object)intType);
        this.builder = new SimpleFeatureTypeBuilder((FeatureTypeFactory)new FeatureTypeFactoryImpl());
        this.builder.setBindings((Schema)schema);
    }

    public void testSanity() {
        this.builder.setName("testName");
        this.builder.setNamespaceURI("testNamespaceURI");
        this.builder.add("point", Point.class);
        this.builder.add("integer", Integer.class);
        SimpleFeatureType type = this.builder.buildFeatureType();
        SimpleTypeBuilderTest.assertNotNull((Object)type);
        SimpleTypeBuilderTest.assertEquals((int)2, (int)type.getAttributeCount());
        AttributeType t = type.getType("point");
        SimpleTypeBuilderTest.assertNotNull((Object)t);
        SimpleTypeBuilderTest.assertEquals(Point.class, (Object)t.getBinding());
        t = type.getType("integer");
        SimpleTypeBuilderTest.assertNotNull((Object)t);
        SimpleTypeBuilderTest.assertEquals(Integer.class, (Object)t.getBinding());
        t = type.getGeometryDescriptor().getType();
        SimpleTypeBuilderTest.assertNotNull((Object)t);
        SimpleTypeBuilderTest.assertEquals(Point.class, (Object)t.getBinding());
    }

    public void testCRS() {
        this.builder.setName("testName");
        this.builder.setNamespaceURI("testNamespaceURI");
        this.builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.builder.crs(null).add("point", Point.class);
        this.builder.add("point2", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.builder.setDefaultGeometry("point");
        SimpleFeatureType type = this.builder.buildFeatureType();
        SimpleTypeBuilderTest.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)type.getCoordinateReferenceSystem());
        SimpleTypeBuilderTest.assertNull((Object)type.getGeometryDescriptor().getType().getCoordinateReferenceSystem());
        SimpleTypeBuilderTest.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)((GeometryType)type.getType("point2")).getCoordinateReferenceSystem());
    }
}

