/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterDOMParser;
import org.geotools.filter.FilterTestSupport;
import org.geotools.test.TestData;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.DWithin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMParserTest
extends FilterTestSupport {
    private Filter filter = null;
    TestSuite suite = null;
    String dataFolder = "";
    boolean setup = false;

    public DOMParserTest(String testName) {
        super(testName);
        LOGGER.finer("running DOMParserTests");
        this.dataFolder = System.getProperty("dataFolder");
        if (this.dataFolder == null) {
            this.dataFolder = System.getProperty("basedir");
            this.dataFolder = "file:////" + this.dataFolder + "/tests/unit/testData";
            LOGGER.fine("data folder is " + this.dataFolder);
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DOMParserTest.suite());
    }

    public void setUp() throws SchemaException, IllegalAttributeException {
        super.setUp();
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.init(testSchema);
        ftb.add("testZeroDouble", Double.class);
        testSchema = ftb.buildFeatureType();
        GeometryFactory geomFac = new GeometryFactory();
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        Object[] attributes = new Object[]{geomFac.createLineString(coords), new Boolean(true), new Character('t'), new Byte("10"), new Short("101"), new Integer(1002), new Long(10003L), new Float(10000.4), new Double(100000.5), "test string data", new Double(0.0)};
        testFeature = SimpleFeatureBuilder.build((SimpleFeatureType)testSchema, (Object[])attributes, null);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(DOMParserTest.class);
        return suite;
    }

    public void test1() throws Exception {
        Filter test = this.parseDocument("test1.xml");
        LOGGER.fine("parsed filter is " + test);
    }

    public void test2() throws Exception {
        Filter test = this.parseDocument("test2.xml");
        LOGGER.fine("parsed filter is " + test);
    }

    public void test3a() throws Exception {
        Filter test = this.parseDocument("test3a.xml");
        LOGGER.fine("parsed filter is " + test);
    }

    public void Xtest3b() throws Exception {
        Filter test = this.parseDocument("test3b.xml");
        LOGGER.fine("parsed filter is " + test);
    }

    public void test4() throws Exception {
        Filter test = this.parseDocument("test4.xml");
        LOGGER.fine("parsed filter is " + test);
    }

    public void test8() throws Exception {
        Filter test = this.parseDocument("test8.xml");
        LOGGER.fine("parsed filter is " + test);
    }

    public void test9() throws Exception {
        Filter test = this.parseDocument("test9.xml");
        LOGGER.fine("parsed filter is " + test);
    }

    public void test11() throws Exception {
        Filter test = this.parseDocument("test11.xml");
        LOGGER.fine("parsed filter is " + test);
    }

    public void test12() throws Exception {
        Filter test = this.parseDocument("test12.xml");
        LOGGER.fine("parsed filter is " + test);
    }

    public void test13() throws Exception {
        Filter test = this.parseDocument("test13.xml");
        LOGGER.fine("parsed filter is " + test);
    }

    public void test14() throws Exception {
        Filter test = this.parseDocument("test14.xml");
        LOGGER.fine("parsed filter is " + test);
    }

    public void test15() throws Exception {
        Filter test = this.parseDocument("test15.xml");
        LOGGER.fine("parsed filter is " + test);
    }

    public void test16() throws Exception {
        Filter test = this.parseDocument("test16.xml");
        LOGGER.fine("parsed filter is " + test);
    }

    public void test27() throws Exception {
        Filter test = this.parseDocument("test27.xml");
        LOGGER.fine("parsed filter is " + test);
    }

    public void testDWithin() throws Exception {
        Filter test = this.parseDocument("dwithin.xml");
        DOMParserTest.assertTrue((boolean)(test instanceof DWithin));
        DWithin dw = (DWithin)test;
        DOMParserTest.assertEquals((String)"the_geom", (String)((PropertyName)dw.getExpression1()).getPropertyName());
        DOMParserTest.assertTrue((boolean)(((Literal)dw.getExpression2()).getValue() instanceof Point));
        DOMParserTest.assertEquals((Object)5000.0, (Object)dw.getDistance());
        DOMParserTest.assertEquals((String)"metre", (String)dw.getDistanceUnits());
        LOGGER.fine("parsed filter is " + test);
    }

    public void testDWithinQualified() throws Exception {
        Filter test = this.parseDocument("dwithin-qualified.xml");
        DOMParserTest.assertTrue((boolean)(test instanceof DWithin));
        DWithin dw = (DWithin)test;
        DOMParserTest.assertEquals((String)"the_geom", (String)((PropertyName)dw.getExpression1()).getPropertyName());
        DOMParserTest.assertTrue((boolean)(((Literal)dw.getExpression2()).getValue() instanceof Point));
        DOMParserTest.assertEquals((Object)5000.0, (Object)dw.getDistance());
        DOMParserTest.assertEquals((String)"metre", (String)dw.getDistanceUnits());
        LOGGER.fine("parsed filter is " + test);
    }

    public void testBeyond() throws Exception {
        Filter test = this.parseDocument("beyond.xml");
        DOMParserTest.assertTrue((boolean)(test instanceof Beyond));
        Beyond bd = (Beyond)test;
        DOMParserTest.assertEquals((String)"the_geom", (String)((PropertyName)bd.getExpression1()).getPropertyName());
        DOMParserTest.assertTrue((boolean)(((Literal)bd.getExpression2()).getValue() instanceof Point));
        DOMParserTest.assertEquals((Object)5000.0, (Object)bd.getDistance());
        DOMParserTest.assertEquals((String)"metre", (String)bd.getDistanceUnits());
        LOGGER.fine("parsed filter is " + test);
    }

    public void test28() throws Exception {
        FidFilter filter = (FidFilter)this.parseDocumentFirst("test28.xml");
        String[] fids = filter.getFids();
        List<String> list = Arrays.asList(fids);
        DOMParserTest.assertEquals((int)3, (int)fids.length);
        DOMParserTest.assertTrue((boolean)list.contains("FID.3"));
        DOMParserTest.assertTrue((boolean)list.contains("FID.2"));
        DOMParserTest.assertTrue((boolean)list.contains("FID.1"));
    }

    public void testNotEqual() throws Exception {
        PropertyIsNotEqualTo filter = (PropertyIsNotEqualTo)this.parseDocumentFirst("testNotEqual.xml");
        DOMParserTest.assertTrue((boolean)filter.isMatchingCase());
    }

    public Filter parseDocument(String uri) throws Exception {
        Filter filter = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(TestData.getResource((Object)((Object)this), (String)uri).toExternalForm());
        LOGGER.fine("parsing " + uri);
        NodeList nodes = dom.getElementsByTagName("Filter");
        if (nodes.getLength() == 0) {
            nodes = dom.getElementsByTagName("ogc:Filter");
        }
        for (int j = 0; j < nodes.getLength(); ++j) {
            Element filterNode = (Element)nodes.item(j);
            NodeList list = filterNode.getChildNodes();
            Node child = null;
            for (int i = 0; i < list.getLength(); ++i) {
                child = list.item(i);
                if (child == null || child.getNodeType() != 1) continue;
                filter = FilterDOMParser.parseFilter((Node)child);
                DOMParserTest.assertNotNull((String)"Null filter returned", (Object)filter);
                LOGGER.finer("filter: " + filter.getClass().toString());
                LOGGER.fine("parsed: " + filter.toString());
                LOGGER.finer("result " + filter.evaluate((Object)testFeature));
            }
        }
        return filter;
    }

    public Filter parseDocumentFirst(String uri) throws Exception {
        Filter filter = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(TestData.getResource((Object)((Object)this), (String)uri).toExternalForm());
        LOGGER.fine("parsing " + uri);
        NodeList nodes = dom.getElementsByTagName("Filter");
        for (int j = 0; j < nodes.getLength(); ++j) {
            Element filterNode = (Element)nodes.item(j);
            NodeList list = filterNode.getChildNodes();
            Node child = null;
            for (int i = 0; i < list.getLength(); ++i) {
                child = list.item(i);
                if (child == null || child.getNodeType() != 1) continue;
                filter = FilterDOMParser.parseFilter((Node)child);
                DOMParserTest.assertNotNull((String)"Null filter returned", (Object)filter);
                LOGGER.finer("filter: " + filter.getClass().toString());
                LOGGER.fine("parsed: " + filter.toString());
                LOGGER.finer("result " + filter.evaluate((Object)testFeature));
                return filter;
            }
        }
        return filter;
    }
}

