/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import junit.framework.TestCase;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.SimpleFeaturePropertyAccessorFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class SimpleFeaturePropertyAccessorTest
extends TestCase {
    SimpleFeatureType type;
    SimpleFeature feature;
    PropertyAccessor accessor = SimpleFeaturePropertyAccessorFactory.ATTRIBUTE_ACCESS;

    protected void setUp() throws Exception {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("test");
        typeBuilder.setNamespaceURI("http://www.geotools.org/test");
        typeBuilder.add("foo", Integer.class);
        typeBuilder.add("bar", Double.class);
        this.type = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(this.type);
        builder.add((Object)new Integer(1));
        builder.add((Object)new Double(2.0));
        this.feature = builder.buildFeature("fid");
        this.accessor = SimpleFeaturePropertyAccessorFactory.ATTRIBUTE_ACCESS;
    }

    public void testCanHandle() {
        SimpleFeaturePropertyAccessorTest.assertTrue((boolean)this.accessor.canHandle((Object)this.feature, "foo", null));
        SimpleFeaturePropertyAccessorTest.assertTrue((boolean)this.accessor.canHandle((Object)this.feature, "bar", null));
        SimpleFeaturePropertyAccessorTest.assertFalse((boolean)this.accessor.canHandle((Object)this.feature, "illegal", null));
    }

    public void testCanHandleType() {
        SimpleFeaturePropertyAccessorTest.assertTrue((boolean)this.accessor.canHandle((Object)this.type, "foo", null));
        SimpleFeaturePropertyAccessorTest.assertTrue((boolean)this.accessor.canHandle((Object)this.type, "bar", null));
        SimpleFeaturePropertyAccessorTest.assertFalse((boolean)this.accessor.canHandle((Object)this.type, "illegal", null));
    }

    public void testGet() {
        SimpleFeaturePropertyAccessorTest.assertEquals((Object)new Integer(1), (Object)this.accessor.get((Object)this.feature, "foo", null));
        SimpleFeaturePropertyAccessorTest.assertEquals((Object)new Double(2.0), (Object)this.accessor.get((Object)this.feature, "bar", null));
        SimpleFeaturePropertyAccessorTest.assertEquals((Object)"fid", (Object)SimpleFeaturePropertyAccessorFactory.FID_ACCESS.get((Object)this.feature, "@id", null));
        SimpleFeaturePropertyAccessorTest.assertEquals((Object)"fid", (Object)SimpleFeaturePropertyAccessorFactory.FID_ACCESS.get((Object)this.feature, "@gml:id", null));
        SimpleFeaturePropertyAccessorTest.assertFalse((boolean)this.accessor.canHandle((Object)this.feature, "illegal", null));
        SimpleFeaturePropertyAccessorTest.assertNull((Object)this.accessor.get((Object)this.feature, "illegal", null));
    }

    public void testGetType() {
        SimpleFeaturePropertyAccessorTest.assertEquals((Object)this.type.getDescriptor("foo"), (Object)this.accessor.get((Object)this.type, "foo", null));
        SimpleFeaturePropertyAccessorTest.assertEquals((Object)this.type.getDescriptor("bar"), (Object)this.accessor.get((Object)this.type, "bar", null));
        SimpleFeaturePropertyAccessorTest.assertNull((Object)this.accessor.get((Object)this.type, "illegal", null));
    }

    public void testSet() {
        try {
            this.accessor.set((Object)this.feature, "foo", (Object)new Integer(2), null);
        }
        catch (IllegalAttributeException e) {
            SimpleFeaturePropertyAccessorTest.fail();
        }
        SimpleFeaturePropertyAccessorTest.assertEquals((Object)new Integer(2), (Object)this.accessor.get((Object)this.feature, "foo", null));
        try {
            this.accessor.set((Object)this.feature, "bar", (Object)new Double(1.0), null);
        }
        catch (IllegalAttributeException e) {
            SimpleFeaturePropertyAccessorTest.fail();
        }
        SimpleFeaturePropertyAccessorTest.assertEquals((Object)new Double(1.0), (Object)this.accessor.get((Object)this.feature, "bar", null));
        try {
            this.accessor.set((Object)this.feature, "@id", (Object)"fid2", null);
            SimpleFeaturePropertyAccessorTest.fail((String)"Should have thrown exception trying to set fid");
        }
        catch (IllegalAttributeException illegalAttributeException) {
            // empty catch block
        }
    }

    public void testSetType() {
        try {
            this.accessor.set((Object)this.type, "foo", new Object(), null);
            SimpleFeaturePropertyAccessorTest.fail((String)"trying to set attribute type should have thrown exception");
        }
        catch (IllegalAttributeException illegalAttributeException) {
            // empty catch block
        }
    }

    public void testGetAnyGeometry() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("test");
        tb.add("g1", Point.class);
        tb.add("g2", Point.class);
        tb.setDefaultGeometry("g1");
        SimpleFeatureType type = tb.buildFeatureType();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(type);
        b.set("g1", null);
        Point p = new GeometryFactory().createPoint(new Coordinate(0.0, 0.0));
        b.set("g2", (Object)p);
        SimpleFeature feature = b.buildFeature(null);
        SimpleFeaturePropertyAccessorTest.assertNull((Object)feature.getDefaultGeometry());
        SimpleFeaturePropertyAccessorTest.assertEquals((Object)p, (Object)SimpleFeaturePropertyAccessorFactory.DEFAULT_GEOMETRY_ACCESS.get((Object)feature, "", Geometry.class));
    }
}

