/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory2;

public class FunctionTestSupport
extends TestCase {
    protected FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection;
    protected FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    protected SimpleFeatureType dataType;
    protected SimpleFeature[] testFeatures;

    public FunctionTestSupport(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.dataType = DataUtilities.createType((String)"classification.test1", (String)"id:0,foo:int,bar:double,geom:Point,group:String");
        int[] iVal = new int[]{4, 90, 20, 43, 29, 61, 8, 12};
        double[] dVal = new double[]{2.5, 80.433, 24.5, 9.75, 18.0, 53.0, 43.2, 16.0};
        this.testFeatures = new SimpleFeature[iVal.length];
        GeometryFactory fac = new GeometryFactory();
        for (int i = 0; i < iVal.length; ++i) {
            this.testFeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)this.dataType, (Object[])new Object[]{new Integer(i + 1), new Integer(iVal[i]), new Double(dVal[i]), fac.createPoint(new Coordinate((double)iVal[i], (double)iVal[i])), "Group" + i % 4}, (String)("classification.t" + (i + 1)));
        }
        MemoryDataStore store = new MemoryDataStore();
        store.createSchema(this.dataType);
        store.addFeatures(this.testFeatures);
        this.featureCollection = store.getFeatureSource("test1").getFeatures();
    }

    public void testEmpty() {
    }
}

