/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.geotools.filter.function.ExplicitClassifier;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.filter.function.UniqueIntervalFunction;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class UniqueIntervalFunctionTest
extends FunctionTestSupport {
    public UniqueIntervalFunctionTest(String testName) {
        super(testName);
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(UniqueIntervalFunctionTest.class);
        return suite;
    }

    public void testInstance() {
        Function equInt = this.ff.function("UniqueInterval", new Expression[]{this.ff.literal((Object)this.featureCollection)});
        UniqueIntervalFunctionTest.assertNotNull((Object)equInt);
    }

    public void testGetName() {
        Function equInt = this.ff.function("UniqueInterval", new Expression[]{this.ff.literal((Object)this.featureCollection)});
        UniqueIntervalFunctionTest.assertEquals((String)"UniqueInterval", (String)equInt.getName());
    }

    public void testSetClasses() throws Exception {
        Literal classes = this.ff.literal(3);
        PropertyName exp = this.ff.property("foo");
        UniqueIntervalFunction func = (UniqueIntervalFunction)this.ff.function("UniqueInterval", new Expression[]{exp, classes});
        UniqueIntervalFunctionTest.assertEquals((int)3, (int)func.getClasses());
        func.setClasses(12);
        UniqueIntervalFunctionTest.assertEquals((int)12, (int)func.getClasses());
    }

    public void testEvaluate() throws Exception {
        Literal classes = this.ff.literal(2);
        PropertyName exp = this.ff.property("foo");
        UniqueIntervalFunction func = (UniqueIntervalFunction)this.ff.function("UniqueInterval", new Expression[]{exp, classes});
        Object result = func.evaluate((Object)this.featureCollection);
        UniqueIntervalFunctionTest.assertTrue((boolean)(result instanceof ExplicitClassifier));
        ExplicitClassifier classifier = (ExplicitClassifier)result;
        UniqueIntervalFunctionTest.assertEquals((int)2, (int)classifier.getSize());
        UniqueIntervalFunctionTest.assertEquals((int)classifier.values[0].size(), (int)classifier.values[1].size());
        UniqueIntervalFunctionTest.assertFalse((boolean)classifier.values[0].removeAll(classifier.values[1]));
    }
}

